/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoAllProperties;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddAfter;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddBefore;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.model.TestObjectInfo;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.eclipse.wb.tests.designer.tests.common.PropertyWithTitle;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class ObjectInfoTest
extends DesignerTestCase {
    @Test
    public void test_getProperties() throws Exception {
        TestObjectInfo object = new TestObjectInfo();
        Object[] properties = object.getProperties();
        Assertions.assertThat((Object[])properties).isEmpty();
    }

    @Test
    public void test_getProperties_allProperties() throws Exception {
        final PropertyWithTitle someProperty = new PropertyWithTitle("some");
        TestObjectInfo object = new TestObjectInfo(){

            protected List<Property> getPropertyList() throws Exception {
                List properties = super.getPropertyList();
                properties.add(someProperty);
                return properties;
            }
        };
        Assertions.assertThat((Object[])object.getProperties()).containsOnly((Object[])new Property[]{someProperty});
        object.addBroadcastListener(new ObjectInfoAllProperties(){

            public void invoke(ObjectInfo o, List<Property> properties) throws Exception {
                properties.clear();
            }
        });
        Assertions.assertThat((Object[])object.getProperties()).isEmpty();
    }

    @Test
    public void test_getProperties_sorted() throws Exception {
        final PropertyWithTitle aProperty = new PropertyWithTitle("a");
        final PropertyWithTitle bProperty = new PropertyWithTitle("b");
        final PropertyWithTitle cProperty = new PropertyWithTitle("c");
        TestObjectInfo object = new TestObjectInfo(){

            protected List<Property> getPropertyList() throws Exception {
                List properties = super.getPropertyList();
                properties.add(bProperty);
                properties.add(aProperty);
                properties.add(cProperty);
                return properties;
            }
        };
        Object[] properties = object.getProperties();
        Assertions.assertThat((Object[])properties).hasSize(3);
        ObjectInfoTest.assertSame((Object)((Object)aProperty), (Object)properties[0]);
        ObjectInfoTest.assertSame((Object)((Object)bProperty), (Object)properties[1]);
        ObjectInfoTest.assertSame((Object)((Object)cProperty), (Object)properties[2]);
    }

    @Test
    public void test_getPropertyList() throws Exception {
        TestObjectInfo object = new TestObjectInfo();
        List properties = (List)ReflectionUtils.invokeMethod((Object)((Object)object), (String)"getPropertyList()", (Object[])new Object[0]);
        Assertions.assertThat((List)properties).isEmpty();
    }

    @Test
    public void test_getPropertyByTitle() throws Exception {
        final PropertyWithTitle firstProperty = new PropertyWithTitle("first");
        final PropertyWithTitle secondProperty = new PropertyWithTitle("second");
        TestObjectInfo object = new TestObjectInfo(){

            protected List<Property> getPropertyList() throws Exception {
                List properties = super.getPropertyList();
                properties.add(firstProperty);
                properties.add(secondProperty);
                return properties;
            }
        };
        ObjectInfoTest.assertSame((Object)((Object)firstProperty), (Object)object.getPropertyByTitle("first"));
        ObjectInfoTest.assertSame((Object)((Object)secondProperty), (Object)object.getPropertyByTitle("second"));
        ObjectInfoTest.assertSame(null, (Object)object.getPropertyByTitle("noSuchProperty"));
    }

    @Test
    public void test_map() throws Exception {
        TestObjectInfo object = new TestObjectInfo();
        ObjectInfoTest.assertNull((Object)object.getArbitraryValue((Object)object));
        Assertions.assertThat((Map)object.getArbitraries()).isEmpty();
        object.putArbitraryValue((Object)object, (Object)this);
        ObjectInfoTest.assertSame((Object)((Object)this), (Object)object.getArbitraryValue((Object)object));
        Map arbitraries = object.getArbitraries();
        Assertions.assertThat((Map)arbitraries).isNotEmpty();
        Set arbitrariesSet = arbitraries.entrySet();
        Assertions.assertThat(arbitrariesSet).hasSize(1);
        Map.Entry entry = arbitrariesSet.iterator().next();
        ObjectInfoTest.assertSame((Object)((Object)object), entry.getKey());
        ObjectInfoTest.assertSame((Object)((Object)this), entry.getValue());
        object.removeArbitraryValue((Object)object);
        ObjectInfoTest.assertNull((Object)object.getArbitraryValue((Object)object));
        Assertions.assertThat((Map)object.getArbitraries()).isEmpty();
    }

    @Test
    public void test_getUnderlyingModel() throws Exception {
        TestObjectInfo object = new TestObjectInfo();
        ObjectInfoTest.assertSame((Object)((Object)object), (Object)object.getUnderlyingModel());
    }

    @Test
    public void test_setParent() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child = new TestObjectInfo("child");
        child.setParent(parent);
        ObjectInfoTest.assertSame((Object)((Object)parent), (Object)child.getParent());
        Assertions.assertThat((List)parent.getChildren()).isEmpty();
    }

    @Test
    public void test_isRoot() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child_1 = new TestObjectInfo("child_1");
        parent.addChild(child_1);
        ObjectInfoTest.assertSame((Object)((Object)parent), (Object)child_1.getRoot());
        ObjectInfoTest.assertTrue((boolean)parent.isRoot());
        ObjectInfoTest.assertFalse((boolean)child_1.isRoot());
    }

    @Test
    public void test_isDeleted() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child = new TestObjectInfo("child");
        ObjectInfoTest.assertFalse((boolean)child.isDeleted());
        parent.addChild(child);
        ObjectInfoTest.assertFalse((boolean)child.isDeleted());
        parent.removeChild(child);
        ObjectInfoTest.assertTrue((boolean)child.isDeleted());
    }

    @Test
    public void test_isParentOf() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child_1 = new TestObjectInfo("child_1");
        TestObjectInfo child_2 = new TestObjectInfo("child_2");
        TestObjectInfo child_1_1 = new TestObjectInfo("child_1_1");
        parent.addChild(child_1);
        parent.addChild(child_2);
        child_1.addChild(child_1_1);
        ObjectInfoTest.assertFalse((boolean)parent.isParentOf(null));
        ObjectInfoTest.assertFalse((boolean)parent.isParentOf(parent));
        ObjectInfoTest.assertTrue((boolean)parent.isParentOf(child_1));
        ObjectInfoTest.assertTrue((boolean)parent.isParentOf(child_2));
        ObjectInfoTest.assertTrue((boolean)child_1.isParentOf(child_1_1));
        ObjectInfoTest.assertTrue((boolean)parent.isParentOf(child_1_1));
        ObjectInfoTest.assertFalse((boolean)child_2.isParentOf(child_1_1));
    }

    @Test
    public void test_isParentOf_whenRemove_1() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child_1 = new TestObjectInfo("child_1");
        TestObjectInfo child_1_1 = new TestObjectInfo("child_1_1");
        parent.addChild(child_1);
        child_1.addChild(child_1_1);
        ObjectInfoTest.assertTrue((boolean)parent.isParentOf(child_1));
        ObjectInfoTest.assertTrue((boolean)parent.isParentOf(child_1_1));
        parent.removeChild(child_1);
        ObjectInfoTest.assertFalse((boolean)parent.isParentOf(child_1));
        ObjectInfoTest.assertFalse((boolean)parent.isParentOf(child_1_1));
    }

    @Test
    public void test_isParentOf_whenRemove_2() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child_1 = new TestObjectInfo("child_1");
        TestObjectInfo child_1_1 = new TestObjectInfo("child_1_1");
        parent.addChild(child_1);
        child_1.addChild(child_1_1);
        ObjectInfoTest.assertTrue((boolean)parent.isParentOf(child_1));
        ObjectInfoTest.assertTrue((boolean)parent.isParentOf(child_1_1));
        child_1.removeChild(child_1_1);
        ObjectInfoTest.assertTrue((boolean)parent.isParentOf(child_1));
        ObjectInfoTest.assertFalse((boolean)parent.isParentOf(child_1_1));
    }

    @Test
    public void test_isItOrParentOf() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child_1 = new TestObjectInfo("child_1");
        TestObjectInfo child_2 = new TestObjectInfo("child_2");
        parent.addChild(child_1);
        parent.addChild(child_2);
        ObjectInfoTest.assertFalse((boolean)parent.isItOrParentOf(null));
        ObjectInfoTest.assertTrue((boolean)parent.isItOrParentOf(parent));
        ObjectInfoTest.assertTrue((boolean)parent.isItOrParentOf(child_1));
        ObjectInfoTest.assertTrue((boolean)parent.isItOrParentOf(child_2));
        ObjectInfoTest.assertFalse((boolean)child_1.isItOrParentOf(child_2));
    }

    @Test
    public void test_getParent() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child_1 = new TestObjectInfo("child_1");
        TestObjectInfo child_2 = new TestObjectInfo("child_2");
        TestObjectInfo child_1_1 = new TestObjectInfo("child_1_1");
        parent.addChild(child_1);
        parent.addChild(child_2);
        child_1.addChild(child_1_1);
        ArrayList<TestObjectInfo> parents = new ArrayList<TestObjectInfo>();
        parents.add(parent);
        parents.add(child_1);
        ObjectInfoTest.assertSame((Object)((Object)child_1), (Object)child_1_1.getParent(parents));
        parents = new ArrayList();
        parents.add(parent);
        parents.add(child_1);
        ObjectInfoTest.assertSame((Object)((Object)parent), (Object)child_2.getParent(parents));
        parents = new ArrayList();
        parents.add(parent);
        ObjectInfoTest.assertSame((Object)((Object)parent), (Object)child_1_1.getParent(parents));
        parents = new ArrayList();
        parents.add(child_1);
        ObjectInfoTest.assertNull((Object)child_2.getParent(parents));
    }

    @Test
    public void test_addChild_1() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child_1 = new TestObjectInfo("child_1");
        TestObjectInfo child_2 = new TestObjectInfo("child_2");
        final StringBuffer buffer = new StringBuffer();
        parent.addBroadcastListener(new ObjectInfoChildAddBefore(){

            public void invoke(ObjectInfo _parent, ObjectInfo _child, ObjectInfo[] nextChild) {
                buffer.append("childAddBefore " + String.valueOf(_parent) + " " + String.valueOf(_child) + "\n");
            }
        });
        parent.addBroadcastListener(new ObjectInfoChildAddAfter(){

            public void invoke(ObjectInfo _parent, ObjectInfo _child) {
                buffer.append("childAddAfter " + String.valueOf(_parent) + " " + String.valueOf(_child) + "\n");
            }
        });
        parent.addChild(child_1);
        parent.addChild(child_2);
        ObjectInfoTest.assertArrayEquals((Object[])new Object[]{child_1, child_2}, (Object[])parent.getChildren().toArray());
        ObjectInfoTest.assertSame((Object)((Object)parent), (Object)child_1.getParent());
        ObjectInfoTest.assertSame((Object)((Object)parent), (Object)child_2.getParent());
        ObjectInfoTest.assertEquals((int)0, (int)parent.getChildren(JavaInfo.class).size());
        ObjectInfoTest.assertEquals((int)2, (int)parent.getChildren(TestObjectInfo.class).size());
        ObjectInfoTest.assertEquals((int)2, (int)parent.getChildren(ObjectInfo.class).size());
        ObjectInfoTest.assertEquals((Object)ObjectInfoTest.getSourceDQ("childAddBefore parent child_1", "childAddAfter parent child_1", "childAddBefore parent child_2", "childAddAfter parent child_2"), (Object)buffer.toString());
    }

    @Test
    public void test_addChild_2() throws Exception {
        TestObjectInfo parent = new TestObjectInfo();
        TestObjectInfo child_1 = new TestObjectInfo();
        TestObjectInfo child_2 = new TestObjectInfo();
        TestObjectInfo child_3 = new TestObjectInfo();
        parent.addChild(child_1);
        parent.addChild(child_2);
        parent.addChild(child_3, child_2);
        ObjectInfoTest.assertArrayEquals((Object[])new Object[]{child_1, child_3, child_2}, (Object[])parent.getChildren().toArray());
        ObjectInfoTest.assertSame((Object)((Object)parent), (Object)child_1.getParent());
        ObjectInfoTest.assertSame((Object)((Object)parent), (Object)child_2.getParent());
        ObjectInfoTest.assertSame((Object)((Object)parent), (Object)child_3.getParent());
    }

    @Test
    public void test_addChildFirst() throws Exception {
        TestObjectInfo parent = new TestObjectInfo();
        TestObjectInfo child_1 = new TestObjectInfo();
        TestObjectInfo child_2 = new TestObjectInfo();
        TestObjectInfo child_3 = new TestObjectInfo();
        parent.addChild(child_1);
        parent.addChild(child_2);
        parent.addChildFirst(child_3);
        Assertions.assertThat((List)parent.getChildren()).containsExactly((Object[])new ObjectInfo[]{child_3, child_1, child_2});
    }

    @Test
    public void test_moveChild() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child_1 = new TestObjectInfo("child_1");
        TestObjectInfo child_2 = new TestObjectInfo("child_2");
        TestObjectInfo child_3 = new TestObjectInfo("child_3");
        parent.addChild(child_1);
        parent.addChild(child_2);
        parent.addChild(child_3);
        final StringBuffer buffer = new StringBuffer();
        parent.addBroadcastListener(new ObjectEventListener(){

            public void childMoveBefore(ObjectInfo _parent, ObjectInfo _child, ObjectInfo _nextChild) {
                buffer.append("childMoveBefore " + String.valueOf(_parent) + " " + String.valueOf(_child) + " " + String.valueOf(_nextChild) + "\n");
            }

            public void childMoveAfter(ObjectInfo _parent, ObjectInfo _child, ObjectInfo _nextChild, int oldIndex, int newIndex) {
                buffer.append("childMoveAfter " + String.valueOf(_parent) + " " + String.valueOf(_child) + " " + String.valueOf(_nextChild) + "\n");
            }
        });
        buffer.setLength(0);
        parent.moveChild(child_3, child_1);
        ObjectInfoTest.assertArrayEquals((Object[])new Object[]{child_3, child_1, child_2}, (Object[])parent.getChildren().toArray());
        ObjectInfoTest.assertEquals((Object)ObjectInfoTest.getSourceDQ("childMoveBefore parent child_3 child_1", "childMoveAfter parent child_3 child_1"), (Object)buffer.toString());
        buffer.setLength(0);
        parent.moveChild(child_1, null);
        ObjectInfoTest.assertArrayEquals((Object[])new Object[]{child_3, child_2, child_1}, (Object[])parent.getChildren().toArray());
        ObjectInfoTest.assertEquals((Object)ObjectInfoTest.getSourceDQ("childMoveBefore parent child_1 null", "childMoveAfter parent child_1 null"), (Object)buffer.toString());
    }

    @Test
    public void test_moveChild_beforeItself() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child_1 = new TestObjectInfo("child_1");
        TestObjectInfo child_2 = new TestObjectInfo("child_2");
        parent.addChild(child_1);
        parent.addChild(child_2);
        parent.moveChild(child_2, child_2);
        ObjectInfoTest.assertArrayEquals((Object[])new Object[]{child_1, child_2}, (Object[])parent.getChildren().toArray());
    }

    @Test
    public void test_removeChild() throws Exception {
        TestObjectInfo parent = new TestObjectInfo();
        TestObjectInfo child = new TestObjectInfo();
        ObjectInfoTest.assertTrue((boolean)parent.getChildren().isEmpty());
        parent.addChild(child);
        ObjectInfoTest.assertEquals((int)1, (int)parent.getChildren().size());
        ObjectInfoTest.assertSame((Object)((Object)child), parent.getChildren().get(0));
        ObjectInfoTest.assertSame((Object)((Object)parent), (Object)child.getParent());
        parent.removeChild(child);
        ObjectInfoTest.assertTrue((boolean)parent.getChildren().isEmpty());
        ObjectInfoTest.assertSame((Object)((Object)parent), (Object)child.getParent());
    }

    @Test
    public void test_replaceChild() throws Exception {
        TestObjectInfo parent = new TestObjectInfo();
        TestObjectInfo child1 = new TestObjectInfo();
        TestObjectInfo child2 = new TestObjectInfo();
        TestObjectInfo newChild = new TestObjectInfo();
        parent.addChild(child1);
        parent.addChild(child2);
        ObjectInfoTest.assertEquals((int)2, (int)parent.getChildren().size());
        ObjectInfoTest.assertSame((Object)((Object)child1), parent.getChildren().get(0));
        ObjectInfoTest.assertSame((Object)((Object)child2), parent.getChildren().get(1));
        parent.replaceChild(child1, newChild);
        ObjectInfoTest.assertEquals((int)2, (int)parent.getChildren().size());
        ObjectInfoTest.assertSame((Object)((Object)newChild), parent.getChildren().get(0));
        ObjectInfoTest.assertSame((Object)((Object)child2), parent.getChildren().get(1));
    }

    @Test
    public void test_broadcast_ObjectEventListener_refresh() throws Exception {
        TestObjectInfo parent = new TestObjectInfo();
        TestObjectInfo child = new TestObjectInfo();
        parent.addChild(child);
        ObjectEventListener listener = (ObjectEventListener)Mockito.mock(ObjectEventListener.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{listener});
        parent.addBroadcastListener(listener);
        try {
            child.refresh();
            ObjectInfoTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        inOrder.verifyNoMoreInteractions();
        parent.refresh();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshDispose();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshBeforeCreate();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshAfterCreate0();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshAfterCreate();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshAfterCreate2();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshFinallyRefresh();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshed();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshed2();
        inOrder.verifyNoMoreInteractions();
        Mockito.clearInvocations((Object[])new ObjectEventListener[]{listener});
        try {
            parent.startEdit();
        }
        finally {
            parent.endEdit();
        }
        ((ObjectEventListener)inOrder.verify((Object)listener)).endEdit_aboutToRefresh();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshDispose();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshBeforeCreate();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshAfterCreate0();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshAfterCreate();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshAfterCreate2();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshFinallyRefresh();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshed();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshed2();
        inOrder.verifyNoMoreInteractions();
        Mockito.clearInvocations((Object[])new ObjectEventListener[]{listener});
        try {
            child.startEdit();
        }
        finally {
            child.endEdit();
        }
        ((ObjectEventListener)inOrder.verify((Object)listener)).endEdit_aboutToRefresh();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshDispose();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshBeforeCreate();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshAfterCreate0();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshAfterCreate();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshAfterCreate2();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshFinallyRefresh();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshed();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshed2();
        inOrder.verifyNoMoreInteractions();
        Mockito.clearInvocations((Object[])new ObjectEventListener[]{listener});
        parent.putArbitraryValue("ObjectInfo: don't send refreshed() broadcast", Boolean.FALSE);
        try {
            parent.refresh();
        }
        finally {
            parent.removeArbitraryValue("ObjectInfo: don't send refreshed() broadcast");
        }
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshDispose();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshBeforeCreate();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshAfterCreate0();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshAfterCreate();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshAfterCreate2();
        ((ObjectEventListener)inOrder.verify((Object)listener)).refreshFinallyRefresh();
        inOrder.verifyNoMoreInteractions();
        Mockito.clearInvocations((Object[])new ObjectEventListener[]{listener});
        parent.removeBroadcastListener(listener);
        parent.refresh();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void test_refreshLight() throws Exception {
        TestObjectInfo object = new TestObjectInfo();
        object.refreshLight();
    }

    @Test
    public void test_broadcast() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child_1 = new TestObjectInfo("child_1");
        TestObjectInfo child_2 = new TestObjectInfo("child_2");
        final StringBuffer buffer = new StringBuffer();
        parent.addBroadcastListener(new ObjectInfoChildAddBefore(){

            public void invoke(ObjectInfo _parent, ObjectInfo _child, ObjectInfo[] nextChild) {
                buffer.append("childAddBefore " + String.valueOf(_parent) + " " + String.valueOf(_child) + "\n");
            }
        });
        parent.addBroadcastListener(new ObjectInfoChildAddAfter(){

            public void invoke(ObjectInfo _parent, ObjectInfo _child) {
                buffer.append("childAddAfter " + String.valueOf(_parent) + " " + String.valueOf(_child) + "\n");
            }
        });
        ObjectEventListener listener = new ObjectEventListener(){

            public void childRemoveBefore(ObjectInfo _parent, ObjectInfo _child) throws Exception {
                buffer.append("childRemoveBefore " + String.valueOf(_parent) + " " + String.valueOf(_child) + "\n");
            }
        };
        parent.addBroadcastListener(listener);
        parent.addChild(child_1);
        child_1.addChild(child_2);
        ObjectInfoTest.assertEquals((Object)"childAddBefore parent child_1\nchildAddAfter parent child_1\nchildAddBefore child_1 child_2\nchildAddAfter child_1 child_2\n", (Object)buffer.toString());
        buffer.setLength(0);
        parent.removeBroadcastListener(listener);
        ObjectInfoTest.assertEquals((Object)"", (Object)buffer.toString());
        parent.removeChild(child_1);
        ObjectInfoTest.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    public void test_broadcast_duplicate() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child = new TestObjectInfo("child");
        final StringBuffer buffer = new StringBuffer();
        ObjectInfoChildAddBefore listener = new ObjectInfoChildAddBefore(){

            public void invoke(ObjectInfo _parent, ObjectInfo _child, ObjectInfo[] nextChild) {
                buffer.append("childAddBefore " + String.valueOf(_parent) + " " + String.valueOf(_child) + "\n");
            }
        };
        parent.addBroadcastListener(listener);
        parent.addBroadcastListener(listener);
        parent.addChild(child);
        ObjectInfoTest.assertEquals((Object)"childAddBefore parent child\n", (Object)buffer.toString());
    }

    @Test
    public void test_broadcast_autoRemove_whenRemoveObject() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child = new TestObjectInfo("child");
        parent.addChild(child);
        final StringBuffer buffer = new StringBuffer();
        ObjectEventListener listener = new ObjectEventListener(){

            public void dispose() throws Exception {
                buffer.append("dispose");
            }
        };
        child.addBroadcastListener(listener);
        child.getBroadcastObject().dispose();
        ObjectInfoTest.assertEquals((Object)"dispose", (Object)buffer.toString());
        buffer.setLength(0);
        parent.removeChild(child);
        parent.refresh();
        child.getBroadcastObject().dispose();
        ObjectInfoTest.assertEquals((Object)"", (Object)buffer.toString());
        buffer.setLength(0);
    }

    @Test
    public void test_broadcast_autoRemove_whenRemoveParent() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child_1 = new TestObjectInfo("child");
        TestObjectInfo child_2 = new TestObjectInfo("child2");
        parent.addChild(child_1);
        child_1.addChild(child_2);
        final StringBuffer buffer = new StringBuffer();
        ObjectEventListener listener = new ObjectEventListener(){

            public void dispose() throws Exception {
                buffer.append("dispose");
            }
        };
        child_2.addBroadcastListener(listener);
        child_2.getBroadcastObject().dispose();
        ObjectInfoTest.assertEquals((Object)"dispose", (Object)buffer.toString());
        buffer.setLength(0);
        parent.removeChild(child_1);
        parent.refresh();
        child_2.getBroadcastObject().dispose();
        ObjectInfoTest.assertEquals((Object)"", (Object)buffer.toString());
        buffer.setLength(0);
    }

    @Test
    public void test_addChild_otherNext() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        final TestObjectInfo child_1 = new TestObjectInfo("child_1");
        TestObjectInfo child_2 = new TestObjectInfo("child_2");
        TestObjectInfo child_3 = new TestObjectInfo("child_3");
        parent.addChild(child_1, null);
        parent.addChild(child_2, null);
        ObjectInfoChildAddBefore listener = new ObjectInfoChildAddBefore(){

            public void invoke(ObjectInfo _parent, ObjectInfo _child, ObjectInfo[] nextChild) {
                if (nextChild[0] == null) {
                    nextChild[0] = child_1;
                }
            }
        };
        parent.addBroadcastListener(listener);
        parent.addChild(child_3, null);
        List children = parent.getChildren();
        ObjectInfoTest.assertEquals((int)3, (int)children.size());
        ObjectInfoTest.assertSame((Object)((Object)child_3), children.get(0));
        ObjectInfoTest.assertSame((Object)((Object)child_1), children.get(1));
        ObjectInfoTest.assertSame((Object)((Object)child_2), children.get(2));
    }

    @Test
    public void test_broadcast_targetBroadcastListener() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child = new TestObjectInfo("child");
        parent.addChild(child);
        final StringBuffer buffer = new StringBuffer();
        ObjectInfoChildAddBefore listener = new ObjectInfoChildAddBefore(){

            public void invoke(ObjectInfo _parent, ObjectInfo _child, ObjectInfo[] nextChild) {
                buffer.append("childAddBefore " + String.valueOf(_parent) + " " + String.valueOf(_child) + "\n");
            }
        };
        child.addBroadcastListener(listener);
        child.targetBroadcastListener(parent);
        parent.removeChild(child);
        parent.refresh();
        TestObjectInfo child2 = new TestObjectInfo("child2");
        ObjectInfoTest.assertEquals((int)0, (int)buffer.length());
        parent.addChild(child2);
        ObjectInfoTest.assertEquals((Object)"childAddBefore parent child2\n", (Object)buffer.toString());
    }

    @Test
    public void test_broadcast_interface() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        final StringBuffer buffer = new StringBuffer();
        BroadcastTestInterface listener = new BroadcastTestInterface(){

            @Override
            public void invoke() {
                buffer.append("invoke");
            }
        };
        parent.addBroadcastListener(listener);
        ((BroadcastTestInterface)parent.getBroadcast(BroadcastTestInterface.class)).invoke();
        ObjectInfoTest.assertEquals((Object)"invoke", (Object)buffer.toString());
        buffer.setLength(0);
        parent.removeBroadcastListener(listener);
        ((BroadcastTestInterface)parent.getBroadcast(BroadcastTestInterface.class)).invoke();
        ObjectInfoTest.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    public void test_broadcast_deepHierarchy() throws Exception {
        TestObjectInfo object = new TestObjectInfo("object");
        StringBuffer buffer = new StringBuffer();
        class Listener_2
        extends 1Listener_1 {
            private final /* synthetic */ StringBuffer val$buffer;

            Listener_2(StringBuffer stringBuffer) {
                this.val$buffer = stringBuffer;
                class Listener_1
                extends ObjectEventListener {
                    Listener_1() {
                    }
                }
            }

            public void dispose() throws Exception {
                this.val$buffer.append("invoke");
            }
        }
        Listener_2 listener = new Listener_2(buffer);
        object.addBroadcastListener((Object)listener);
        ((ObjectEventListener)object.getBroadcast(ObjectEventListener.class)).dispose();
        ObjectInfoTest.assertEquals((Object)"invoke", (Object)buffer.toString());
        buffer.setLength(0);
        object.removeBroadcastListener((Object)listener);
        ((ObjectEventListener)object.getBroadcast(ObjectEventListener.class)).dispose();
        ObjectInfoTest.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    public void test_editOperation() throws Exception {
        final StringBuffer buffer = new StringBuffer();
        TestObjectInfo root = new TestObjectInfo(){

            protected void saveEdit() throws Exception {
                buffer.append("saveEdit of root");
            }
        };
        TestObjectInfo object = new TestObjectInfo(){

            protected void saveEdit() throws Exception {
                buffer.append("saveEdit of object");
            }
        };
        root.addChild(object);
        object.startEdit();
        object.endEdit();
        ObjectInfoTest.assertEquals((Object)"saveEdit of root", (Object)buffer.toString());
    }

    @Test
    public void test_endEdit_aboutToRefresh() throws Exception {
        final AtomicInteger saveCount = new AtomicInteger();
        final TestObjectInfo object = new TestObjectInfo(){

            protected void saveEdit() throws Exception {
                saveCount.getAndIncrement();
            }
        };
        final AtomicBoolean wasFired = new AtomicBoolean();
        object.addBroadcastListener(new ObjectEventListener(){

            public void endEdit_aboutToRefresh() throws Exception {
                wasFired.set(true);
                object.startEdit();
                object.endEdit();
            }
        });
        object.startEdit();
        object.endEdit();
        ObjectInfoTest.assertTrue((boolean)wasFired.get());
        ObjectInfoTest.assertEquals((int)1, (int)saveCount.get());
    }

    @Test
    public void test_delete() throws Exception {
        TestObjectInfo parent = new TestObjectInfo("parent");
        TestObjectInfo child = new TestObjectInfo("child");
        parent.addChild(child);
        ObjectInfoTest.assertTrue((boolean)parent.getChildren().contains((Object)child));
        ObjectInfoTest.assertFalse((boolean)child.canDelete());
        child.delete();
        ObjectInfoTest.assertTrue((boolean)parent.getChildren().contains((Object)child));
    }

    @Test
    public void test_visiting() throws Exception {
        TestObjectInfo parent = new TestObjectInfo();
        TestObjectInfo child_1 = new TestObjectInfo();
        TestObjectInfo child_2 = new TestObjectInfo();
        TestObjectInfo child_3 = new TestObjectInfo();
        parent.addChild(child_1);
        parent.addChild(child_2);
        child_2.addChild(child_3);
        final ObjectInfo[] expectedSequence = new ObjectInfo[]{parent, child_1, child_2, child_3};
        parent.accept(new ObjectInfoVisitor(){
            private int m_index;

            public boolean visit(ObjectInfo objectInfo) throws Exception {
                ObjectInfoTest.assertSame((Object)expectedSequence[this.m_index++], (Object)objectInfo);
                return true;
            }
        });
    }

    public static interface BroadcastTestInterface {
        public void invoke();
    }
}

