/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.controls.CCombo3;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescriptionJava;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipTextProvider;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.description.LocalUniqueVariableDescription;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;

public abstract class AbstractJavaInfoRelatedTest
extends AbstractJavaTest {
    private static Shell TEST_COMBO_SHELL;
    private static CCombo3 TEST_COMBO;

    public static void configureDefaults(ToolkitDescriptionJava toolkit) {
        IPreferenceStore preferences = toolkit.getPreferences();
        preferences.setValue("textVariable.mode", 2);
        preferences.setToDefault("textVariable.template");
        preferences.setToDefault("textVariable.wordsLimit");
        preferences.setToDefault("putNameIntoComponent");
        NamesManager.setNameDescriptions((ToolkitDescription)toolkit, Collections.emptyList());
        GenerationSettings generationSettings = toolkit.getGenerationSettings();
        generationSettings.setDefaultDeduceSettings(false);
        generationSettings.setDeduceSettings(false);
        generationSettings.setDefaultStatement(BlockStatementGeneratorDescription.INSTANCE);
        generationSettings.setDefaultVariable(LocalUniqueVariableDescription.INSTANCE);
        generationSettings.setStatement(generationSettings.getDefaultStatement());
        generationSettings.setVariable(generationSettings.getDefaultVariable());
        preferences.setToDefault("codeGeneration.forcedMethod");
        preferences.setToDefault("variable.fieldUnique.prefixThis");
        preferences.setToDefault("layout.inheritLayoutOfParent");
        preferences.setToDefault("layout.default");
        preferences.setValue("general.directEditAfterAdd", false);
    }

    protected static Statement getStatement(JavaInfo javaInfo, int ... indexes) {
        Block block;
        ASTNode node = javaInfo.getCreationSupport().getNode();
        if (node instanceof MethodDeclaration) {
            AbstractJavaInfoRelatedTest.assertInstanceOf(ThisCreationSupport.class, (Object)javaInfo.getCreationSupport());
            block = ((MethodDeclaration)node).getBody();
        } else {
            block = AstNodeUtils.getEnclosingBlock((ASTNode)node);
        }
        return AbstractJavaInfoRelatedTest.getStatement(block, indexes);
    }

    protected static void assertTarget(StatementTarget target, Block expectedBlock, Statement expectedStatement, boolean expectedBefore) {
        StatementTarget expectedTarget = new StatementTarget(expectedBlock, expectedStatement, expectedBefore);
        AbstractJavaInfoRelatedTest.assertEquals((Object)expectedTarget.toString(), (Object)target.toString());
    }

    public static void printHierarchySource() {
        JavaInfo javaInfo = EditorState.getActiveJavaInfo();
        AbstractJavaInfoRelatedTest.printHierarchySource(javaInfo);
    }

    public static void assertHierarchy(String ... lines) {
        JavaInfo javaInfo = EditorState.getActiveJavaInfo();
        AbstractJavaInfoRelatedTest.assertEquals((Object)AbstractJavaInfoRelatedTest.getSourceDQ(lines), (Object)AbstractJavaInfoRelatedTest.printHierarchy(javaInfo));
    }

    protected static String printHierarchy(JavaInfo root) {
        final StringBuffer buffer = new StringBuffer();
        root.accept(new ObjectInfoVisitor(){
            private int m_level;

            public boolean visit(ObjectInfo objectInfo) throws Exception {
                buffer.append(StringUtils.repeat((String)"\t", (int)this.m_level));
                buffer.append(objectInfo.toString());
                buffer.append("\n");
                ++this.m_level;
                return true;
            }

            public void endVisit(ObjectInfo objectInfo) throws Exception {
                --this.m_level;
            }
        });
        return buffer.toString();
    }

    private static void printHierarchySource(JavaInfo root) {
        final StringBuffer buffer = new StringBuffer();
        root.accept(new ObjectInfoVisitor(){
            private int m_level;

            public boolean visit(ObjectInfo objectInfo) throws Exception {
                buffer.append('\"');
                buffer.append(StringUtils.repeat((String)"  ", (int)this.m_level));
                String line = objectInfo.toString();
                line = line.replace('\"', '\'');
                buffer.append(StringUtilities.escapeJava((String)line));
                buffer.append('\"');
                buffer.append(",\n");
                ++this.m_level;
                return true;
            }

            public void endVisit(ObjectInfo objectInfo) throws Exception {
                --this.m_level;
            }
        });
        String result = buffer.toString();
        result = StringUtils.removeEnd((String)result, (String)",\n");
        System.out.println(result);
    }

    public static <T extends JavaInfo> T getJavaInfoByName(final String name) throws Exception {
        final AtomicReference result = new AtomicReference();
        EditorState.getActiveJavaInfo().accept0(new ObjectInfoVisitor(){

            public void endVisit(ObjectInfo objectInfo) throws Exception {
                JavaInfo javaInfo;
                if (result.get() != null) {
                    return;
                }
                if (objectInfo instanceof JavaInfo && this.isRequestedJavaInfo(javaInfo = (JavaInfo)objectInfo)) {
                    result.set(javaInfo);
                }
            }

            private boolean isRequestedJavaInfo(JavaInfo javaInfo) throws Exception {
                VariableSupport variable = javaInfo.getVariableSupport();
                if (variable.hasName() && name.equals(variable.getName())) {
                    return true;
                }
                try {
                    if (name.equals(variable.getTitle())) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            }
        });
        return (T)((JavaInfo)result.get());
    }

    protected static void printEditorLinesSource() {
        AstEditor editor = EditorState.getActiveJavaInfo().getEditor();
        String[] lines = StringUtils.split((String)editor.getSource(), (String)"\r\n");
        System.out.println(AbstractJavaInfoRelatedTest.getLinesForSourceDQ(lines));
    }

    protected static void assertNoErrors(JavaInfo javaInfo) {
        AstEditor editor = javaInfo.getEditor();
        EditorState editorState = EditorState.get((AstEditor)editor);
        EditorState.BadNodesCollection nodes = editorState.getBadParserNodes();
        if (!nodes.isEmpty()) {
            for (EditorState.BadNodeInformation node : nodes.nodes()) {
                System.out.println("------------------ bad parser node ------------------");
                System.out.println(editor.getSource(node.getNode()));
                node.getException().printStackTrace();
            }
            AbstractJavaInfoRelatedTest.fail((String)"No parser errors expected.");
        }
        if (!(nodes = editorState.getBadRefreshNodes()).isEmpty()) {
            System.out.println("------------------ bad refresh node ------------------");
            for (EditorState.BadNodeInformation node : nodes.nodes()) {
                System.out.println(editor.getSource(node.getNode()));
                node.getException().printStackTrace();
            }
            AbstractJavaInfoRelatedTest.fail((String)"No refresh errors expected.");
        }
        if (!editorState.getWarnings().isEmpty()) {
            for (EditorWarning warning : editorState.getWarnings()) {
                System.out.println("------------------ warning ------------------");
                System.out.println(warning.getMessage());
                if (warning.getException() == null) continue;
                warning.getException().printStackTrace();
            }
            AbstractJavaInfoRelatedTest.fail((String)"No warnings expected.");
        }
    }

    protected static String[] removeFillerLines(String ... lines) {
        while (lines.length != 0 && lines[0].startsWith("// filler")) {
            lines = (String[])ArrayUtils.remove((Object[])lines, (int)0);
        }
        return lines;
    }

    public static <T extends JavaInfo> T createJavaInfo(String componentClassName) throws Exception {
        return AbstractJavaInfoRelatedTest.createJavaInfo(componentClassName, null);
    }

    public static <T extends JavaInfo> T createJavaInfo(String componentClassName, String creationId) throws Exception {
        AstEditor editor = EditorState.getActiveJavaInfo().getEditor();
        JavaInfo javaInfo = JavaInfoUtils.createJavaInfo((AstEditor)editor, (String)componentClassName, (CreationSupport)new ConstructorCreationSupport(creationId, true));
        javaInfo.putArbitraryValue((Object)"manuallyCreatedComponent", (Object)Boolean.TRUE);
        return (T)javaInfo;
    }

    protected static List<ExpressionAccessor> getGenericPropertyAccessors(GenericProperty property) throws Exception {
        return ((GenericPropertyImpl)property).getAccessors();
    }

    protected static Property[] getSubProperties(Property property) throws Exception {
        return ((IComplexPropertyEditor)property.getEditor()).getProperties(property);
    }

    protected static Property getPropertyByTitle(Property[] properties, String title) {
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            if (title.equals(property.getTitle())) {
                return property;
            }
            ++i;
        }
        return null;
    }

    protected static String getPropertyText(Property property) throws Exception {
        return (String)ReflectionUtils.invokeMethod2((Object)property.getEditor(), (String)"getText", Property.class, (Object)property);
    }

    protected static void setPropertyText(Property property, String text) throws Exception {
        ReflectionUtils.invokeMethod2((Object)property.getEditor(), (String)"setText", Property.class, String.class, (Object)property, (Object)text);
    }

    protected static String getPropertyTooltipText(IAdaptable adaptable, Property property) throws Exception {
        PropertyTooltipProvider provider = (PropertyTooltipProvider)adaptable.getAdapter(PropertyTooltipProvider.class);
        AbstractJavaInfoRelatedTest.assertInstanceOf(PropertyTooltipTextProvider.class, (Object)provider);
        PropertyTooltipTextProvider textProvider = (PropertyTooltipTextProvider)provider;
        return (String)ReflectionUtils.invokeMethod((Object)textProvider, (String)"getText(org.eclipse.wb.internal.core.model.property.Property)", (Object[])new Object[]{property});
    }

    public static String getTextEditorText(Property property) throws Exception {
        PropertyEditor editor = property.getEditor();
        return (String)ReflectionUtils.invokeMethod((Object)editor, (String)"getEditorText(org.eclipse.wb.internal.core.model.property.Property)", (Object[])new Object[]{property});
    }

    public static void setTextEditorText(Property property, String text) throws Exception {
        PropertyEditor editor = property.getEditor();
        ReflectionUtils.invokeMethod((Object)editor, (String)"setEditorText(org.eclipse.wb.internal.core.model.property.Property,java.lang.String)", (Object[])new Object[]{property, text});
    }

    protected static void openPropertyDialog(Property property) throws Exception {
        ReflectionUtils.invokeMethod((Object)property.getEditor(), (String)"openDialog(org.eclipse.wb.internal.core.model.property.Property)", (Object[])new Object[]{property});
    }

    @BeforeAll
    public static void setUpAll() throws Exception {
        TEST_COMBO_SHELL = new Shell();
        TEST_COMBO = new CCombo3((Composite)TEST_COMBO_SHELL, 0);
    }

    @AfterAll
    public static void tearDownAll() throws Exception {
        TEST_COMBO_SHELL.dispose();
    }

    protected static void addComboPropertyItems(Property property) {
        PropertyEditor propertyEditor = property.getEditor();
        String signature = "addItems(org.eclipse.wb.internal.core.model.property.Property,org.eclipse.wb.core.controls.CCombo3)";
        TEST_COMBO.removeAll();
        ReflectionUtils.invokeMethodEx((Object)propertyEditor, (String)signature, (Object[])new Object[]{property, TEST_COMBO});
    }

    protected static List<String> getComboPropertyItems() {
        ArrayList<String> items = new ArrayList<String>();
        int itemCount = TEST_COMBO.getItemCount();
        int i = 0;
        while (i < itemCount) {
            items.add(TEST_COMBO.getItem(i));
            ++i;
        }
        return items;
    }

    protected static int getComboPropertySelection() {
        return TEST_COMBO.getSelectionIndex();
    }

    protected static void setComboPropertySelection(int index) {
        TEST_COMBO.select(index);
    }

    protected static void setComboPropertySelection(Property property) {
        PropertyEditor propertyEditor = property.getEditor();
        String signature = "selectItem(org.eclipse.wb.internal.core.model.property.Property,org.eclipse.wb.core.controls.CCombo3)";
        ReflectionUtils.invokeMethodEx((Object)propertyEditor, (String)signature, (Object[])new Object[]{property, TEST_COMBO});
    }

    protected static void setComboPropertyValue(Property property, int index) {
        PropertyEditor propertyEditor = property.getEditor();
        String signature = "toPropertyEx(org.eclipse.wb.internal.core.model.property.Property,org.eclipse.wb.core.controls.CCombo3,int)";
        ReflectionUtils.invokeMethodEx((Object)propertyEditor, (String)signature, (Object[])new Object[]{property, TEST_COMBO, index});
    }
}

