/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.ImplicitFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.generation.statement.lazy.LazyStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupportUtils;
import org.eclipse.wb.internal.core.model.variable.description.LazyVariableDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JPanelInfo;
import org.eclipse.wb.internal.swing.model.layout.BorderLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.junit.jupiter.api.Test;

public class LazyTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_basic() throws Exception {
        ContainerInfo panel = this.parseLazyCode();
        LazyTest.assertEquals((int)1, (int)panel.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LazyVariableSupport variableSupport = (LazyVariableSupport)button.getVariableSupport();
        LazyTest.assertEquals((Object)"lazy: button getButton()", (Object)variableSupport.toString());
        LazyTest.assertFalse((boolean)variableSupport.canConvertLocalToField());
        LazyTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertLocalToField();
            LazyTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.convertFieldToLocal();
            LazyTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test_getReferenceExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LazyVariableSupport variableSupport = (LazyVariableSupport)button.getVariableSupport();
        NodeTarget target = LazyTest.getNodeStatementTarget((JavaInfo)panel, "getButton()", false, 0, 0);
        LazyTest.assertTrue((boolean)variableSupport.hasExpression(target));
        LazyTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        LazyTest.assertEquals((Object)"button.", (Object)variableSupport.getAccessExpression(target));
        target = LazyTest.getNodeBlockTarget((JavaInfo)panel, true, new int[0]);
        LazyTest.assertTrue((boolean)variableSupport.hasExpression(target));
        LazyTest.assertEquals((Object)"getButton()", (Object)variableSupport.getReferenceExpression(target));
        LazyTest.assertEquals((Object)"getButton().", (Object)variableSupport.getAccessExpression(target));
        TypeDeclaration targetType = LazyTest.getTypeDeclaration((JavaInfo)panel);
        NodeTarget target2 = new NodeTarget(new BodyDeclarationTarget(targetType, true));
        LazyTest.assertTrue((boolean)variableSupport.hasExpression(target2));
        LazyTest.assertEquals((Object)"getButton()", (Object)variableSupport.getReferenceExpression(target2));
        LazyTest.assertEquals((Object)"getButton().", (Object)variableSupport.getAccessExpression(target2));
    }

    @Test
    public void test_setName() throws Exception {
        ContainerInfo panel = this.parseLazyCode();
        LazyTest.assertEquals((int)1, (int)panel.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LazyVariableSupport variableSupport = (LazyVariableSupport)button.getVariableSupport();
        LazyTest.assertEquals((Object)true, (Object)variableSupport.hasName());
        LazyTest.assertEquals((Object)"button", (Object)variableSupport.getName());
        String expectedSource = this.m_lastEditor.getSource();
        expectedSource = expectedSource.replace("button", "addButton");
        expectedSource = expectedSource.replace("getButton()", "getAddButton()");
        variableSupport.setName("addButton");
        LazyTest.assertEditor(expectedSource, this.m_lastEditor);
        expectedSource = this.m_lastEditor.getSource();
        expectedSource = expectedSource.replace("addButton", "renameButton");
        expectedSource = expectedSource.replace("getAddButton()", "getRenameButton()");
        variableSupport.setName("renameButton");
        LazyTest.assertEditor(expectedSource, this.m_lastEditor);
        LazyTest.assert_creation((JavaInfo)panel);
    }

    @Test
    public void test_delete() throws Exception {
        ContainerInfo panel = this.parseLazyCode();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LazyTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    private ContainerInfo parseLazyCode() throws Exception {
        return this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "    getButton().setEnabled(false);", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "      button.setText('Lazy JButton');", "    }", "    return button;", "  }", "}");
    }

    @Test
    public void test_parse_EmptyVariable_inLazy() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  private JPanel inner;", "  public Test() {", "    add(getInner());", "  }", "  private JPanel getInner() {", "    if (inner == null) {", "      inner = new JPanel();", "      inner.setLayout(new BorderLayout());", "    }", "    return inner;", "  }", "}");
        LazyTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(getInner())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JPanel} {lazy: inner getInner()} {/new JPanel()/ /inner.setLayout(new BorderLayout())/ /inner/ /add(getInner())/}", "    {new: java.awt.BorderLayout} {empty} {/inner.setLayout(new BorderLayout())/}");
    }

    @Test
    public void test_parse_withAbstractMethod() throws Exception {
        ContainerInfo panel = this.parseContainer("public abstract class Test extends JPanel {", "  public Test() {", "    someAbstractMethod();", "  }", "  protected abstract void someAbstractMethod();", "}");
        LazyTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        panel.refresh();
        LazyTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_parse_notFirstCreate() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      int otherStatement;", "      button = new JButton();", "    }", "    return button;", "  }", "}");
        LazyTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(getButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {lazy: button getButton()} {/new JButton()/ /button/ /add(getButton())/}");
    }

    @Test
    public void test_parse_thisQualifier() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (this.button == null) {", "      this.button = new JButton();", "    }", "    return this.button;", "  }", "}");
        LazyTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/this/ /add(getButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {lazy: this.button getButton()} {/new JButton()/ /this.button/ /add(getButton())/}");
        panel.refresh();
        LazyTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_parse_methodWithEmptyReturn() throws Exception {
        this.m_ignoreCompilationProblems = true;
        this.parseContainer("import java.util.*;", "public class Test extends JPanel {", "  public Test() {", "    foo();", "  }", "  private JButton button;", "  private void foo() {", "    if (button == null) {", "    }", "    return;", "  }", "}");
        LazyTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_parse_badReturnName() throws Exception {
        this.m_ignoreCompilationProblems = true;
        this.parseContainer("import java.util.*;", "public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return noSuchName;", "  }", "}");
        LazyTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(getButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_ADD_private() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "  }", "}");
        BorderLayoutInfo borderLayout = (BorderLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = LazyTest.createJButton();
        SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
        SwingTestUtils.setLazyMethodModifier(0);
        try {
            borderLayout.command_CREATE(newComponent, "North");
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    setLayout(new BorderLayout());", "    add(getButton(), BorderLayout.NORTH);", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
        newComponent.delete();
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "  }", "}");
    }

    @Test
    public void test_ADD_public() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "  }", "}");
        BorderLayoutInfo borderLayout = (BorderLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = LazyTest.createJButton();
        SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
        SwingTestUtils.setLazyMethodModifier(3);
        try {
            borderLayout.command_CREATE(newComponent, "North");
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    setLayout(new BorderLayout());", "    add(getButton(), BorderLayout.NORTH);", "  }", "  public JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
    }

    @Test
    public void test_ADD_static() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "  }", "}");
        BorderLayoutInfo borderLayout = (BorderLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = LazyTest.createJButton();
        SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
        try {
            borderLayout.command_CREATE(newComponent, "North");
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("class Test {", "  private static JButton button;", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "    panel.add(getButton(), BorderLayout.NORTH);", "  }", "  private static JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
    }

    @Test
    public void test_ADD_innerClass() throws Exception {
        LazyTest.setFileContentSrc("test/Foo.java", this.getTestSource("// filler filler filler", "public class Foo {", "  public static class MyPanel extends JPanel {", "  }", "}"));
        LazyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = LazyTest.createComponent("test.Foo$MyPanel");
        SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
        try {
            layout.add(newComponent, null);
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("import test.Foo.MyPanel;", "// filler filler filler", "public class Test extends JPanel {", "  private MyPanel myPanel;", "  public Test() {", "    add(getMyPanel());", "  }", "  private MyPanel getMyPanel() {", "    if (myPanel == null) {", "      myPanel = new MyPanel();", "    }", "    return myPanel;", "  }", "}");
    }

    @Test
    public void test_ADD_conflictWithSuperClass() throws Exception {
        LazyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public int getButton() {", "    return 0;", "  }", "}"));
        LazyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = LazyTest.createJButton();
        SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
        try {
            layout.add(newComponent, null);
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  private JButton button;", "  public Test() {", "    add(getButton_1());", "  }", "  private JButton getButton_1() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
    }

    @Test
    public void test_ADD_typeArguments() throws Exception {
        LazyTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton<K, V> extends JButton {", "}"));
        LazyTest.setFileContentSrc("test/MyButton.wbp-component.xml", LazyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton<%keyType%, %valueType%>()]]></source>", "  </creation>", "</component>"));
        LazyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
        ComponentInfo newButton = (ComponentInfo)LazyTest.createJavaInfo("test.MyButton");
        newButton.putTemplateArgument("keyType", "java.lang.String");
        newButton.putTemplateArgument("valueType", "java.util.List<java.lang.Double>");
        ((FlowLayoutInfo)panel.getLayout()).add(newButton, null);
        this.assertEditor("import java.util.List;", "// filler filler filler filler filler", "public class Test extends JPanel {", "  private MyButton<String, List<Double>> myButton;", "  public Test() {", "    add(getMyButton());", "  }", "  private MyButton<String, List<Double>> getMyButton() {", "    if (myButton == null) {", "      myButton = new MyButton<String, List<Double>>();", "    }", "    return myButton;", "  }", "}");
    }

    @Test
    public void test_moveTarget() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "    int a;", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "      button.setText('Lazy JButton');", "    }", "    return button;", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LazyVariableSupport buttonVariable = (LazyVariableSupport)button.getVariableSupport();
        Statement requestStatement = LazyTest.getStatement((JavaInfo)panel, 1);
        StatementTarget requestTarget = new StatementTarget(requestStatement, false);
        String expectedSource = this.m_lastEditor.getSource();
        buttonVariable.ensureInstanceReadyAt(requestTarget);
        LazyTest.assertEditor(expectedSource, this.m_lastEditor);
        StatementTarget associationTarget = buttonVariable.getAssociationTarget(requestTarget);
        LazyTest.assertTarget(associationTarget, null, requestStatement, false);
    }

    @Test
    public void test_isValidStatementForChild() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "      button.setText('Lazy JButton');", "    }", "    return button;", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LazyVariableSupport buttonVariable = (LazyVariableSupport)button.getVariableSupport();
        Statement statement_1 = LazyTest.getStatement((JavaInfo)panel, 0);
        Statement statement_2 = LazyTest.getStatement((JavaInfo)panel, "getButton()", 0, 1);
        LazyTest.assertFalse((boolean)buttonVariable.isValidStatementForChild(statement_1));
        LazyTest.assertTrue((boolean)buttonVariable.isValidStatementForChild(statement_2));
    }

    @Test
    public void test_setType() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "    getButton().setEnabled(false);", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "      button.setText('Lazy JButton');", "    }", "    return button;", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LazyVariableSupport variable = (LazyVariableSupport)button.getVariableSupport();
        variable.setType("javax.swing.JTextField");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "    getButton().setEnabled(false);", "  }", "  private JTextField button;", "  private JTextField getButton() {", "    if (button == null) {", "      button = new JButton();", "      button.setText(\"Lazy JButton\");", "    }", "    return button;", "  }", "}");
        LazyTest.assertInstanceOf(LazyVariableSupport.class, (Object)button.getVariableSupport());
    }

    @Test
    public void test_tryInIfStatement() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      try {", "        button = new JButton();", "      } catch (Throwable e) {", "      }", "    }", "    return button;", "  }", "}"};
        this.parseContainer(lines);
        LazyTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(getButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {lazy: button getButton()} {/new JButton()/ /button/ /add(getButton())/}");
    }

    @Test
    public void test_deleteAccessorFromStartMethods() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
        LazyTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(getButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {lazy: button getButton()} {/new JButton()/ /button/ /add(getButton())/}");
        ExecutionFlowDescription flowDescription = this.m_lastState.getFlowDescription();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LazyVariableSupport variable = (LazyVariableSupport)button.getVariableSupport();
        MethodDeclaration accessor = variable.m_accessor;
        Assertions.assertThat((List)flowDescription.getStartMethods()).doesNotContain((Object[])new MethodDeclaration[]{accessor});
        flowDescription.addStartMethod(accessor);
        Assertions.assertThat((List)flowDescription.getStartMethods()).contains((Object[])new MethodDeclaration[]{accessor});
        button.delete();
        Assertions.assertThat((List)flowDescription.getStartMethods()).doesNotContain((Object[])new MethodDeclaration[]{accessor});
    }

    @Test
    public void test_implicitFactory_0() throws Exception {
        this.prepare_implicitFactory();
        String[] lines = new String[]{"class Test extends JPanel {", "  private MyBar bar;", "  Test() {", "    add(getBar());", "  }", "  private MyBar getBar() {", "    if (bar == null) {", "      bar = new MyBar();", "    }", "    return bar;", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        String signature = "addButton()";
        String invocationSource = "addButton()";
        ImplicitFactoryCreationSupport creationSupport = new ImplicitFactoryCreationSupport(signature, invocationSource);
        ComponentInfo newButton = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, (String)"javax.swing.JButton", (CreationSupport)creationSupport);
        SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
        ((FlowLayoutInfo)bar.getLayout()).add(newButton, null);
        this.assertEditor("class Test extends JPanel {", "  private MyBar bar;", "  private JButton button;", "  Test() {", "    add(getBar());", "  }", "  private MyBar getBar() {", "    if (bar == null) {", "      bar = new MyBar();", "      getButton();", "    }", "    return bar;", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = getBar().addButton();", "    }", "    return button;", "  }", "}");
    }

    private void prepare_implicitFactory() throws Exception {
        LazyTest.setFileContentSrc("test/MyBar.java", this.getTestSource("public class MyBar extends JPanel {", "  public JButton addButton() {", "    JButton button = new JButton();", "    add(button);", "    return button;", "  }", "}"));
        LazyTest.setFileContentSrc("test/MyBar.wbp-component.xml", LazyTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addButton'>", "      <tag name='implicitFactory' value='true'/>", "    </method>", "  </methods>", "</component>"));
        LazyTest.waitForAutoBuild();
    }

    @Test
    public void test_convert() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    BorderLayout borderLayout = new BorderLayout();", "    borderLayout.setVgap(5);", "    setLayout(borderLayout);", "  }", "}");
        BorderLayoutInfo borderLayout = (BorderLayoutInfo)panel.getLayout();
        LazyTest.assertTrue((boolean)LazyVariableSupportUtils.canConvert((JavaInfo)borderLayout));
        LazyVariableSupportUtils.convert((JavaInfo)borderLayout);
        this.assertEditor("class Test extends JPanel {", "  private BorderLayout borderLayout;", "  public Test() {", "    setLayout(getBorderLayout());", "  }", "  private BorderLayout getBorderLayout() {", "    if (borderLayout == null) {", "      borderLayout = new BorderLayout();", "      borderLayout.setVgap(5);", "    }", "    return borderLayout;", "  }", "}");
        borderLayout.delete();
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_convert_children() throws Exception {
        ContainerInfo testPanel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    JPanel panel = new JPanel();", "    panel.setBounds(42, 40, 270, 160);", "    add(panel);", "    JTextField textField = new JTextField();", "    panel.add(textField);", "    textField.setColumns(10);", "    JButton button = new JButton('New button');", "    panel.add(button);", "  }", "}");
        JPanelInfo panel = (JPanelInfo)testPanel.getChildren(JPanelInfo.class).get(0);
        LazyTest.assertEquals((int)panel.getChildren(ComponentInfo.class).size(), (int)2);
        LazyTest.assertTrue((boolean)LazyVariableSupportUtils.canConvert((JavaInfo)panel));
        LazyVariableSupportUtils.convert((JavaInfo)panel);
        this.assertEditor("class Test extends JPanel {", "  private JPanel panel;", "  public Test() {", "    setLayout(null);", "    add(getPanel());", "  }", "  private JPanel getPanel() {", "    if (panel == null) {", "      panel = new JPanel();", "      panel.setBounds(42, 40, 270, 160);", "      JTextField textField = new JTextField();", "      panel.add(textField);", "      textField.setColumns(10);", "      JButton button = new JButton('New button');", "      panel.add(button);", "    }", "    return panel;", "  }", "}");
    }
}

