/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls;

import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.SourceDescription;
import org.eclipse.wb.internal.core.nls.bundle.pure.direct.DirectSource;
import org.eclipse.wb.internal.core.nls.bundle.pure.direct.DirectSourceNewComposite;
import org.eclipse.wb.internal.core.nls.bundle.pure.direct.SourceParameters;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupport;
import org.eclipse.wb.internal.core.nls.edit.StringPropertyInfo;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.PreferencesRepairer;
import org.eclipse.wb.tests.designer.core.nls.AbstractNlsTest;
import org.eclipse.wb.tests.designer.core.nls.NlsTestUtils;
import org.junit.jupiter.api.Test;

public class SourceDirectTest
extends AbstractNlsTest {
    @Test
    public void test_notDirectCases_1() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('title');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceDirectTest.assertEquals((int)0, (int)support.getSources().length);
    }

    @Test
    public void test_notDirectCases_2() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle(getString2());", "    setName(getString('name'));", "  }", "  private static String getString2() {", "    return 'title';", "  }", "  private static String getString(String key) {", "    return key;", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceDirectTest.assertEquals((int)0, (int)support.getSources().length);
    }

    @Test
    public void test_notDirectCases_3() throws Exception {
        this.createASTCompilationUnit("test", "MyBundle.java", SourceDirectTest.getSourceDQ("package test;", "public class MyBundle {", "  public static MyBundle getBundle(String name) {", "    return new MyBundle();", "  }", "  public String getString(String key) {", "    return key;", "  }", "}"));
        SourceDirectTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle(MyBundle.getBundle('bundle.name').getString('title'));", "    setName(MyBundle.getBundle(null).getString('name'));", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceDirectTest.assertEquals((int)0, (int)support.getSources().length);
        frame.refresh();
        try {
            JFrame jFrame = (JFrame)frame.getObject();
            SourceDirectTest.assertEquals((Object)"title", (Object)jFrame.getTitle());
            SourceDirectTest.assertEquals((Object)"name", (Object)jFrame.getName());
        }
        finally {
            frame.refresh_dispose();
        }
    }

    @Test
    public void test_parse() throws Exception {
        SourceDirectTest.setFileContentSrc("test/messages.properties", SourceDirectTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceDirectTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle('test.messages').getString('frame.title')); //$NON-NLS-1$ //$NON-NLS-2$", "    setName(ResourceBundle.getBundle('test.messages').getString('frame.name')); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        AbstractSource[] sources = support.getSources();
        SourceDirectTest.assertEquals((int)1, (int)sources.length);
        DirectSource source = (DirectSource)sources[0];
        SourceDirectTest.assertEquals((Object)"Direct ResourceBundle", (Object)ReflectionUtils.invokeMethod((Object)source, (String)"getBundleComment()", (Object[])new Object[0]));
        frame.refresh();
        try {
            JFrame jFrame = (JFrame)frame.getObject();
            SourceDirectTest.assertEquals((Object)"My JFrame", (Object)jFrame.getTitle());
            SourceDirectTest.assertEquals((Object)"My name", (Object)jFrame.getName());
        }
        finally {
            frame.refresh_dispose();
        }
    }

    @Test
    public void test_parse_inConstructor() throws Exception {
        SourceDirectTest.setFileContentSrc("test/messages.properties", SourceDirectTest.getSourceDQ("button.text=My JButton"));
        SourceDirectTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JPanel {", "  public Test() {", "    add(new JButton(ResourceBundle.getBundle('test.messages').getString('button.text'))); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        NlsSupport support = NlsSupport.get((JavaInfo)panel);
        AbstractSource[] sources = support.getSources();
        SourceDirectTest.assertEquals((int)1, (int)sources.length);
        DirectSource source = (DirectSource)sources[0];
        SourceDirectTest.assertEquals((Object)"Direct ResourceBundle", (Object)ReflectionUtils.invokeMethod((Object)source, (String)"getBundleComment()", (Object[])new Object[0]));
        panel.refresh();
        try {
            JButton jButton = (JButton)button.getObject();
            SourceDirectTest.assertEquals((Object)"My JButton", (Object)jButton.getText());
        }
        finally {
            panel.refresh_dispose();
        }
    }

    @Test
    public void test_possibleSources() throws Exception {
        SourceDirectTest.setFileContentSrc("test/not-a-properties.text", "");
        SourceDirectTest.setFileContentSrc("test/messages2.properties", SourceDirectTest.getSourceDQ("#Invalid comment for Direct ResourceBundle"));
        SourceDirectTest.setFileContentSrc("test/messages.properties", SourceDirectTest.getSourceDQ("#Direct ResourceBundle", "frame.title=My JFrame"));
        SourceDirectTest.setFileContentSrc("test/messages_it.properties", SourceDirectTest.getSourceDQ("#We need only default *.properties file"));
        SourceDirectTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        SourceDirectTest.assertEquals((int)1, (int)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        SourceDirectTest.assertEquals((Object)"test.messages (Direct ResourceBundle usage)", (Object)editableSource.getLongTitle());
    }

    @Test
    public void test_externalize() throws Exception {
        SourceDirectTest.setFileContentSrc("test/messages.properties", SourceDirectTest.getSourceDQ("#Direct ResourceBundle"));
        SourceDirectTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        SourceDirectTest.assertEquals((int)1, (int)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        StringPropertyInfo propertyInfo = (StringPropertyInfo)editableSupport.getProperties((JavaInfo)frame).get(0);
        editableSupport.externalizeProperty(propertyInfo, editableSource, true);
        support.applyEditable(editableSupport);
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle('test.messages').getString('Test.this.title')); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        String newProperties = SourceDirectTest.getFileContentSrc("test/messages.properties");
        SourceDirectTest.assertTrue((boolean)newProperties.contains("#Direct ResourceBundle"));
        SourceDirectTest.assertTrue((boolean)newProperties.contains("Test.this.title=My JFrame"));
    }

    @Test
    public void test_externalize_qualifiedTypeName() throws Exception {
        SourceDirectTest.setFileContentSrc("test/messages.properties", SourceDirectTest.getSourceDQ("#Direct ResourceBundle"));
        SourceDirectTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        SourceDirectTest.assertEquals((int)1, (int)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        PreferencesRepairer preferences = new PreferencesRepairer(ToolkitProvider.DESCRIPTION.getPreferences());
        try {
            preferences.setValue("nls.useQualifiedTypeNameForKey", true);
            StringPropertyInfo propertyInfo = (StringPropertyInfo)editableSupport.getProperties((JavaInfo)frame).get(0);
            editableSupport.externalizeProperty(propertyInfo, editableSource, true);
        }
        finally {
            preferences.restore();
        }
        support.applyEditable(editableSupport);
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle('test.messages').getString('test.Test.this.title')); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        String newProperties = SourceDirectTest.getFileContentSrc("test/messages.properties");
        SourceDirectTest.assertTrue((boolean)newProperties.contains("#Direct ResourceBundle"));
        SourceDirectTest.assertTrue((boolean)newProperties.contains("test.Test.this.title=My JFrame"));
    }

    @Test
    public void test_renameKey() throws Exception {
        SourceDirectTest.setFileContentSrc("test/messages.properties", SourceDirectTest.getSourceDQ("frame.title=My JFrame"));
        SourceDirectTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle('test.messages').getString('frame.title')); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        IEditableSource editableSource = (IEditableSource)editableSupport.getEditableSources().get(0);
        editableSource.renameKey("frame.title", "frame.title2");
        support.applyEditable(editableSupport);
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle('test.messages').getString('frame.title2')); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        String newProperties = SourceDirectTest.getFileContentSrc("test/messages.properties");
        SourceDirectTest.assertFalse((boolean)newProperties.contains("frame.title=My JFrame"));
        SourceDirectTest.assertTrue((boolean)newProperties.contains("frame.title2=My JFrame"));
    }

    @Test
    public void test_internalize() throws Exception {
        SourceDirectTest.setFileContentSrc("test/messages.properties", SourceDirectTest.getSourceDQ("frame.title=My JFrame"));
        SourceDirectTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle('test.messages').getString('frame.title')); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        IEditableSource editableSource = (IEditableSource)editableSupport.getEditableSources().get(0);
        editableSource.internalizeKey("frame.title");
        support.applyEditable(editableSupport);
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        String newProperties = SourceDirectTest.getFileContentSrc("test/messages.properties");
        SourceDirectTest.assertFalse((boolean)newProperties.contains("frame.title=My JFrame"));
    }

    @Test
    public void test_create() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        IEditableSource editableSource = NlsTestUtils.createEmptyEditable("test.messages");
        SourceParameters parameters = new SourceParameters();
        IJavaProject javaProject = this.m_lastEditor.getJavaProject();
        parameters.m_propertySourceFolder = javaProject.findPackageFragmentRoot((IPath)new Path("/TestProject/src"));
        parameters.m_propertyPackage = javaProject.findPackageFragment((IPath)new Path("/TestProject/src/test"));
        parameters.m_propertyFileName = "messages.properties";
        parameters.m_propertyBundleName = "test.messages";
        parameters.m_propertyFileExists = false;
        editableSupport.addSource(editableSource, new SourceDescription(DirectSource.class, DirectSourceNewComposite.class), (Object)parameters);
        StringPropertyInfo propertyInfo = (StringPropertyInfo)editableSupport.getProperties((JavaInfo)frame).get(0);
        editableSupport.externalizeProperty(propertyInfo, editableSource, true);
        support.applyEditable(editableSupport);
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle('test.messages').getString('Test.this.title')); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        String newProperties = SourceDirectTest.getFileContentSrc("test/messages.properties");
        SourceDirectTest.assertTrue((boolean)newProperties.contains("#Direct ResourceBundle"));
        SourceDirectTest.assertTrue((boolean)newProperties.contains("Test.this.title=My JFrame"));
    }
}

