/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.property;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.designer.swt.model.property.PropertyEditorTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class CursorPropertyEditorTest
extends RcpModelTest {
    protected Shell m_shell;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (this.m_shell == null) {
            this.m_shell = new Shell();
        }
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        ToolkitProvider.DESCRIPTION.getPreferences().setToDefault("useResourceManager");
        if (this.m_shell != null) {
            this.m_shell.dispose();
            this.m_shell = null;
        }
    }

    protected final void assert_getText_getClipboardSource_forSource(String cursorSource, String expectedText, String expectedClipboardSource) throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        shell.addMethodInvocation("setCursor(org.eclipse.swt.graphics.Cursor)", cursorSource);
        shell.refresh();
        Property property = shell.getPropertyByTitle("cursor");
        CursorPropertyEditorTest.assertNotNull((Object)property);
        CursorPropertyEditorTest.assertEquals((Object)expectedText, (Object)PropertyEditorTestUtils.getText(property));
        CursorPropertyEditorTest.assertEquals((Object)expectedClipboardSource, (Object)PropertyEditorTestUtils.getClipboardSource(property));
    }
}

