/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.MigLayout;

import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.MigLayout.AbstractMigLayoutTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MigLayoutConstraintsPropertiesTest
extends AbstractMigLayoutTest {
    private CellConstraintsSupport m_constraints;
    private ComplexProperty m_cellProperty;
    private Property[] m_subProperties;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][]', '[][][][]'));", "    add(new JButton(C_1), 'cell 1 2');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.m_constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        this.m_cellProperty = (ComplexProperty)button.getPropertyByTitle("Constraints");
        MigLayoutConstraintsPropertiesTest.assertNotNull((Object)this.m_cellProperty);
        MigLayoutConstraintsPropertiesTest.assertEquals((Object)"cell 1 2", (Object)MigLayoutConstraintsPropertiesTest.getPropertyText((Property)this.m_cellProperty));
        this.m_subProperties = this.m_cellProperty.getProperties();
        MigLayoutConstraintsPropertiesTest.assertEquals((int)6, (int)this.m_subProperties.length);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.m_constraints = null;
        this.m_cellProperty = null;
        this.m_subProperties = null;
        super.tearDown();
    }

    @Test
    public void test_getPropertyByTitle() throws Exception {
        MigLayoutConstraintsPropertiesTest.assertNull((Object)this.m_constraints.getPropertyByTitle("noSuchProperty"));
        MigLayoutConstraintsPropertiesTest.assertSame((Object)this.m_subProperties[0], (Object)this.m_constraints.getPropertyByTitle("grid x"));
        MigLayoutConstraintsPropertiesTest.assertSame((Object)this.m_subProperties[1], (Object)this.m_constraints.getPropertyByTitle("grid y"));
        MigLayoutConstraintsPropertiesTest.assertSame((Object)this.m_subProperties[4], (Object)this.m_constraints.getPropertyByTitle("h alignment"));
    }

    @Test
    public void test_property_x() throws Exception {
        Property property = this.m_subProperties[0];
        MigLayoutConstraintsPropertiesTest.assertEquals((Object)"grid x", (Object)property.getTitle());
        MigLayoutConstraintsPropertiesTest.assertTrue((boolean)property.isModified());
        MigLayoutConstraintsPropertiesTest.assertEquals((Object)1, (Object)property.getValue());
        String expectedSource = this.m_lastEditor.getSource();
        property.setValue(Property.UNKNOWN_VALUE);
        MigLayoutConstraintsPropertiesTest.assertEquals((Object)1, (Object)property.getValue());
        MigLayoutConstraintsPropertiesTest.assertEditor(expectedSource, this.m_lastEditor);
        expectedSource = this.m_lastEditor.getSource().replace("cell 1 2", "cell 2 2");
        property.setValue((Object)2);
        MigLayoutConstraintsPropertiesTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_property_y() throws Exception {
        Property property = this.m_subProperties[1];
        MigLayoutConstraintsPropertiesTest.assertEquals((Object)"grid y", (Object)property.getTitle());
        MigLayoutConstraintsPropertiesTest.assertTrue((boolean)property.isModified());
        MigLayoutConstraintsPropertiesTest.assertEquals((Object)2, (Object)property.getValue());
        String expectedSource = this.m_lastEditor.getSource().replace("cell 1 2", "cell 1 1");
        property.setValue((Object)1);
        MigLayoutConstraintsPropertiesTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_property_w() throws Exception {
        Property property = this.m_subProperties[2];
        MigLayoutConstraintsPropertiesTest.assertEquals((Object)"grid width", (Object)property.getTitle());
        MigLayoutConstraintsPropertiesTest.assertFalse((boolean)property.isModified());
        MigLayoutConstraintsPropertiesTest.assertEquals((Object)1, (Object)property.getValue());
        String expectedSource = this.m_lastEditor.getSource().replace("cell 1 2", "cell 1 2 2 1");
        property.setValue((Object)2);
        MigLayoutConstraintsPropertiesTest.assertEditor(expectedSource, this.m_lastEditor);
        expectedSource = this.m_lastEditor.getSource().replace("cell 1 2 2 1", "cell 1 2");
        property.setValue(Property.UNKNOWN_VALUE);
        MigLayoutConstraintsPropertiesTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_property_h() throws Exception {
        Property property = this.m_subProperties[3];
        MigLayoutConstraintsPropertiesTest.assertEquals((Object)"grid height", (Object)property.getTitle());
        MigLayoutConstraintsPropertiesTest.assertFalse((boolean)property.isModified());
        MigLayoutConstraintsPropertiesTest.assertEquals((Object)1, (Object)property.getValue());
        String expectedSource = this.m_lastEditor.getSource().replace("cell 1 2", "cell 1 2 1 2");
        property.setValue((Object)2);
        MigLayoutConstraintsPropertiesTest.assertEditor(expectedSource, this.m_lastEditor);
        expectedSource = this.m_lastEditor.getSource().replace("cell 1 2 1 2", "cell 1 2");
        property.setValue(Property.UNKNOWN_VALUE);
        MigLayoutConstraintsPropertiesTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_property_align_h() throws Exception {
        Property property = this.m_subProperties[4];
        MigLayoutConstraintsPropertiesTest.assertEquals((Object)"h alignment", (Object)property.getTitle());
        MigLayoutConstraintsPropertiesTest.assertSame((Object)MigColumnInfo.Alignment.DEFAULT, (Object)property.getValue());
        MigLayoutConstraintsPropertiesTest.assertFalse((boolean)property.isModified());
        String expectedSource = this.m_lastEditor.getSource().replace("cell 1 2", "cell 1 2,alignx right");
        property.setValue((Object)MigColumnInfo.Alignment.RIGHT);
        MigLayoutConstraintsPropertiesTest.assertEditor(expectedSource, this.m_lastEditor);
        expectedSource = this.m_lastEditor.getSource().replace("cell 1 2,alignx right", "cell 1 2");
        property.setValue(Property.UNKNOWN_VALUE);
        MigLayoutConstraintsPropertiesTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_property_align_v() throws Exception {
        Property property = this.m_subProperties[5];
        MigLayoutConstraintsPropertiesTest.assertEquals((Object)"v alignment", (Object)property.getTitle());
        MigLayoutConstraintsPropertiesTest.assertSame((Object)MigRowInfo.Alignment.DEFAULT, (Object)property.getValue());
        MigLayoutConstraintsPropertiesTest.assertFalse((boolean)property.isModified());
        String expectedSource = this.m_lastEditor.getSource().replace("cell 1 2", "cell 1 2,aligny bottom");
        property.setValue((Object)MigRowInfo.Alignment.BOTTOM);
        MigLayoutConstraintsPropertiesTest.assertEditor(expectedSource, this.m_lastEditor);
        expectedSource = this.m_lastEditor.getSource().replace("cell 1 2,aligny bottom", "cell 1 2");
        property.setValue(Property.UNKNOWN_VALUE);
        MigLayoutConstraintsPropertiesTest.assertEditor(expectedSource, this.m_lastEditor);
    }
}

