/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import java.util.LinkedList;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.ColumnInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.RowInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.jupiter.api.Test;

public class GridBagDimensionTest
extends AbstractGridBagLayoutTest {
    @Test
    public void test_dimensions_0() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 2\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 2;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        panel.refresh();
        LinkedList columns = layout.getColumns();
        GridBagDimensionTest.assertEquals((int)2, (int)columns.size());
        ColumnInfo column = (ColumnInfo)columns.get(0);
        GridBagDimensionTest.assertEquals((int)0, (int)column.getIndex());
        GridBagDimensionTest.assertEquals((int)0, (int)column.getSize());
        GridBagDimensionTest.assertEquals((double)0.0, (double)column.getWeight(), (double)1.0E-6);
        GridBagDimensionTest.assertFalse((boolean)column.hasWeight());
        column = (ColumnInfo)columns.get(1);
        GridBagDimensionTest.assertEquals((int)1, (int)column.getIndex());
        GridBagDimensionTest.assertEquals((int)0, (int)column.getSize());
        GridBagDimensionTest.assertEquals((double)0.0, (double)column.getWeight(), (double)1.0E-6);
        GridBagDimensionTest.assertFalse((boolean)column.hasWeight());
        LinkedList rows = layout.getRows();
        GridBagDimensionTest.assertEquals((int)3, (int)rows.size());
        RowInfo row = (RowInfo)rows.get(0);
        GridBagDimensionTest.assertEquals((int)0, (int)row.getIndex());
        GridBagDimensionTest.assertEquals((int)0, (int)row.getSize());
        GridBagDimensionTest.assertEquals((double)0.0, (double)row.getWeight(), (double)1.0E-6);
        GridBagDimensionTest.assertFalse((boolean)row.hasWeight());
    }

    @Test
    public void test_dimensions_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {100, 200, 0};\n\t\tlayout.rowHeights = new int[] {50, 0};\n\t\tlayout.columnWeights = new double[] {1.0, 2.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {1.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t}\n}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        panel.refresh();
        LinkedList columns = layout.getColumns();
        GridBagDimensionTest.assertEquals((int)2, (int)columns.size());
        ColumnInfo column = (ColumnInfo)columns.get(0);
        GridBagDimensionTest.assertEquals((int)0, (int)column.getIndex());
        GridBagDimensionTest.assertEquals((int)100, (int)column.getSize());
        GridBagDimensionTest.assertEquals((double)1.0, (double)column.getWeight(), (double)1.0E-6);
        GridBagDimensionTest.assertTrue((boolean)column.hasWeight());
        column = (ColumnInfo)columns.get(1);
        GridBagDimensionTest.assertEquals((int)1, (int)column.getIndex());
        GridBagDimensionTest.assertEquals((int)200, (int)column.getSize());
        GridBagDimensionTest.assertEquals((double)2.0, (double)column.getWeight(), (double)1.0E-6);
        GridBagDimensionTest.assertTrue((boolean)column.hasWeight());
        LinkedList rows = layout.getRows();
        GridBagDimensionTest.assertEquals((int)1, (int)rows.size());
        RowInfo row = (RowInfo)rows.get(0);
        GridBagDimensionTest.assertEquals((int)0, (int)row.getIndex());
        GridBagDimensionTest.assertEquals((int)50, (int)row.getSize());
        GridBagDimensionTest.assertEquals((double)1.0, (double)row.getWeight(), (double)1.0E-6);
        GridBagDimensionTest.assertTrue((boolean)row.hasWeight());
    }
}

