/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.jface.resource.ManagerContainerInfo;
import org.eclipse.wb.internal.swt.model.property.editor.color.ColorPropertyEditor;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.swt.model.property.ColorPropertyEditorTest;
import org.eclipse.wb.tests.designer.swt.model.property.PropertyEditorTestUtils;
import org.eclipse.wb.tests.designer.tests.common.GenericPropertyNoValue;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ColorPropertyEditorTestWithManager
extends ColorPropertyEditorTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", true);
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_textSource_noValue() throws Exception {
        GenericPropertyNoValue property = new GenericPropertyNoValue(null, null, ColorPropertyEditor.INSTANCE);
        ColorPropertyEditorTestWithManager.assertNull((Object)PropertyEditorTestUtils.getText((Property)property));
        ColorPropertyEditorTestWithManager.assertNull((Object)PropertyEditorTestUtils.getClipboardSource((Property)property));
    }

    @Test
    public void test_getText_constructor_ints() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Color(null, 1, 2, 3)", "1, 2, 3", ColorPropertyEditor.getInvocationSource((JavaInfo)this.shell(), (int)1, (int)2, (int)3));
    }

    @Test
    public void test_getText_constructor_RGB() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Color(null, new RGB(1, 2, 3))", "1, 2, 3", ColorPropertyEditor.getInvocationSource((JavaInfo)this.shell(), (int)1, (int)2, (int)3));
    }

    private CompositeInfo shell() throws Exception {
        return this.parseComposite("public class Test extends Shell {}");
    }

    @Test
    public void test_textSource_order() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ManagerContainerInfo.getResourceManagerInfo((JavaInfo)shell);
        shell.addMethodInvocation("setBackground(org.eclipse.swt.graphics.Color)", ColorPropertyEditor.getInvocationSource((JavaInfo)shell, (int)1, (int)2, (int)3));
        shell.refresh();
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  private LocalResourceManager localResourceManager;", "  public Test() {", "    createResourceManager();", "    setBackground(localResourceManager.create(ColorDescriptor.createFrom(new RGB(1, 2, 3))));", "  }", "  private void createResourceManager() {", "    localResourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  }", "}");
    }
}

