/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.jface.resource.ManagerContainerInfo;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontPropertyEditor;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.swt.model.property.FontPropertyEditorTest;
import org.eclipse.wb.tests.designer.swt.model.property.PropertyEditorTestUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FontPropertyEditorTestWithManager
extends FontPropertyEditorTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", true);
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_textSource_over_Constructor() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {}");
        this.assert_getText_getClipboardSource_forSource("new Font(null, \"MS Shell Dlg\", 12, SWT.BOLD)", "MS Shell Dlg 12 BOLD", FontPropertyEditor.getInvocationSource((JavaInfo)shell, (String)"MS Shell Dlg", (int)12, (String)"org.eclipse.swt.SWT.BOLD"));
    }

    @Test
    public void test_textSource_over_Constructor2() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ManagerContainerInfo.get((JavaInfo)shell);
        shell.addMethodInvocation("setFont(org.eclipse.swt.graphics.Font)", FontPropertyEditor.getInvocationSource((JavaInfo)shell, (String)"MS Shell Dlg", (int)12, (String)"org.eclipse.swt.SWT.BOLD"));
        shell.refresh();
        Property property = shell.getPropertyByTitle("font");
        FontPropertyEditorTestWithManager.assertEquals((Object)"MS Shell Dlg 12 BOLD", (Object)PropertyEditorTestUtils.getText(property));
        FontPropertyEditorTestWithManager.assertEquals((Object)FontPropertyEditor.getInvocationSource((JavaInfo)shell, (String)"MS Shell Dlg", (int)12, (String)"org.eclipse.swt.SWT.BOLD"), (Object)PropertyEditorTestUtils.getClipboardSource(property));
    }

    @Test
    public void test_textSource_over_JFace() throws Exception {
        this.assert_getText_getClipboardSource_forSource("JFaceResources.getBannerFont()", "getBannerFont()", "org.eclipse.jface.resource.JFaceResources.getBannerFont()");
    }

    @Test
    public void test_textSource_order() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ManagerContainerInfo.getResourceManagerInfo((JavaInfo)shell);
        shell.addMethodInvocation("setFont(org.eclipse.swt.graphics.Font)", FontPropertyEditor.getInvocationSource((JavaInfo)shell, (String)"MS Shell Dlg", (int)12, (String)"org.eclipse.swt.SWT.BOLD"));
        shell.refresh();
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  private LocalResourceManager localResourceManager;", "  public Test() {", "    createResourceManager();", "    setFont(localResourceManager.create(FontDescriptor.createFrom(\"MS Shell Dlg\", 12, SWT.BOLD)));", "  }", "  private void createResourceManager() {", "    localResourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  }", "}");
    }
}

