/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.widgets;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.TreeInfo;
import org.eclipse.wb.internal.swt.model.widgets.TreeItemInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class TreeTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_TreeItem_parse() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeItem item_1 = new TreeItem(tree, SWT.NONE);", "      item_1.setText('TreeItem 1');", "    }", "    {", "      TreeItem item_2 = new TreeItem(tree, SWT.NONE);", "      item_2.setText('TreeItem 2');", "    }", "  }", "}");
        shell.refresh();
        TreeInfo tree = (TreeInfo)TreeTest.getJavaInfoByName("tree");
        List items = tree.getItems();
        Assertions.assertThat((List)items).hasSize(2);
        TreeItemInfo item_1 = (TreeItemInfo)items.get(0);
        TreeItemInfo item_2 = (TreeItemInfo)items.get(1);
        Assertions.assertThat((List)item_1.getItems()).isEmpty();
        Assertions.assertThat((List)item_2.getItems()).isEmpty();
        Insets tableInsets = tree.getClientAreaInsets();
        Rectangle modelBounds = item_1.getModelBounds();
        TreeTest.assertNotNull((Object)modelBounds);
        TreeTest.assertTrue((modelBounds.x > 10 ? 1 : 0) != 0);
        Assertions.assertThat((int)modelBounds.y).isGreaterThanOrEqualTo(0);
        Assertions.assertThat((int)modelBounds.y).isLessThanOrEqualTo(5);
        TreeTest.assertTrue((modelBounds.width > 50 ? 1 : 0) != 0);
        Rectangle bounds = item_1.getBounds();
        TreeTest.assertEquals((int)tableInsets.left, (int)(bounds.x - modelBounds.x));
        TreeTest.assertEquals((int)tableInsets.top, (int)(bounds.y - modelBounds.y));
        TreeTest.assertEquals((int)modelBounds.width, (int)bounds.width);
        TreeTest.assertEquals((int)modelBounds.height, (int)bounds.height);
        modelBounds = item_2.getModelBounds();
        TreeTest.assertEquals((int)item_1.getModelBounds().x, (int)modelBounds.x);
        Assertions.assertThat((int)item_1.getModelBounds().bottom()).isGreaterThanOrEqualTo(modelBounds.y - 5);
        Assertions.assertThat((int)item_1.getModelBounds().bottom()).isLessThanOrEqualTo(modelBounds.y);
    }

    @Test
    public void test_TreeItem_parse_subItems() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeItem item = new TreeItem(tree, SWT.NONE);", "      {", "        TreeItem subItem = new TreeItem(item, SWT.NONE);", "      }", "    }", "  }", "}");
        shell.refresh();
        TreeInfo tree = (TreeInfo)TreeTest.getJavaInfoByName("tree");
        List items = tree.getItems();
        Assertions.assertThat((List)items).hasSize(1);
        TreeItemInfo item = (TreeItemInfo)items.get(0);
        List subItems = item.getItems();
        Assertions.assertThat((List)subItems).hasSize(1);
    }

    @Test
    public void test_TreeItem_addToTable() throws Exception {
        this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Tree tree = new Tree(this, SWT.BORDER);", "  }", "}");
        TreeInfo tree = (TreeInfo)TreeTest.getJavaInfoByName("tree");
        TreeTest.assertTrue((boolean)tree.getItems().isEmpty());
        TreeItemInfo newItem = (TreeItemInfo)TreeTest.createJavaInfo("org.eclipse.swt.widgets.TreeItem");
        TreeTest.flowContainer_CREATE((JavaInfo)tree, newItem, null);
        List items = tree.getItems();
        Assertions.assertThat((List)items).containsExactly((Object[])new TreeItemInfo[]{newItem});
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeItem treeItem = new TreeItem(tree, SWT.NONE);", "      treeItem.setText('New TreeItem');", "    }", "  }", "}");
    }

    @Test
    public void test_TreeItem_moveInTable() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeItem item_1 = new TreeItem(tree, SWT.NONE);", "      item_1.setText('TreeItem 1');", "    }", "    {", "      TreeItem item_2 = new TreeItem(tree, SWT.NONE);", "      item_2.setText('TreeItem 2');", "    }", "  }", "}");
        shell.refresh();
        TreeInfo tree = (TreeInfo)TreeTest.getJavaInfoByName("tree");
        List items = tree.getItems();
        Assertions.assertThat((List)items).hasSize(2);
        TreeItemInfo item_1 = (TreeItemInfo)items.get(0);
        TreeItemInfo item_2 = (TreeItemInfo)items.get(1);
        TreeTest.flowContainer_MOVE((JavaInfo)tree, item_2, item_1);
        items = tree.getItems();
        Assertions.assertThat((List)items).containsExactly((Object[])new TreeItemInfo[]{item_2, item_1});
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeItem item_2 = new TreeItem(tree, SWT.NONE);", "      item_2.setText('TreeItem 2');", "    }", "    {", "      TreeItem item_1 = new TreeItem(tree, SWT.NONE);", "      item_1.setText('TreeItem 1');", "    }", "  }", "}");
    }

    @Test
    public void test_TreeItem_addToItem() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeItem existingItem = new TreeItem(tree, SWT.NONE);", "      existingItem.setText('existing TreeItem');", "    }", "  }", "}");
        shell.refresh();
        TreeInfo tree = (TreeInfo)shell.getChildrenControls().get(0);
        TreeItemInfo existingItem = (TreeItemInfo)tree.getItems().get(0);
        TreeItemInfo newItem = (TreeItemInfo)TreeTest.createJavaInfo("org.eclipse.swt.widgets.TreeItem");
        TreeTest.flowContainer_CREATE((JavaInfo)existingItem, newItem, null);
        List items = existingItem.getItems();
        Assertions.assertThat((List)items).containsExactly((Object[])new TreeItemInfo[]{newItem});
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeItem existingItem = new TreeItem(tree, SWT.NONE);", "      existingItem.setText('existing TreeItem');", "      {", "        TreeItem treeItem = new TreeItem(existingItem, SWT.NONE);", "        treeItem.setText('New TreeItem');", "      }", "      existingItem.setExpanded(true);", "    }", "  }", "}");
    }

    @Test
    public void test_TreeItem_moveToItem() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeItem item_1 = new TreeItem(tree, SWT.NONE);", "      item_1.setText('TreeItem 1');", "    }", "    {", "      TreeItem item_2 = new TreeItem(tree, SWT.NONE);", "      item_2.setText('TreeItem 2');", "    }", "  }", "}");
        shell.refresh();
        TreeInfo tree = (TreeInfo)TreeTest.getJavaInfoByName("tree");
        List items = tree.getItems();
        Assertions.assertThat((List)items).hasSize(2);
        TreeItemInfo item_1 = (TreeItemInfo)items.get(0);
        TreeItemInfo item_2 = (TreeItemInfo)items.get(1);
        try {
            tree.startEdit();
            TreeTest.flowContainer_MOVE((JavaInfo)item_1, item_2, null);
        }
        finally {
            tree.endEdit();
        }
        items = tree.getItems();
        Assertions.assertThat((List)items).containsExactly((Object[])new TreeItemInfo[]{item_1});
        items = item_1.getItems();
        Assertions.assertThat((List)items).containsExactly((Object[])new TreeItemInfo[]{item_2});
        Assertions.assertThat((List)item_2.getItems()).isEmpty();
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeItem item_1 = new TreeItem(tree, SWT.NONE);", "      item_1.setText('TreeItem 1');", "      {", "        TreeItem item_2 = new TreeItem(item_1, SWT.NONE);", "        item_2.setText('TreeItem 2');", "      }", "      item_1.setExpanded(true);", "    }", "  }", "}");
    }
}

