/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.tests.draw2d.Draw2dFigureTestCase;
import org.eclipse.wb.tests.gef.EventSender;
import org.eclipse.wb.tests.gef.TestLogger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FigureEventTest
extends Draw2dFigureTestCase {
    private Shell m_shell;
    private EventSender m_sender;
    private FigureCanvas m_canvas;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.m_shell = new Shell();
        this.m_shell.setLayout((Layout)new FillLayout());
        this.m_canvas = new FigureCanvas((Composite)this.m_shell, 0);
        this.m_sender = new EventSender((Control)this.m_canvas);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.m_shell.dispose();
    }

    @Test
    public void test_handleMouseEvents() throws Exception {
        Layer layer1 = new Layer("1");
        Figure figure11 = new Figure(){

            public String toString() {
                return "figure11";
            }
        };
        figure11.setBounds(new Rectangle(10, 10, 200, 150));
        layer1.add((IFigure)figure11);
        Figure figure12 = new Figure(){

            public String toString() {
                return "figure12";
            }
        };
        figure12.setBounds(new Rectangle(400, 300, 50, 70));
        layer1.add((IFigure)figure12);
        Layer layer2 = new Layer("2");
        Figure figure21 = new Figure(){

            public String toString() {
                return "figure21";
            }
        };
        figure21.setBounds(new Rectangle(50, 50, 90, 60));
        layer2.add((IFigure)figure21);
        Figure figure22 = new Figure(){

            public String toString() {
                return "figure22";
            }
        };
        figure22.setBounds(new Rectangle(150, 250, 190, 120));
        layer2.add((IFigure)figure22);
        TestLogger actualLogger = new TestLogger();
        MouseEventsLogger listener = new MouseEventsLogger(actualLogger);
        listener.addFigure(figure11);
        listener.addFigure(figure12);
        listener.addFigure(figure21);
        listener.addFigure(figure22);
        this.m_canvas.getRootFigure().addLayer(layer1);
        this.m_canvas.getRootFigure().addLayer(layer2);
        this.m_shell.setSize(500, 400);
        TestLogger expectedLogger = new TestLogger();
        this.m_sender.moveTo(5, 5);
        actualLogger.assertEmpty();
        this.m_sender.moveTo(15, 15);
        expectedLogger.log("mouseMove = MouseEvent(15,15) to Figure: figure11");
        actualLogger.assertEquals(expectedLogger);
        this.m_sender.click(20, 20, 3);
        expectedLogger.log("mouseDown = MouseEvent(20,20) to Figure: figure11");
        expectedLogger.log("mouseUp = MouseEvent(20,20) to Figure: figure11");
        actualLogger.assertEquals(expectedLogger);
        this.m_sender.doubleClick(60, 60, 2);
        expectedLogger.log("mouseDown = MouseEvent(60,60) to Figure: figure21");
        expectedLogger.log("mouseUp = MouseEvent(60,60) to Figure: figure21");
        expectedLogger.log("mouseDown = MouseEvent(60,60) to Figure: figure21");
        expectedLogger.log("mouseDoubleClick = MouseEvent(60,60) to Figure: figure21");
        expectedLogger.log("mouseUp = MouseEvent(60,60) to Figure: figure21");
        actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(420, 330);
        expectedLogger.log("mouseMove = MouseEvent(420,330) to Figure: figure12");
        actualLogger.assertEquals(expectedLogger);
        this.m_sender.click(200, 300, 5);
        expectedLogger.log("mouseDown = MouseEvent(200,300) to Figure: figure22");
        expectedLogger.log("mouseUp = MouseEvent(200,300) to Figure: figure22");
        actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(445, 115);
        actualLogger.assertEmpty();
    }

    private static class MouseEventsLogger
    implements MouseListener,
    MouseMotionListener {
        private final TestLogger m_logger;

        public MouseEventsLogger(TestLogger logger) {
            this.m_logger = logger;
        }

        public void addFigure(Figure figure) {
            figure.addMouseListener((MouseListener)this);
            figure.addMouseMotionListener((MouseMotionListener)this);
        }

        public void mousePressed(MouseEvent event) {
            this.m_logger.log("mouseDown = " + String.valueOf(event));
        }

        public void mouseReleased(MouseEvent event) {
            this.m_logger.log("mouseUp = " + String.valueOf(event));
        }

        public void mouseDoubleClicked(MouseEvent event) {
            this.m_logger.log("mouseDoubleClick = " + String.valueOf(event));
        }

        public void mouseMoved(MouseEvent event) {
            this.m_logger.log("mouseMove = " + String.valueOf(event));
        }

        public void mouseDragged(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mouseHover(MouseEvent event) {
        }
    }
}

