/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fur extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arap";
        final String metaValue_hy = "armen";
        final String metaValue_bn = "bengalês";
        final String metaValue_got = "gotic";
        final String metaValue_el = "grêc";
        final String metaValue_gu = "gujarati";
        final String metaValue_ja = "gjaponês";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "corean";
        final String metaValue_lo = "lao";
        final String metaValue_la = "latin";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongul";
        final String metaValue_or = "oriya";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telegu";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "thai";
        final String metaValue_bo = "tibetan";
        final String metaValue_peo = "vieri persian";
        final Object[][] data = new Object[][] {
            { "001", "Mont" },
            { "002", "Afriche" },
            { "003", "Americhe dal Nord" },
            { "005", "Americhe meridionâl" },
            { "009", "Oceanie" },
            { "011", "Afriche ocidentâl" },
            { "013", "Americhe centrâl" },
            { "014", "Afriche orientâl" },
            { "015", "Afriche setentrionâl" },
            { "017", "Afriche di mieç" },
            { "018", "Afriche meridionâl" },
            { "019", "Americhis" },
            { "021", "Americhe setentrionâl" },
            { "029", "caraibic" },
            { "030", "Asie orientâl" },
            { "034", "Asie meridionâl" },
            { "035", "Asie sud orientâl" },
            { "039", "Europe meridionâl" },
            { "053", "Australie e Gnove Zelande" },
            { "054", "Melanesie" },
            { "057", "Regjon de Micronesie" },
            { "061", "Polinesie" },
            { "142", "Asie" },
            { "143", "Asie centrâl" },
            { "145", "Asie ocidentâl" },
            { "150", "Europe" },
            { "151", "Europe orientâl" },
            { "154", "Europe setentrionâl" },
            { "155", "Europe ocidentâl" },
            { "419", "Americhe latine" },
            { "AD", "Andorra" },
            { "AE", "Emirâts araps unîts" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanie" },
            { "AM", "Armenie" },
            { "AO", "Angola" },
            { "AQ", "Antartic" },
            { "AR", "Argjentine" },
            { "AS", "Samoa merecanis" },
            { "AT", "Austrie" },
            { "AU", "Australie" },
            { "AW", "Aruba" },
            { "AX", "Isulis Aland" },
            { "AZ", "Azerbaigian" },
            { "BA", "Bosnie e Ercegovine" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgjiche" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarie" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sant Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivie" },
            { "BR", "Brasîl" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Isule Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bielorussie" },
            { "BZ", "Belize" },
            { "CA", "Canade" },
            { "CC", "Isulis Cocos" },
            { "CD", "Republiche Democratiche dal Congo" },
            { "CF", "Republiche centri africane" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Svuizare" },
            { "CI", "Cueste di Avoli" },
            { "CK", "Isulis Cook" },
            { "CL", "Cile" },
            { "CM", "Camerun" },
            { "CN", "Cine" },
            { "CO", "Colombie" },
            { "CP", "Isule Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cjâf vert" },
            { "CX", "Isule Christmas" },
            { "CY", "Cipri" },
            { "CZ", "Republiche ceche" },
            { "DE", "Gjermanie" },
            { "DG", "Diego Garcia" },
            { "DJ", "Gibuti" },
            { "DK", "Danimarcje" },
            { "DM", "Dominiche" },
            { "DO", "Republiche dominicane" },
            { "DZ", "Alzerie" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonie" },
            { "EG", "Egjit" },
            { "EH", "Sahara ocidentâl" },
            { "ER", "Eritree" },
            { "ES", "Spagne" },
            { "ET", "Etiopie" },
            { "EU", "Union europeane" },
            { "FI", "Finlandie" },
            { "FJ", "Fizi" },
            { "FK", "Isulis Falkland" },
            { "FM", "Micronesie" },
            { "FO", "Isulis Faroe" },
            { "FR", "France" },
            { "GA", "Gabon" },
            { "GB", "Ream unît" },
            { "GD", "Grenada" },
            { "GE", "Gjeorgjie" },
            { "GF", "Guiana francês" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gjibraltar" },
            { "GL", "Groenlande" },
            { "GM", "Gambia" },
            { "GN", "Guinee" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinee ecuatoriâl" },
            { "GR", "Grecie" },
            { "GS", "Georgia dal Sud e Isulis Sandwich dal Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Regjon aministrative speciâl de Cine di Hong Kong" },
            { "HM", "Isule Heard e Isulis McDonald" },
            { "HN", "Honduras" },
            { "HR", "Cravuazie" },
            { "HT", "Haiti" },
            { "HU", "Ongjarie" },
            { "IC", "Isulis Canariis" },
            { "ID", "Indonesie" },
            { "IE", "Irlande" },
            { "IL", "Israêl" },
            { "IM", "Isule di Man" },
            { "IN", "India" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Islande" },
            { "IT", "Italie" },
            { "JE", "Jersey" },
            { "JM", "Gjamaiche" },
            { "JO", "Jordanie" },
            { "JP", "Gjapon" },
            { "KE", "Kenya" },
            { "KG", "Kirghizstan" },
            { "KH", "Camboze" },
            { "KI", "Kiribati" },
            { "KM", "Comoris" },
            { "KN", "San Kitts e Nevis" },
            { "KP", "Coree dal nord" },
            { "KR", "Coree dal sud" },
            { "KW", "Kuwait" },
            { "KY", "Isulis Cayman" },
            { "KZ", "Kazachistan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Sante Lusie" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberie" },
            { "LS", "Lesotho" },
            { "LT", "Lituanie" },
            { "LU", "Lussemburc" },
            { "LV", "Letonie" },
            { "LY", "Libie" },
            { "MA", "Maroc" },
            { "MC", "Monaco" },
            { "MD", "Moldavie" },
            { "ME", "Montenegro" },
            { "MF", "Sant Martin" },
            { "MG", "Madagascar" },
            { "MH", "Isulis Marshall" },
            { "ML", "Mali" },
            { "MM", "Birmanie" },
            { "MN", "Mongolie" },
            { "MO", "Regjon aministrative speciâl de Cine di Macao" },
            { "MP", "Isulis Mariana dal Nord" },
            { "MQ", "Martiniche" },
            { "MR", "Mauritanie" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Maurizi" },
            { "MV", "Maldivis" },
            { "MW", "Malawi" },
            { "MX", "Messic" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambic" },
            { "NA", "Namibie" },
            { "NC", "Gnove Caledonie" },
            { "NE", "Niger" },
            { "NF", "Isole Norfolk" },
            { "NG", "Nigerie" },
            { "NI", "Nicaragua" },
            { "NL", "Paîs bas" },
            { "NO", "Norvegje" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Gnove Zelande" },
            { "OM", "Oman" },
            { "PA", "Panamà" },
            { "PE", "Perù" },
            { "PF", "Polinesie francês" },
            { "PG", "Papue Gnove Guinee" },
            { "PH", "Filipinis" },
            { "PK", "Pakistan" },
            { "PL", "Polonie" },
            { "PM", "San Pierre e Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Teritoris palestinês" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oceanie periferiche" },
            { "RE", "Reunion" },
            { "RO", "Romanie" },
            { "RS", "Serbie" },
            { "RU", "Russie" },
            { "RW", "Ruande" },
            { "SA", "Arabie Saudide" },
            { "SB", "Isulis Salomon" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Svezie" },
            { "SG", "Singapore" },
            { "SH", "Sante Eline" },
            { "SI", "Slovenie" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Slovachie" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marin" },
            { "SN", "Senegal" },
            { "SO", "Somalie" },
            { "SR", "Suriname" },
            { "ST", "Sao Tomè e Principe" },
            { "SV", "El Salvador" },
            { "SY", "Sirie" },
            { "SZ", "Swaziland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Isulis Turks e Caicos" },
            { "TD", "Çad" },
            { "TF", "Teritoris meridionâi francês" },
            { "TG", "Togo" },
            { "TH", "Tailandie" },
            { "TJ", "Tazikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor orientâl" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisie" },
            { "TO", "Tonga" },
            { "TR", "Turchie" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzanie" },
            { "UA", "Ucraine" },
            { "UG", "Uganda" },
            { "UM", "Isulis periferichis minôrs dai Stâts Unîts" },
            { "US", "Stâts Unîts" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbechistan" },
            { "VA", "Vatican" },
            { "VC", "San Vincent e lis Grenadinis" },
            { "VE", "Venezuela" },
            { "VG", "Isulis vergjinis britanichis" },
            { "VI", "Isulis vergjinis americanis" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sud Afriche" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Regjon no cognossude o no valide" },
            { "aa", "afar" },
            { "ab", "abcazian" },
            { "ae", "avestan" },
            { "af", "afrikaans" },
            { "am", "amaric" },
            { "an", "aragonês" },
            { "ar", metaValue_ar },
            { "as", "assamês" },
            { "av", "avar" },
            { "ay", "aymarà" },
            { "az", "azerbaijani" },
            { "be", "bielorùs" },
            { "bg", "bulgar" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "breton" },
            { "bs", "bosniac" },
            { "ca", "catalan" },
            { "ce", "cecen" },
            { "ch", "chamorro" },
            { "co", "cors" },
            { "cr", "cree" },
            { "cs", "cec" },
            { "cu", "sclâf de glesie" },
            { "cy", "galês" },
            { "da", "danês" },
            { "de", "todesc" },
            { "el", metaValue_el },
            { "en", "inglês" },
            { "eo", "esperanto" },
            { "es", "spagnûl" },
            { "et", "eston" },
            { "eu", "basc" },
            { "fa", "persian" },
            { "ff", "fulah" },
            { "fi", "finlandês" },
            { "fj", "fizian" },
            { "fo", "faroês" },
            { "fr", "francês" },
            { "fy", "frisian" },
            { "ga", "gaelic irlandês" },
            { "gd", "gaelic scozês" },
            { "gl", "galizian" },
            { "gn", "guaranì" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "he", "ebraic" },
            { "hi", "hindi" },
            { "hr", "cravuat" },
            { "ht", "haitian" },
            { "hu", "ongjarês" },
            { "hy", metaValue_hy },
            { "id", "indonesian" },
            { "ig", "igbo" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islandês" },
            { "it", "talian" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "ka", "gjeorgjian" },
            { "kk", "kazac" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "ku", "curd" },
            { "kw", "cornualiês" },
            { "la", metaValue_la },
            { "lb", "lussemburghês" },
            { "li", "limburghês" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituan" },
            { "lv", "leton" },
            { "mg", "malagasy" },
            { "mi", "maori" },
            { "mk", "macedon" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malês" },
            { "mt", "maltês" },
            { "nb", "norvegjês bokmål" },
            { "nd", "ndebele setentrionâl" },
            { "ne", "nepalês" },
            { "nl", "olandês" },
            { "nn", "norvegjês nynorsk" },
            { "no", "norvegjês" },
            { "nv", "navajo" },
            { "oc", "ocitan" },
            { "or", metaValue_or },
            { "os", "osetic" },
            { "pa", "punjabi" },
            { "pl", "polac" },
            { "ps", "pashto" },
            { "pt", "portughês" },
            { "qu", "quechua" },
            { "rm", "rumanç" },
            { "ro", "romen" },
            { "ru", "rus" },
            { "sa", "sanscrit" },
            { "sc", "sardegnûl" },
            { "sd", "sindhi" },
            { "se", "sami setentrionâl" },
            { "sg", "sango" },
            { "si", "sinalês" },
            { "sk", "slovac" },
            { "sl", "sloven" },
            { "sm", "samoan" },
            { "so", "somal" },
            { "sq", "albanês" },
            { "sr", "serp" },
            { "ss", "swati" },
            { "st", "sotho meridionâl" },
            { "su", "sundanês" },
            { "sv", "svedês" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tagic" },
            { "th", metaValue_th },
            { "tk", "turcmen" },
            { "tl", metaValue_tl },
            { "tr", "turc" },
            { "tt", "tartar" },
            { "ty", "tahitian" },
            { "ug", "uigur" },
            { "uk", "ucrain" },
            { "ur", "urdu" },
            { "uz", "uzbec" },
            { "ve", "venda" },
            { "vi", "vietnamite" },
            { "wa", "valon" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yoruba" },
            { "zh", "cinês" },
            { "zu", "zulu" },
            { "ang", "vieri inglês" },
            { "arc", "aramaic" },
            { "ast", "asturian" },
            { "cop", "coptic" },
            { "den", "sclâf" },
            { "egy", "vieri egjizian" },
            { "fil", "filipin" },
            { "fro", "vieri francês" },
            { "fur", "furlan" },
            { "got", metaValue_got },
            { "grc", "vieri grêc" },
            { "lad", "ladin" },
            { "mul", "lenghis multiplis" },
            { "mwl", "mirandês" },
            { "nap", "napoletan" },
            { "nds", "bas todesc" },
            { "non", "vieri norvegjês" },
            { "nso", "sotho setentrionâl" },
            { "ota", "turc otoman" },
            { "pap", "papiamento" },
            { "peo", metaValue_peo },
            { "pro", "vieri provenzâl" },
            { "scn", "sicilian" },
            { "sco", "scozês" },
            { "sga", "vieri irlandês" },
            { "sux", "sumeric" },
            { "tet", "tetum" },
            { "und", "indeterminade" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Bali", "balinês" },
            { "Beng", metaValue_bn },
            { "Brai", "Braille" },
            { "Bugi", "buginês" },
            { "Cans", "Silabari unificât aborigjens canadês" },
            { "Copt", "copt" },
            { "Cprt", "cipriot" },
            { "Cyrl", "cirilic" },
            { "Cyrs", "cirilic dal vieri slavonic de glesie" },
            { "Deva", "devanagari" },
            { "Egyd", "demotic egjizian" },
            { "Egyh", "jeratic egjizian" },
            { "Egyp", "jeroglifics egjizians" },
            { "Ethi", "etiopic" },
            { "Geor", "georgjian" },
            { "Glag", "glagolitic" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Hani", "han" },
            { "Hans", "Han semplificât" },
            { "Hant", "Han tradizionâl" },
            { "Hebr", "ebreu" },
            { "Hrkt", "katakana o hiragana" },
            { "Hung", "vieri ongjarês" },
            { "Ital", "vieri italic" },
            { "Java", "gjavanês" },
            { "Jpan", metaValue_ja },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latf", "latin Fraktur" },
            { "Latg", "latin gaelic" },
            { "Latn", metaValue_la },
            { "Lina", "lineâr A" },
            { "Linb", "lineâr B" },
            { "Maya", "jeroglifics Maya" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mymr", "myanmar" },
            { "Orya", metaValue_or },
            { "Runr", "runic" },
            { "Sinh", "sinhala" },
            { "Syrc", "siriac" },
            { "Syre", "siriac Estrangelo" },
            { "Syrj", "siriac ocidentâl" },
            { "Syrn", "siriac orientâl" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "ugaritic" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "cuneiform sumeric-acadic" },
            { "Zxxx", "codiç pes lenghis no scritis" },
            { "Zyyy", "comun" },
            { "Zzzz", "codiç par scrituris no codificadis" },
            { "de_AT", "todesc de Austrie" },
            { "de_CH", "alt todesc de Svuizare" },
            { "en_AU", "inglês australian" },
            { "en_CA", "inglês canadês" },
            { "en_GB", "inglês britanic" },
            { "en_US", "ingles merecan" },
            { "es_ES", "spagnûl iberic" },
            { "fr_CA", "francês dal Canade" },
            { "fr_CH", "francês de Svuizare" },
            { "nl_BE", "flamant" },
            { "pt_BR", "portughês brasilian" },
            { "pt_PT", "portughês iberic" },
            { "ro_MD", "moldâf" },
            { "%%1901", "Ortografie todescje tradizionâl" },
            { "%%1994", "Ortografie resiane standard" },
            { "%%1996", "Ortografie todescje dal 1996" },
            { "es_419", "spagnûl de Americhe Latine" },
            { "key.ca", "calendari" },
            { "key.co", "ordenament" },
            { "key.cu", "monede" },
            { "%%BISKE", "dialet di San Zorç di Resie" },
            { "%%LIPAW", "dialet di Lipovaz dal resian" },
            { "%%NEDIS", "Dialet des valadis dal Nadison" },
            { "%%NJIVA", "dialet di Gnive" },
            { "%%OSOJS", "dialet di Oseac" },
            { "%%ROZAJ", "Resian" },
            { "%%SOLBA", "dialet di Stolvize" },
            { "zh_Hans", "cinês semplificât" },
            { "zh_Hant", "cinês tradizionâl" },
            { "%%AREVELA", "armen orientâl" },
            { "%%AREVMDA", "armen ocidentâl" },
            { "%%POLYTON", "Politoniche" },
            { "%%REVISED", "Ortografie revisade" },
            { "%%VALENCIA", "valenzian" },
            { "type.ca.roc", "calendari de Republiche di Cine" },
            { "type.nu.latn", "numars ocidentâi" },
            { "type.co.ducet", "ordenament predeterminât Unicode" },
            { "type.ca.hebrew", "calendari ebreu" },
            { "type.ca.indian", "calendari nazionâl indian" },
            { "type.co.pinyin", "ordin pinyin" },
            { "type.co.search", "ricercje par fins gjenerâi" },
            { "type.co.stroke", "ordin segns" },
            { "type.ca.chinese", "calendari cinês" },
            { "type.ca.buddhist", "calendari budist" },
            { "type.ca.japanese", "calendari gjaponês" },
            { "type.ca.gregorian", "calendari gregorian" },
            { "type.co.phonebook", "ordin elenc telefonic" },
            { "type.co.traditional", "ordin tradizionâl" },
        };
        return data;
    }
}
