/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.entitlement.bridge.Util;
import org.elasticsearch.entitlement.runtime.api.NotEntitledException;
import org.elasticsearch.entitlement.runtime.policy.FileAccessTree;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyParser;
import org.elasticsearch.entitlement.runtime.policy.Scope;
import org.elasticsearch.entitlement.runtime.policy.entitlements.CreateClassLoaderEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.Entitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ExitVMEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.FilesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.InboundNetworkEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.LoadNativeLibrariesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ManageThreadsEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.OutboundNetworkEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ReadStoreAttributesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.SetHttpsConnectionPropertiesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.WriteSystemPropertiesEntitlement;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class PolicyManager {
    private static final Logger generalLogger = LogManager.getLogger(PolicyManager.class);
    static final String UNKNOWN_COMPONENT_NAME = "(unknown)";
    static final String SERVER_COMPONENT_NAME = "(server)";
    static final String APM_AGENT_COMPONENT_NAME = "(APM agent)";
    static final Class<?> DEFAULT_FILESYSTEM_CLASS = PathUtils.getDefaultFileSystem().getClass();
    static final Set<String> MODULES_EXCLUDED_FROM_SYSTEM_MODULES = Set.of("java.desktop");
    final Map<Module, ModuleEntitlements> moduleEntitlementsMap = new ConcurrentHashMap<Module, ModuleEntitlements>();
    private final Map<String, List<Entitlement>> serverEntitlements;
    private final List<Entitlement> apmAgentEntitlements;
    private final Map<String, Map<String, List<Entitlement>>> pluginsEntitlements;
    private final Function<Class<?>, String> pluginResolver;
    private final PathLookup pathLookup;
    private final Set<Class<?>> mutedClasses;
    public static final String ALL_UNNAMED = "ALL-UNNAMED";
    private static final Set<Module> SYSTEM_LAYER_MODULES = PolicyManager.findSystemLayerModules();
    public static final Set<Module> SERVER_LAYER_MODULES = ModuleLayer.boot().modules().stream().filter(m -> !SYSTEM_LAYER_MODULES.contains(m)).collect(Collectors.toUnmodifiableSet());
    private final Map<String, Path> sourcePaths;
    private final String apmAgentPackageName;
    private final Module entitlementsModule;
    private final List<FileAccessTree.ExclusivePath> exclusivePaths;
    private static final ConcurrentHashMap<String, Logger> MODULE_LOGGERS = new ConcurrentHashMap();

    private FileAccessTree getDefaultFileAccess(String componentName, Path componentPath) {
        return FileAccessTree.of(componentName, UNKNOWN_COMPONENT_NAME, FilesEntitlement.EMPTY, this.pathLookup, componentPath, List.of());
    }

    ModuleEntitlements defaultEntitlements(String componentName, Path componentPath, String moduleName) {
        return new ModuleEntitlements(componentName, Map.of(), this.getDefaultFileAccess(componentName, componentPath), PolicyManager.getLogger(componentName, moduleName));
    }

    ModuleEntitlements policyEntitlements(String componentName, Path componentPath, String moduleName, List<Entitlement> entitlements) {
        FilesEntitlement filesEntitlement = FilesEntitlement.EMPTY;
        for (Entitlement entitlement : entitlements) {
            if (!(entitlement instanceof FilesEntitlement)) continue;
            filesEntitlement = (FilesEntitlement)entitlement;
        }
        return new ModuleEntitlements(componentName, entitlements.stream().collect(Collectors.groupingBy((Function<Entitlement, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lorg/elasticsearch/entitlement/runtime/policy/entitlements/Entitlement;)Ljava/lang/Class;)())), FileAccessTree.of(componentName, moduleName, filesEntitlement, this.pathLookup, componentPath, this.exclusivePaths), PolicyManager.getLogger(componentName, moduleName));
    }

    private static Set<Module> findSystemLayerModules() {
        Set systemModulesDescriptors = ModuleFinder.ofSystem().findAll().stream().map(ModuleReference::descriptor).collect(Collectors.toUnmodifiableSet());
        return Stream.concat(Stream.of(PolicyManager.class.getModule()), ModuleLayer.boot().modules().stream().filter(m -> systemModulesDescriptors.contains(m.getDescriptor()) && !MODULES_EXCLUDED_FROM_SYSTEM_MODULES.contains(m.getName()))).collect(Collectors.toUnmodifiableSet());
    }

    public PolicyManager(Policy serverPolicy, List<Entitlement> apmAgentEntitlements, Map<String, Policy> pluginPolicies, Function<Class<?>, String> pluginResolver, Map<String, Path> sourcePaths, String apmAgentPackageName, Module entitlementsModule, PathLookup pathLookup, Set<Class<?>> suppressFailureLogClasses) {
        this.serverEntitlements = PolicyManager.buildScopeEntitlementsMap(Objects.requireNonNull(serverPolicy));
        this.apmAgentEntitlements = apmAgentEntitlements;
        this.pluginsEntitlements = Objects.requireNonNull(pluginPolicies).entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> PolicyManager.buildScopeEntitlementsMap((Policy)e.getValue())));
        this.pluginResolver = pluginResolver;
        this.sourcePaths = sourcePaths;
        this.apmAgentPackageName = apmAgentPackageName;
        this.entitlementsModule = entitlementsModule;
        this.pathLookup = Objects.requireNonNull(pathLookup);
        this.mutedClasses = suppressFailureLogClasses;
        ArrayList<FileAccessTree.ExclusiveFileEntitlement> exclusiveFileEntitlements = new ArrayList<FileAccessTree.ExclusiveFileEntitlement>();
        for (Map.Entry<String, List<Entitlement>> entry : this.serverEntitlements.entrySet()) {
            PolicyManager.validateEntitlementsPerModule(SERVER_COMPONENT_NAME, entry.getKey(), entry.getValue(), exclusiveFileEntitlements);
        }
        PolicyManager.validateEntitlementsPerModule(APM_AGENT_COMPONENT_NAME, ALL_UNNAMED, apmAgentEntitlements, exclusiveFileEntitlements);
        for (Map.Entry<String, Object> entry : this.pluginsEntitlements.entrySet()) {
            for (Map.Entry m : ((Map)entry.getValue()).entrySet()) {
                PolicyManager.validateEntitlementsPerModule(entry.getKey(), (String)m.getKey(), (List)m.getValue(), exclusiveFileEntitlements);
            }
        }
        List<FileAccessTree.ExclusivePath> exclusivePaths = FileAccessTree.buildExclusivePathList(exclusiveFileEntitlements, pathLookup);
        FileAccessTree.validateExclusivePaths(exclusivePaths);
        this.exclusivePaths = exclusivePaths;
    }

    private static Map<String, List<Entitlement>> buildScopeEntitlementsMap(Policy policy) {
        return policy.scopes().stream().collect(Collectors.toUnmodifiableMap(Scope::moduleName, Scope::entitlements));
    }

    private static void validateEntitlementsPerModule(String componentName, String moduleName, List<Entitlement> entitlements, List<FileAccessTree.ExclusiveFileEntitlement> exclusiveFileEntitlements) {
        HashSet found = new HashSet();
        for (Entitlement e : entitlements) {
            if (found.contains(e.getClass())) {
                throw new IllegalArgumentException("[" + componentName + "] using module [" + moduleName + "] found duplicate entitlement [" + e.getClass().getName() + "]");
            }
            found.add(e.getClass());
            if (!(e instanceof FilesEntitlement)) continue;
            FilesEntitlement fe = (FilesEntitlement)e;
            exclusiveFileEntitlements.add(new FileAccessTree.ExclusiveFileEntitlement(componentName, moduleName, fe));
        }
    }

    public void checkStartProcess(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> "start process");
    }

    public void checkWriteStoreAttributes(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> "change file store attributes");
    }

    public void checkReadStoreAttributes(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, ReadStoreAttributesEntitlement.class);
    }

    private void neverEntitled(Class<?> callerClass, Supplier<String> operationDescription) {
        Class<?> requestingClass = this.requestingClass(callerClass);
        if (PolicyManager.isTriviallyAllowed(requestingClass)) {
            return;
        }
        ModuleEntitlements entitlements = this.getEntitlements(requestingClass);
        this.notEntitled(Strings.format((String)"component [%s], module [%s], class [%s], operation [%s]", (Object[])new Object[]{entitlements.componentName(), PolicyManager.getModuleName(requestingClass), requestingClass, operationDescription.get()}), callerClass, entitlements);
    }

    public void checkExitVM(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, ExitVMEntitlement.class);
    }

    public void checkCreateClassLoader(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, CreateClassLoaderEntitlement.class);
    }

    public void checkSetHttpsConnectionProperties(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, SetHttpsConnectionPropertiesEntitlement.class);
    }

    public void checkChangeJVMGlobalState(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> this.walkStackForCheckMethodName().orElse("change JVM global state"));
    }

    public void checkLoggingFileHandler(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> this.walkStackForCheckMethodName().orElse("create logging file handler"));
    }

    private Optional<String> walkStackForCheckMethodName() {
        return StackWalker.getInstance().walk(frames -> frames.map(StackWalker.StackFrame::getMethodName).dropWhile(Predicate.not(methodName -> methodName.startsWith("check$"))).findFirst()).map(this::operationDescription);
    }

    public void checkChangeNetworkHandling(Class<?> callerClass) {
        this.checkChangeJVMGlobalState(callerClass);
    }

    public void checkChangeFilesHandling(Class<?> callerClass) {
        this.checkChangeJVMGlobalState(callerClass);
    }

    @SuppressForbidden(reason="Explicitly checking File apis")
    public void checkFileRead(Class<?> callerClass, File file) {
        this.checkFileRead(callerClass, file.toPath());
    }

    private static boolean isPathOnDefaultFilesystem(Path path) {
        Class<?> pathFileSystemClass = path.getFileSystem().getClass();
        if (path.getFileSystem().getClass() != DEFAULT_FILESYSTEM_CLASS) {
            generalLogger.trace(() -> Strings.format((String)"File entitlement trivially allowed: path [%s] is for a different FileSystem class [%s], default is [%s]", (Object[])new Object[]{path.toString(), pathFileSystemClass.getName(), DEFAULT_FILESYSTEM_CLASS.getName()}));
            return false;
        }
        return true;
    }

    public void checkFileRead(Class<?> callerClass, Path path) {
        try {
            this.checkFileRead(callerClass, path, false);
        }
        catch (NoSuchFileException e) {
            assert (false) : "NoSuchFileException should only be thrown when following links";
            NotEntitledException notEntitledException = new NotEntitledException(e.getMessage());
            notEntitledException.addSuppressed(e);
            throw notEntitledException;
        }
    }

    public void checkFileRead(Class<?> callerClass, Path path, boolean followLinks) throws NoSuchFileException {
        if (!PolicyManager.isPathOnDefaultFilesystem(path)) {
            return;
        }
        Class<?> requestingClass = this.requestingClass(callerClass);
        if (PolicyManager.isTriviallyAllowed(requestingClass)) {
            return;
        }
        ModuleEntitlements entitlements = this.getEntitlements(requestingClass);
        Path realPath = null;
        boolean canRead = entitlements.fileAccess().canRead(path);
        if (canRead && followLinks) {
            try {
                realPath = path.toRealPath(new LinkOption[0]);
                if (!realPath.equals(path)) {
                    canRead = entitlements.fileAccess().canRead(realPath);
                }
            }
            catch (NoSuchFileException e) {
                throw e;
            }
            catch (IOException e) {
                canRead = false;
            }
        }
        if (!canRead) {
            this.notEntitled(Strings.format((String)"component [%s], module [%s], class [%s], entitlement [file], operation [read], path [%s]", (Object[])new Object[]{entitlements.componentName(), PolicyManager.getModuleName(requestingClass), requestingClass, realPath == null ? path : Strings.format((String)"%s -> %s", (Object[])new Object[]{path, realPath})}), callerClass, entitlements);
        }
    }

    @SuppressForbidden(reason="Explicitly checking File apis")
    public void checkFileWrite(Class<?> callerClass, File file) {
        this.checkFileWrite(callerClass, file.toPath());
    }

    public void checkFileWrite(Class<?> callerClass, Path path) {
        if (!PolicyManager.isPathOnDefaultFilesystem(path)) {
            return;
        }
        Class<?> requestingClass = this.requestingClass(callerClass);
        if (PolicyManager.isTriviallyAllowed(requestingClass)) {
            return;
        }
        ModuleEntitlements entitlements = this.getEntitlements(requestingClass);
        if (!entitlements.fileAccess().canWrite(path)) {
            this.notEntitled(Strings.format((String)"component [%s], module [%s], class [%s], entitlement [file], operation [write], path [%s]", (Object[])new Object[]{entitlements.componentName(), PolicyManager.getModuleName(requestingClass), requestingClass, path}), callerClass, entitlements);
        }
    }

    public void checkCreateTempFile(Class<?> callerClass) {
        this.checkFileWrite(callerClass, this.pathLookup.tempDir());
    }

    @SuppressForbidden(reason="Explicitly checking File apis")
    public void checkFileWithZipMode(Class<?> callerClass, File file, int zipMode) {
        assert (zipMode == 1 || zipMode == 5);
        if ((zipMode & 4) == 4) {
            this.checkFileWrite(callerClass, file);
        } else {
            this.checkFileRead(callerClass, file);
        }
    }

    public void checkFileDescriptorRead(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> "read file descriptor");
    }

    public void checkFileDescriptorWrite(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> "write file descriptor");
    }

    public void checkGetFileAttributeView(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> "get file attribute view");
    }

    public void checkLoadingNativeLibraries(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, LoadNativeLibrariesEntitlement.class);
    }

    private String operationDescription(String methodName) {
        return methodName.substring(methodName.indexOf(36));
    }

    public void checkInboundNetworkAccess(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, InboundNetworkEntitlement.class);
    }

    public void checkOutboundNetworkAccess(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, OutboundNetworkEntitlement.class);
    }

    public void checkAllNetworkAccess(Class<?> callerClass) {
        Class<?> requestingClass = this.requestingClass(callerClass);
        if (PolicyManager.isTriviallyAllowed(requestingClass)) {
            return;
        }
        ModuleEntitlements classEntitlements = this.getEntitlements(requestingClass);
        this.checkFlagEntitlement(classEntitlements, InboundNetworkEntitlement.class, requestingClass, callerClass);
        this.checkFlagEntitlement(classEntitlements, OutboundNetworkEntitlement.class, requestingClass, callerClass);
    }

    public void checkUnsupportedURLProtocolConnection(Class<?> callerClass, String protocol) {
        this.neverEntitled(callerClass, () -> Strings.format((String)"unsupported URL protocol [%s]", (Object[])new Object[]{protocol}));
    }

    private void checkFlagEntitlement(ModuleEntitlements classEntitlements, Class<? extends Entitlement> entitlementClass, Class<?> requestingClass, Class<?> callerClass) {
        if (!classEntitlements.hasEntitlement(entitlementClass)) {
            this.notEntitled(Strings.format((String)"component [%s], module [%s], class [%s], entitlement [%s]", (Object[])new Object[]{classEntitlements.componentName(), PolicyManager.getModuleName(requestingClass), requestingClass, PolicyParser.buildEntitlementNameFromClass(entitlementClass)}), callerClass, classEntitlements);
        }
        classEntitlements.logger().debug(() -> Strings.format((String)"Entitled: component [%s], module [%s], class [%s], entitlement [%s]", (Object[])new Object[]{classEntitlements.componentName(), PolicyManager.getModuleName(requestingClass), requestingClass, PolicyParser.buildEntitlementNameFromClass(entitlementClass)}));
    }

    public void checkWriteProperty(Class<?> callerClass, String property) {
        Class<?> requestingClass = this.requestingClass(callerClass);
        if (PolicyManager.isTriviallyAllowed(requestingClass)) {
            return;
        }
        ModuleEntitlements entitlements = this.getEntitlements(requestingClass);
        if (entitlements.getEntitlements(WriteSystemPropertiesEntitlement.class).anyMatch(e -> e.properties().contains(property))) {
            entitlements.logger().debug(() -> Strings.format((String)"Entitled: component [%s], module [%s], class [%s], entitlement [write_system_properties], property [%s]", (Object[])new Object[]{entitlements.componentName(), PolicyManager.getModuleName(requestingClass), requestingClass, property}));
            return;
        }
        this.notEntitled(Strings.format((String)"component [%s], module [%s], class [%s], entitlement [write_system_properties], property [%s]", (Object[])new Object[]{entitlements.componentName(), PolicyManager.getModuleName(requestingClass), requestingClass, property}), callerClass, entitlements);
    }

    private void notEntitled(String message, Class<?> callerClass, ModuleEntitlements entitlements) {
        NotEntitledException exception = new NotEntitledException(message);
        if (!this.mutedClasses.contains(callerClass)) {
            entitlements.logger().warn("Not entitled: {}", new Object[]{message, exception});
        }
        throw exception;
    }

    private static Logger getLogger(String componentName, String moduleName) {
        String loggerSuffix = "." + componentName + "." + (moduleName == null ? ALL_UNNAMED : moduleName);
        return MODULE_LOGGERS.computeIfAbsent(PolicyManager.class.getName() + loggerSuffix, LogManager::getLogger);
    }

    public void checkManageThreadsEntitlement(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, ManageThreadsEntitlement.class);
    }

    private void checkEntitlementPresent(Class<?> callerClass, Class<? extends Entitlement> entitlementClass) {
        Class<?> requestingClass = this.requestingClass(callerClass);
        if (PolicyManager.isTriviallyAllowed(requestingClass)) {
            return;
        }
        this.checkFlagEntitlement(this.getEntitlements(requestingClass), entitlementClass, requestingClass, callerClass);
    }

    ModuleEntitlements getEntitlements(Class<?> requestingClass) {
        return this.moduleEntitlementsMap.computeIfAbsent(requestingClass.getModule(), m -> this.computeEntitlements(requestingClass));
    }

    private ModuleEntitlements computeEntitlements(Class<?> requestingClass) {
        Module requestingModule = requestingClass.getModule();
        if (PolicyManager.isServerModule(requestingModule)) {
            return this.getModuleScopeEntitlements(this.serverEntitlements, requestingModule.getName(), SERVER_COMPONENT_NAME, PolicyManager.getComponentPathFromClass(requestingClass));
        }
        String pluginName = this.pluginResolver.apply(requestingClass);
        if (pluginName != null) {
            Map<String, List<Entitlement>> pluginEntitlements = this.pluginsEntitlements.get(pluginName);
            if (pluginEntitlements == null) {
                return this.defaultEntitlements(pluginName, this.sourcePaths.get(pluginName), requestingModule.getName());
            }
            return this.getModuleScopeEntitlements(pluginEntitlements, PolicyManager.getScopeName(requestingModule), pluginName, this.sourcePaths.get(pluginName));
        }
        if (!requestingModule.isNamed() && requestingClass.getPackageName().startsWith(this.apmAgentPackageName)) {
            return this.policyEntitlements(APM_AGENT_COMPONENT_NAME, PolicyManager.getComponentPathFromClass(requestingClass), ALL_UNNAMED, this.apmAgentEntitlements);
        }
        return this.defaultEntitlements(UNKNOWN_COMPONENT_NAME, null, requestingModule.getName());
    }

    private static String getScopeName(Module requestingModule) {
        if (!requestingModule.isNamed()) {
            return ALL_UNNAMED;
        }
        return requestingModule.getName();
    }

    static Path getComponentPathFromClass(Class<?> requestingClass) {
        CodeSource codeSource = requestingClass.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return null;
        }
        try {
            return Paths.get(codeSource.getLocation().toURI());
        }
        catch (Exception e) {
            generalLogger.info("Cannot get component path for [{}]: [{}] cannot be converted to a valid Path", new Object[]{requestingClass.getName(), codeSource.getLocation().toString()});
            return null;
        }
    }

    private ModuleEntitlements getModuleScopeEntitlements(Map<String, List<Entitlement>> scopeEntitlements, String scopeName, String componentName, Path componentPath) {
        List<Entitlement> entitlements = scopeEntitlements.get(scopeName);
        if (entitlements == null) {
            return this.defaultEntitlements(componentName, componentPath, scopeName);
        }
        return this.policyEntitlements(componentName, componentPath, scopeName, entitlements);
    }

    private static boolean isServerModule(Module requestingModule) {
        return requestingModule.isNamed() && requestingModule.getLayer() == ModuleLayer.boot();
    }

    Class<?> requestingClass(Class<?> callerClass) {
        if (callerClass != null) {
            return callerClass;
        }
        Optional result = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(frames -> this.findRequestingFrame((Stream<StackWalker.StackFrame>)frames).map(StackWalker.StackFrame::getDeclaringClass));
        return result.orElse(null);
    }

    Optional<StackWalker.StackFrame> findRequestingFrame(Stream<StackWalker.StackFrame> frames) {
        return frames.filter(f -> f.getDeclaringClass().getModule() != this.entitlementsModule).skip(1L).findFirst();
    }

    private static boolean isTriviallyAllowed(Class<?> requestingClass) {
        if (generalLogger.isTraceEnabled()) {
            generalLogger.trace("Stack trace for upcoming trivially-allowed check", (Throwable)new Exception());
        }
        if (requestingClass == null) {
            generalLogger.debug("Entitlement trivially allowed: no caller frames outside the entitlement library");
            return true;
        }
        if (requestingClass == Util.NO_CLASS) {
            generalLogger.debug("Entitlement trivially allowed from outermost frame");
            return true;
        }
        if (SYSTEM_LAYER_MODULES.contains(requestingClass.getModule())) {
            generalLogger.debug("Entitlement trivially allowed from system module [{}]", new Object[]{requestingClass.getModule().getName()});
            return true;
        }
        generalLogger.trace("Entitlement not trivially allowed");
        return false;
    }

    private static String getModuleName(Class<?> requestingClass) {
        String name = requestingClass.getModule().getName();
        return name == null ? ALL_UNNAMED : name;
    }

    public String toString() {
        return "PolicyManager{serverEntitlements=" + String.valueOf(this.serverEntitlements) + ", pluginsEntitlements=" + String.valueOf(this.pluginsEntitlements) + "}";
    }

    record ModuleEntitlements(String componentName, Map<Class<? extends Entitlement>, List<Entitlement>> entitlementsByType, FileAccessTree fileAccess, Logger logger) {
        ModuleEntitlements {
            entitlementsByType = Map.copyOf(entitlementsByType);
        }

        public boolean hasEntitlement(Class<? extends Entitlement> entitlementClass) {
            return this.entitlementsByType.containsKey(entitlementClass);
        }

        public <E extends Entitlement> Stream<E> getEntitlements(Class<E> entitlementClass) {
            List<Entitlement> entitlements = this.entitlementsByType.get(entitlementClass);
            if (entitlements == null) {
                return Stream.empty();
            }
            return entitlements.stream().map(entitlementClass::cast);
        }
    }
}

