/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.cluster.metadata.ShutdownPersistentTasksStatus;
import org.elasticsearch.cluster.metadata.ShutdownPluginsStatus;
import org.elasticsearch.cluster.metadata.ShutdownShardMigrationStatus;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;

public class SingleNodeShutdownStatus
implements Writeable,
ChunkedToXContentObject {
    private final SingleNodeShutdownMetadata metadata;
    private final ShutdownShardMigrationStatus shardMigrationStatus;
    private final ShutdownPersistentTasksStatus persistentTasksStatus;
    private final ShutdownPluginsStatus pluginsStatus;
    private static final ParseField STATUS = new ParseField("status", new String[0]);
    private static final ParseField SHARD_MIGRATION_FIELD = new ParseField("shard_migration", new String[0]);
    private static final ParseField PERSISTENT_TASKS_FIELD = new ParseField("persistent_tasks", new String[0]);
    private static final ParseField PLUGINS_STATUS = new ParseField("plugins", new String[0]);
    private static final ParseField TARGET_NODE_NAME_FIELD = new ParseField("target_node_name", new String[0]);

    public SingleNodeShutdownStatus(SingleNodeShutdownMetadata metadata, ShutdownShardMigrationStatus shardMigrationStatus, ShutdownPersistentTasksStatus persistentTasksStatus, ShutdownPluginsStatus pluginsStatus) {
        this.metadata = Objects.requireNonNull(metadata, "metadata must not be null");
        this.shardMigrationStatus = Objects.requireNonNull(shardMigrationStatus, "shard migration status must not be null");
        this.persistentTasksStatus = Objects.requireNonNull(persistentTasksStatus, "persistent task status must not be null");
        this.pluginsStatus = Objects.requireNonNull(pluginsStatus, "plugin status must not be null");
    }

    public SingleNodeShutdownStatus(StreamInput in) throws IOException {
        this.metadata = new SingleNodeShutdownMetadata(in);
        this.shardMigrationStatus = new ShutdownShardMigrationStatus(in);
        this.persistentTasksStatus = new ShutdownPersistentTasksStatus(in);
        this.pluginsStatus = new ShutdownPluginsStatus(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.metadata.writeTo(out);
        this.shardMigrationStatus.writeTo(out);
        this.persistentTasksStatus.writeTo(out);
        this.pluginsStatus.writeTo(out);
    }

    public SingleNodeShutdownMetadata.Status overallStatus() {
        return SingleNodeShutdownMetadata.Status.combine((SingleNodeShutdownMetadata.Status[])new SingleNodeShutdownMetadata.Status[]{this.migrationStatus().getStatus(), this.pluginsStatus().getStatus(), this.persistentTasksStatus().getStatus()});
    }

    public ShutdownShardMigrationStatus migrationStatus() {
        return this.shardMigrationStatus;
    }

    public ShutdownPersistentTasksStatus persistentTasksStatus() {
        return this.persistentTasksStatus;
    }

    public ShutdownPluginsStatus pluginsStatus() {
        return this.pluginsStatus;
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.shardMigrationStatus, this.persistentTasksStatus, this.pluginsStatus);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SingleNodeShutdownStatus other = (SingleNodeShutdownStatus)obj;
        return this.metadata.equals((Object)other.metadata) && this.shardMigrationStatus.equals((Object)other.shardMigrationStatus) && this.persistentTasksStatus.equals((Object)other.persistentTasksStatus) && this.pluginsStatus.equals((Object)other.pluginsStatus);
    }

    public String toString() {
        return Strings.toString((ChunkedToXContent)this);
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.chunk((builder, p) -> {
            builder.field(SingleNodeShutdownMetadata.NODE_ID_FIELD.getPreferredName(), this.metadata.getNodeId());
            builder.field(SingleNodeShutdownMetadata.NODE_EPHEMERAL_ID_FIELD.getPreferredName(), this.metadata.getNodeEphemeralId());
            builder.field(SingleNodeShutdownMetadata.TYPE_FIELD.getPreferredName(), (Enum)this.metadata.getType());
            builder.field(SingleNodeShutdownMetadata.REASON_FIELD.getPreferredName(), this.metadata.getReason());
            if (this.metadata.getAllocationDelay() != null) {
                builder.field(SingleNodeShutdownMetadata.ALLOCATION_DELAY_FIELD.getPreferredName(), this.metadata.getAllocationDelay().getStringRep());
            }
            builder.timestampFieldsFromUnixEpochMillis(SingleNodeShutdownMetadata.STARTED_AT_MILLIS_FIELD.getPreferredName(), "shutdown_started", this.metadata.getStartedAtMillis());
            builder.field(STATUS.getPreferredName(), (Enum)this.overallStatus());
            return builder;
        }), ChunkedToXContentHelper.field((String)SHARD_MIGRATION_FIELD.getPreferredName(), (ChunkedToXContentObject)this.shardMigrationStatus, (ToXContent.Params)params), ChunkedToXContentHelper.chunk((builder, p) -> {
            builder.field(PERSISTENT_TASKS_FIELD.getPreferredName(), (ToXContent)this.persistentTasksStatus);
            builder.field(PLUGINS_STATUS.getPreferredName(), (ToXContent)this.pluginsStatus);
            if (this.metadata.getTargetNodeName() != null) {
                builder.field(TARGET_NODE_NAME_FIELD.getPreferredName(), this.metadata.getTargetNodeName());
            }
            if (this.metadata.getGracePeriod() != null) {
                builder.timestampField(SingleNodeShutdownMetadata.GRACE_PERIOD_FIELD.getPreferredName(), (Object)this.metadata.getGracePeriod().getStringRep());
            }
            return builder;
        }), ChunkedToXContentHelper.endObject()});
    }
}

