/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.core.InternalApi;
import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.http.BaseHttpServiceException;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;

@InternalApi
public final class StorageException
extends BaseHttpServiceException {
    private static final String INTERNAL_ERROR = "internalError";
    private static final String CONNECTION_CLOSED_PREMATURELY = "connectionClosedPrematurely";
    static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of((Object)new BaseServiceException.Error(Integer.valueOf(504), null), (Object)new BaseServiceException.Error(Integer.valueOf(503), null), (Object)new BaseServiceException.Error(Integer.valueOf(502), null), (Object)new BaseServiceException.Error(Integer.valueOf(500), null), (Object)new BaseServiceException.Error(Integer.valueOf(429), null), (Object)new BaseServiceException.Error(Integer.valueOf(408), null), (Object[])new BaseServiceException.Error[]{new BaseServiceException.Error(null, "internalError"), new BaseServiceException.Error(null, "connectionClosedPrematurely")});
    private static final long serialVersionUID = -4168430271327813063L;

    public StorageException(int code, String message) {
        this(code, message, null);
    }

    public StorageException(int code, String message, Throwable cause) {
        super(code, message, null, true, RETRYABLE_ERRORS, cause);
    }

    public StorageException(int code, String message, String reason, Throwable cause) {
        super(code, message, reason, true, RETRYABLE_ERRORS, cause);
    }

    public StorageException(IOException exception) {
        super(exception, true, RETRYABLE_ERRORS);
    }

    public StorageException(GoogleJsonError error) {
        super(error, true, RETRYABLE_ERRORS);
    }

    public static StorageException translateAndThrow(RetryHelper.RetryHelperException ex) {
        BaseServiceException.translate((RetryHelper.RetryHelperException)ex);
        throw StorageException.getStorageException((Throwable)ex);
    }

    private static StorageException getStorageException(Throwable t) {
        return new StorageException(0, t.getMessage(), t.getCause());
    }

    static BaseServiceException coalesce(Throwable t) {
        if (t instanceof BaseServiceException) {
            return (BaseServiceException)t;
        }
        if (t.getCause() instanceof BaseServiceException) {
            return (BaseServiceException)t.getCause();
        }
        return StorageException.getStorageException(t);
    }

    public static StorageException translate(IOException exception) {
        String message = exception.getMessage();
        if (message != null && (message.contains("Connection closed prematurely") || message.contains("Premature EOF"))) {
            return new StorageException(0, message, CONNECTION_CLOSED_PREMATURELY, exception);
        }
        return new StorageException(exception);
    }
}

