/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.health.Diagnosis;
import org.elasticsearch.health.HealthIndicatorDetails;
import org.elasticsearch.health.HealthIndicatorImpact;
import org.elasticsearch.health.HealthIndicatorResult;
import org.elasticsearch.health.HealthIndicatorService;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.health.ImpactArea;
import org.elasticsearch.health.SimpleHealthIndicatorDetails;
import org.elasticsearch.health.node.HealthInfo;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.slm.SnapshotInvocationRecord;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;

public final class SlmHealthIndicatorService
implements HealthIndicatorService {
    public static final String NAME = "slm";
    public static final String HELP_URL = "https://ela.st/fix-slm";
    public static final Diagnosis SLM_NOT_RUNNING = new Diagnosis(new Diagnosis.Definition("slm", "slm_disabled", "Snapshot Lifecycle Management is stopped", "Start Snapshot Lifecycle Management using [POST /_slm/start].", "https://ela.st/fix-slm"), null);
    private static final DateFormatter FORMATTER = DateFormatter.forPattern((String)"iso8601").withZone((ZoneId)ZoneOffset.UTC);
    public static final String DIAGNOSIS_CHECK_RECENTLY_FAILED_SNAPSHOTS_ID = "check_recent_snapshot_failures";
    public static final String DIAGNOSIS_CHECK_RECENTLY_FAILED_SNAPSHOTS_HELP_URL = "https://ela.st/fix-recent-snapshot-failures";
    public static final String AUTOMATION_DISABLED_IMPACT_ID = "automation_disabled";
    public static final String STALE_SNAPSHOTS_IMPACT_ID = "stale_snapshots";
    private final ClusterService clusterService;
    private volatile long failedSnapshotWarnThreshold;

    static Diagnosis.Definition checkRecentlyFailedSnapshots(String causeText, String actionText) {
        return new Diagnosis.Definition(NAME, DIAGNOSIS_CHECK_RECENTLY_FAILED_SNAPSHOTS_ID, causeText, actionText, DIAGNOSIS_CHECK_RECENTLY_FAILED_SNAPSHOTS_HELP_URL);
    }

    public SlmHealthIndicatorService(ClusterService clusterService) {
        this.clusterService = clusterService;
        this.failedSnapshotWarnThreshold = (Long)clusterService.getClusterSettings().get(LifecycleSettings.SLM_HEALTH_FAILED_SNAPSHOT_WARN_THRESHOLD_SETTING);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LifecycleSettings.SLM_HEALTH_FAILED_SNAPSHOT_WARN_THRESHOLD_SETTING, this::setFailedSnapshotWarnThreshold);
    }

    public void setFailedSnapshotWarnThreshold(long value) {
        this.failedSnapshotWarnThreshold = value;
    }

    public String name() {
        return NAME;
    }

    public HealthIndicatorResult calculate(boolean verbose, int maxAffectedResourcesCount, HealthInfo healthInfo) {
        ClusterState currentState = this.clusterService.state();
        SnapshotLifecycleMetadata slmMetadata = (SnapshotLifecycleMetadata)currentState.metadata().custom("snapshot_lifecycle", (Metadata.Custom)SnapshotLifecycleMetadata.EMPTY);
        OperationMode currentMode = LifecycleOperationMetadata.currentSLMMode((ClusterState)currentState);
        if (slmMetadata.getSnapshotConfigurations().isEmpty()) {
            return this.createIndicator(HealthStatus.GREEN, "No Snapshot Lifecycle Management policies configured", SlmHealthIndicatorService.createDetails(verbose, Collections.emptyList(), slmMetadata, currentMode), Collections.emptyList(), Collections.emptyList());
        }
        if (currentMode != OperationMode.RUNNING) {
            List<HealthIndicatorImpact> impacts = Collections.singletonList(new HealthIndicatorImpact(NAME, AUTOMATION_DISABLED_IMPACT_ID, 3, "Scheduled snapshots are not running. New backup snapshots will not be created automatically.", List.of(ImpactArea.BACKUP)));
            return this.createIndicator(HealthStatus.YELLOW, "Snapshot Lifecycle Management is not running", SlmHealthIndicatorService.createDetails(verbose, Collections.emptyList(), slmMetadata, currentMode), impacts, verbose ? List.of(SLM_NOT_RUNNING) : List.of());
        }
        List<SnapshotLifecyclePolicyMetadata> unhealthyPolicies = slmMetadata.getSnapshotConfigurations().values().stream().filter(metadata -> SlmHealthIndicatorService.snapshotFailuresExceedWarningCount(this.failedSnapshotWarnThreshold, metadata)).sorted(Comparator.comparing(SnapshotLifecyclePolicyMetadata::getId)).toList();
        if (unhealthyPolicies.size() > 0) {
            List<HealthIndicatorImpact> impacts = Collections.singletonList(new HealthIndicatorImpact(NAME, STALE_SNAPSHOTS_IMPACT_ID, 2, "Some automated snapshots have not had a successful execution recently. Indices restored from affected snapshots may not contain recent changes.", List.of(ImpactArea.BACKUP)));
            String unhealthyPolicyCauses = unhealthyPolicies.stream().map(policy -> "- [" + policy.getId() + "] had [" + policy.getInvocationsSinceLastSuccess() + "] repeated failures without successful execution" + (String)(policy.getLastSuccess() != null && policy.getLastSuccess().getSnapshotStartTimestamp() != null ? " since [" + FORMATTER.formatMillis(policy.getLastSuccess().getSnapshotStartTimestamp().longValue()) + "]" : "")).collect(Collectors.joining("\n"));
            String cause = (unhealthyPolicies.size() > 1 ? "Several automated snapshot policies are unhealthy:\n" : "An automated snapshot policy is unhealthy:\n") + unhealthyPolicyCauses;
            String unhealthyPolicyActions = unhealthyPolicies.stream().map(policy -> "- GET /_slm/policy/" + policy.getId() + "?human").collect(Collectors.joining("\n"));
            String action = "Check the snapshot lifecycle " + (unhealthyPolicies.size() > 1 ? "policies" : "policy") + " for detailed failure info:\n" + unhealthyPolicyActions;
            return this.createIndicator(HealthStatus.YELLOW, "Encountered [" + unhealthyPolicies.size() + "] unhealthy snapshot lifecycle management policies.", SlmHealthIndicatorService.createDetails(verbose, unhealthyPolicies, slmMetadata, currentMode), impacts, verbose ? List.of(new Diagnosis(SlmHealthIndicatorService.checkRecentlyFailedSnapshots(cause, action), List.of(new Diagnosis.Resource(Diagnosis.Resource.Type.SLM_POLICY, unhealthyPolicies.stream().map(SnapshotLifecyclePolicyMetadata::getId).limit(Math.min(unhealthyPolicies.size(), maxAffectedResourcesCount)).toList())))) : List.of());
        }
        return this.createIndicator(HealthStatus.GREEN, "Snapshot Lifecycle Management is running", SlmHealthIndicatorService.createDetails(verbose, Collections.emptyList(), slmMetadata, currentMode), Collections.emptyList(), Collections.emptyList());
    }

    static boolean snapshotFailuresExceedWarningCount(long failedSnapshotWarnThreshold, SnapshotLifecyclePolicyMetadata policyMetadata) {
        SnapshotInvocationRecord lastFailure = policyMetadata.getLastFailure();
        if (lastFailure == null) {
            return false;
        }
        SnapshotInvocationRecord lastSuccess = policyMetadata.getLastSuccess();
        if (lastSuccess != null && policyMetadata.getInvocationsSinceLastSuccess() == 0L) {
            return false;
        }
        return policyMetadata.getInvocationsSinceLastSuccess() >= failedSnapshotWarnThreshold;
    }

    private static HealthIndicatorDetails createDetails(boolean verbose, Collection<SnapshotLifecyclePolicyMetadata> unhealthyPolicies, SnapshotLifecycleMetadata metadata, OperationMode mode) {
        if (!verbose) {
            return HealthIndicatorDetails.EMPTY;
        }
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put("slm_status", mode);
        details.put("policies", metadata.getSnapshotConfigurations().size());
        if (unhealthyPolicies.size() > 0) {
            details.put("unhealthy_policies", Map.of("count", unhealthyPolicies.size(), "invocations_since_last_success", unhealthyPolicies.stream().collect(Collectors.toMap(SnapshotLifecyclePolicyMetadata::getId, SnapshotLifecyclePolicyMetadata::getInvocationsSinceLastSuccess))));
        }
        return new SimpleHealthIndicatorDetails(details);
    }
}

