/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.service;

import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountRequest;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountResponse;
import org.elasticsearch.xpack.core.security.action.service.ServiceAccountInfo;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;

public class TransportGetServiceAccountAction
extends HandledTransportAction<GetServiceAccountRequest, GetServiceAccountResponse> {
    @Inject
    public TransportGetServiceAccountAction(TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/xpack/security/service_account/get", transportService, actionFilters, GetServiceAccountRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void doExecute(Task task, GetServiceAccountRequest request, ActionListener<GetServiceAccountResponse> listener) {
        Predicate<ServiceAccount> filter = Predicates.always();
        if (request.getNamespace() != null) {
            filter = filter.and(v -> v.id().namespace().equals(request.getNamespace()));
        }
        if (request.getServiceName() != null) {
            filter = filter.and(v -> v.id().serviceName().equals(request.getServiceName()));
        }
        ServiceAccountInfo[] serviceAccountInfos = (ServiceAccountInfo[])ServiceAccountService.getServiceAccounts().values().stream().filter(filter).map(v -> new ServiceAccountInfo(v.id().asPrincipal(), v.roleDescriptor())).toArray(ServiceAccountInfo[]::new);
        listener.onResponse((Object)new GetServiceAccountResponse(serviceAccountInfos));
    }
}

