/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authz.store.FileRolesStore;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class RoleProviders {
    private final List<ChangeListener> changeListeners = new CopyOnWriteArrayList<ChangeListener>();
    private final FileRolesStore fileRolesStore;
    private final NativeRolesStore nativeRolesStore;
    private final ReservedRolesStore reservedRolesStore;
    private final Map<String, List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>>> customRoleProviders;
    private final XPackLicenseState licenseState;
    private List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> activeRoleProviders;

    public RoleProviders(ReservedRolesStore reservedRolesStore, FileRolesStore fileRolesStore, NativeRolesStore nativeRolesStore, Map<String, List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>>> customRoleProviders, XPackLicenseState licenseState) {
        this.reservedRolesStore = Objects.requireNonNull(reservedRolesStore);
        this.fileRolesStore = Objects.requireNonNull(fileRolesStore);
        this.fileRolesStore.addListener(this::onRoleModification);
        this.nativeRolesStore = Objects.requireNonNull(nativeRolesStore);
        this.customRoleProviders = Objects.requireNonNull(customRoleProviders);
        this.licenseState = licenseState;
        this.licenseState.addListener(this::onLicenseChange);
        this.activeRoleProviders = this.calculateActiveRoleProviders();
    }

    private void onLicenseChange() {
        List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> previousProviders = this.activeRoleProviders;
        this.activeRoleProviders = this.calculateActiveRoleProviders();
        if (!this.activeRoleProviders.equals(previousProviders)) {
            this.changeListeners.forEach(ChangeListener::providersChanged);
        }
    }

    private List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> calculateActiveRoleProviders() {
        List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> builtInRoleProviders = List.of(this.reservedRolesStore, this.fileRolesStore, this.nativeRolesStore);
        if (this.customRoleProviders.isEmpty()) {
            return builtInRoleProviders;
        }
        ArrayList<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> providers = new ArrayList<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>>();
        providers.addAll(builtInRoleProviders);
        XPackLicenseState fixedLicenseState = this.licenseState.copyCurrentLicenseState();
        this.customRoleProviders.forEach((name, customProviders) -> {
            if (Security.CUSTOM_ROLE_PROVIDERS_FEATURE.checkAndStartTracking(fixedLicenseState, name)) {
                providers.addAll((Collection<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>>)customProviders);
            } else {
                Security.CUSTOM_ROLE_PROVIDERS_FEATURE.stopTracking(fixedLicenseState, name);
            }
        });
        return List.copyOf(providers);
    }

    private void onRoleModification(Set<String> roles) {
        this.changeListeners.forEach(l -> l.rolesChanged(roles));
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(Objects.requireNonNull(listener));
    }

    public List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> getProviders() {
        return this.activeRoleProviders;
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        Map<String, Object> fileUsage = this.fileRolesStore.usageStats();
        this.nativeRolesStore.usageStats((ActionListener<Map<String, Object>>)listener.map(nativeUsage -> Map.ofEntries(Map.entry("file", fileUsage), Map.entry("native", nativeUsage))));
    }

    static interface ChangeListener {
        public void rolesChanged(Set<String> var1);

        public void providersChanged();
    }
}

