/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.ReplaceCertificateKeyStoreContent;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class KeyStoreDataReplaceCertificateKeyStoreContent
extends ReplaceCertificateKeyStoreContent {
    static final byte TYPE_KEY_STORE_CONTENT = -95;
    private static final byte TYPE_KEY_STORE_DATA = -120;
    private static final byte TYPE_KEY_STORE_PIN = -119;
    private static final byte TYPE_PRIVATE_KEY_PIN = -118;
    private static final byte TYPE_KEY_STORE_TYPE = -117;
    private static final byte TYPE_SOURCE_CERTIFICATE_ALIAS = -116;
    private static final long serialVersionUID = -8068834762688653001L;
    @NotNull
    private final byte[] keyStoreData;
    @NotNull
    private final String keyStorePIN;
    @Nullable
    private final String keyStoreType;
    @Nullable
    private final String privateKeyPIN;
    @Nullable
    private final String sourceCertificateAlias;

    public KeyStoreDataReplaceCertificateKeyStoreContent(@NotNull byte[] keyStoreData, @NotNull String keyStorePIN, @Nullable String privateKeyPIN, @Nullable String keyStoreType, @Nullable String sourceCertificateAlias) {
        Validator.ensureNotNullOrEmpty(keyStoreData, "KeyStoreDataReplaceCertificateKeyStoreContent.keyStoreData must not be null or empty.");
        Validator.ensureNotNullOrEmpty(keyStorePIN, "KeyStoreDataReplaceCertificateKeyStoreContent.keyStorePIN must not be null or empty.");
        this.keyStoreData = keyStoreData;
        this.keyStorePIN = keyStorePIN;
        this.privateKeyPIN = privateKeyPIN;
        this.keyStoreType = keyStoreType;
        this.sourceCertificateAlias = sourceCertificateAlias;
    }

    public KeyStoreDataReplaceCertificateKeyStoreContent(@NotNull File keyStoreFile, @NotNull String keyStorePIN, @Nullable String privateKeyPIN, @Nullable String keyStoreType, @Nullable String sourceCertificateAlias) throws IOException {
        this(StaticUtils.readFileBytes(keyStoreFile), keyStorePIN, privateKeyPIN, keyStoreType, sourceCertificateAlias);
    }

    @NotNull
    public byte[] getKeyStoreData() {
        return this.keyStoreData;
    }

    @NotNull
    public String getKeyStorePIN() {
        return this.keyStorePIN;
    }

    @Nullable
    public String getPrivateKeyPIN() {
        return this.privateKeyPIN;
    }

    @Nullable
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Nullable
    public String getSourceCertificateAlias() {
        return this.sourceCertificateAlias;
    }

    @NotNull
    static KeyStoreDataReplaceCertificateKeyStoreContent decodeInternal(@NotNull ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = element.decodeAsSequence().elements();
            byte[] keyStoreData = elements[0].decodeAsOctetString().getValue();
            String keyStorePIN = elements[1].decodeAsOctetString().stringValue();
            String privateKeyPIN = null;
            String keyStoreType = null;
            String sourceCertificateAlias = null;
            block7: for (int i = 2; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -118: {
                        privateKeyPIN = elements[i].decodeAsOctetString().stringValue();
                        continue block7;
                    }
                    case -117: {
                        keyStoreType = elements[i].decodeAsOctetString().stringValue();
                        continue block7;
                    }
                    case -116: {
                        sourceCertificateAlias = elements[i].decodeAsOctetString().stringValue();
                    }
                }
            }
            return new KeyStoreDataReplaceCertificateKeyStoreContent(keyStoreData, keyStorePIN, privateKeyPIN, keyStoreType, sourceCertificateAlias);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_KSD_KSC_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    @NotNull
    public ASN1Element encode() {
        ArrayList<ASN1OctetString> elements = new ArrayList<ASN1OctetString>(5);
        elements.add(new ASN1OctetString(-120, this.keyStoreData));
        elements.add(new ASN1OctetString(-119, this.keyStorePIN));
        if (this.privateKeyPIN != null) {
            elements.add(new ASN1OctetString(-118, this.privateKeyPIN));
        }
        if (this.keyStoreType != null) {
            elements.add(new ASN1OctetString(-117, this.keyStoreType));
        }
        if (this.sourceCertificateAlias != null) {
            elements.add(new ASN1OctetString(-116, this.sourceCertificateAlias));
        }
        return new ASN1Sequence(-95, elements);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("KeyStoreDataReplaceCertificateKeyStoreContent(keyStoreDataSizeBytes=");
        buffer.append(this.keyStoreData.length);
        buffer.append(", privateKeyPINProvided=");
        buffer.append(this.privateKeyPIN != null);
        if (this.keyStoreType != null) {
            buffer.append(", keyStoreType='");
            buffer.append(this.keyStoreType);
            buffer.append('\'');
        }
        if (this.sourceCertificateAlias != null) {
            buffer.append(", sourceCertificateAlias='");
            buffer.append(this.sourceCertificateAlias);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

