/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fa.PersianCharFilter;
import org.apache.lucene.analysis.fa.PersianNormalizationFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;

public class PersianAnalyzerProvider
extends AbstractIndexAnalyzerProvider<StopwordAnalyzerBase> {
    private final StopwordAnalyzerBase analyzer;

    PersianAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(name);
        this.analyzer = indexSettings.getIndexVersionCreated().onOrAfter((VersionId)IndexVersions.UPGRADE_TO_LUCENE_10_0_0) ? new PersianAnalyzer(Analysis.parseStopWords((Environment)env, (Settings)settings, (CharArraySet)PersianAnalyzer.getDefaultStopSet())) : new StopwordAnalyzerBase(this, Analysis.parseStopWords((Environment)env, (Settings)settings, (CharArraySet)PersianAnalyzer.getDefaultStopSet())){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer source = new StandardTokenizer();
                LowerCaseFilter result = new LowerCaseFilter((TokenStream)source);
                result = new DecimalDigitFilter((TokenStream)result);
                result = new ArabicNormalizationFilter((TokenStream)result);
                result = new PersianNormalizationFilter((TokenStream)result);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new StopFilter((TokenStream)result, this.stopwords));
            }

            protected TokenStream normalize(String fieldName, TokenStream in) {
                LowerCaseFilter result = new LowerCaseFilter(in);
                result = new DecimalDigitFilter((TokenStream)result);
                result = new ArabicNormalizationFilter((TokenStream)result);
                result = new PersianNormalizationFilter((TokenStream)result);
                return result;
            }

            protected Reader initReader(String fieldName, Reader reader) {
                return new PersianCharFilter(reader);
            }
        };
    }

    public StopwordAnalyzerBase get() {
        return this.analyzer;
    }
}

