/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.analyze;

import java.io.InputStream;
import org.elasticsearch.repositories.blobstore.testkit.analyze.RandomBlobContent;

class RandomBlobContentStream
extends InputStream {
    private final long length;
    private final RandomBlobContent randomBlobContent;
    private long position;
    private long markPosition;

    RandomBlobContentStream(RandomBlobContent randomBlobContent, long length) {
        assert (0L < length);
        this.randomBlobContent = randomBlobContent;
        this.length = length;
    }

    private int bufferPosition() {
        return Math.toIntExact(this.position % (long)this.randomBlobContent.buffer.length);
    }

    @Override
    public int read() {
        this.randomBlobContent.ensureNotCancelled(this.position + "/" + this.length);
        if (this.length <= this.position) {
            return -1;
        }
        int b = Byte.toUnsignedInt(this.randomBlobContent.buffer[this.bufferPosition()]);
        ++this.position;
        if (this.position == this.length) {
            this.randomBlobContent.onLastRead();
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        this.randomBlobContent.ensureNotCancelled(this.position + "+" + len + "/" + this.length);
        if (this.length <= this.position) {
            return -1;
        }
        int remaining = len = Math.toIntExact(Math.min((long)len, this.length - this.position));
        while (0 < remaining) {
            assert (this.position < this.length) : this.position + " vs " + this.length;
            int bufferPosition = this.bufferPosition();
            int copied = Math.min(this.randomBlobContent.buffer.length - bufferPosition, remaining);
            System.arraycopy(this.randomBlobContent.buffer, bufferPosition, b, off, copied);
            off += copied;
            remaining -= copied;
            this.position += (long)copied;
        }
        assert (this.position <= this.length) : this.position + " vs " + this.length;
        if (this.position == this.length) {
            this.randomBlobContent.onLastRead();
        }
        return len;
    }

    @Override
    public void close() {
        this.randomBlobContent.onLastRead();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markPosition = this.position;
    }

    @Override
    public synchronized void reset() {
        this.position = this.markPosition;
    }

    @Override
    public long skip(long n) {
        long oldPosition = this.position;
        this.position = Math.min(this.length, this.position + n);
        return this.position - oldPosition;
    }

    @Override
    public int available() {
        return Math.toIntExact(Math.min(this.length - this.position, Integer.MAX_VALUE));
    }
}

