/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleOriginationDateParser;
import org.elasticsearch.xpack.core.ilm.InitializePolicyException;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionStateUtils;
import org.elasticsearch.xpack.core.ilm.Step;

public final class InitializePolicyContextStep
extends ClusterStateActionStep {
    public static final String INITIALIZATION_PHASE = "new";
    public static final Step.StepKey KEY = new Step.StepKey("new", "init", "init");
    private static final Logger logger = LogManager.getLogger(InitializePolicyContextStep.class);

    InitializePolicyContextStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetadata indexMetadata = clusterState.getMetadata().index(index);
        if (indexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().action(), (Object)index.getName());
            return clusterState;
        }
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        if (lifecycleState.lifecycleDate() != null) {
            return clusterState;
        }
        LifecycleExecutionState newLifecycleState = LifecycleExecutionState.builder((LifecycleExecutionState)lifecycleState).setIndexCreationDate(Long.valueOf(indexMetadata.getCreationDate())).build();
        Long parsedOriginationDate = null;
        try {
            if (IndexLifecycleOriginationDateParser.shouldParseIndexName(indexMetadata.getSettings())) {
                long parsedDate = IndexLifecycleOriginationDateParser.parseIndexNameAndExtractDate(index.getName());
                parsedOriginationDate = parsedDate;
            }
        }
        catch (Exception e) {
            String policyName = indexMetadata.getLifecyclePolicyName();
            throw new InitializePolicyException(policyName, index.getName(), e);
        }
        if (parsedOriginationDate == null) {
            return LifecycleExecutionStateUtils.newClusterStateWithLifecycleState(clusterState, indexMetadata.getIndex(), newLifecycleState);
        }
        IndexMetadata.Builder builder = IndexMetadata.builder((IndexMetadata)indexMetadata);
        builder.settingsVersion(indexMetadata.getSettingsVersion() + 1L).settings(Settings.builder().put(indexMetadata.getSettings()).put("index.lifecycle.origination_date", parsedOriginationDate.longValue()).build());
        builder.putCustom("ilm", newLifecycleState.asMap());
        return ClusterState.builder((ClusterState)clusterState).metadata(Metadata.builder((Metadata)clusterState.metadata()).put(builder).build()).build();
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

