/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.kerberos;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;

public final class KerberosRealmSettings {
    public static final String TYPE = "kerberos";
    public static final Setting.AffixSetting<String> HTTP_SERVICE_KEYTAB_PATH = RealmSettings.simpleString("kerberos", "keytab.path", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<Boolean> SETTING_KRB_DEBUG_ENABLE = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("kerberos"), (String)"krb.debug", key -> Setting.boolSetting((String)key, (boolean)Boolean.FALSE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> SETTING_REMOVE_REALM_NAME = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("kerberos"), (String)"remove_realm_name", key -> Setting.boolSetting((String)key, (boolean)Boolean.FALSE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final TimeValue DEFAULT_TTL = TimeValue.timeValueMinutes((long)20L);
    private static final int DEFAULT_MAX_USERS = 100000;
    public static final Setting.AffixSetting<TimeValue> CACHE_TTL_SETTING = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("kerberos"), (String)"cache.ttl", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_TTL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> CACHE_MAX_USERS_SETTING = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("kerberos"), (String)"cache.max_users", key -> Setting.intSetting((String)key, (int)100000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);

    private KerberosRealmSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings() {
        HashSet settings = Sets.newHashSet((Object[])new Setting.AffixSetting[]{HTTP_SERVICE_KEYTAB_PATH, CACHE_TTL_SETTING, CACHE_MAX_USERS_SETTING, SETTING_KRB_DEBUG_ENABLE, SETTING_REMOVE_REALM_NAME});
        settings.addAll(DelegatedAuthorizationSettings.getSettings(TYPE));
        settings.addAll(RealmSettings.getStandardSettings(TYPE));
        return settings;
    }
}

