/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.get;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ToXContent;

public class GetIndexResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private Map<String, MappingMetadata> mappings = Map.of();
    private Map<String, List<AliasMetadata>> aliases = Map.of();
    private Map<String, Settings> settings = Map.of();
    private Map<String, Settings> defaultSettings = Map.of();
    private Map<String, String> dataStreams = Map.of();
    private final String[] indices;

    public GetIndexResponse(String[] indices, Map<String, MappingMetadata> mappings, Map<String, List<AliasMetadata>> aliases, Map<String, Settings> settings, Map<String, Settings> defaultSettings, Map<String, String> dataStreams) {
        this.indices = indices;
        Arrays.sort(indices);
        if (mappings != null) {
            this.mappings = mappings;
        }
        if (aliases != null) {
            this.aliases = aliases;
        }
        if (settings != null) {
            this.settings = settings;
        }
        if (defaultSettings != null) {
            this.defaultSettings = defaultSettings;
        }
        if (dataStreams != null) {
            this.dataStreams = dataStreams;
        }
    }

    GetIndexResponse(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.mappings = in.readImmutableOpenMap(StreamInput::readString, in.getTransportVersion().before(TransportVersions.V_8_0_0) ? i -> {
            int numMappings = i.readVInt();
            assert (numMappings == 0 || numMappings == 1) : "Expected 0 or 1 mappings but got " + numMappings;
            if (numMappings == 1) {
                String type = i.readString();
                assert ("_doc".equals(type)) : "Expected [_doc] but got [" + type + "]";
                return new MappingMetadata(i);
            }
            return MappingMetadata.EMPTY_MAPPINGS;
        } : i -> i.readBoolean() ? new MappingMetadata(i) : MappingMetadata.EMPTY_MAPPINGS);
        this.aliases = in.readImmutableOpenMap(StreamInput::readString, i -> i.readCollectionAsList(AliasMetadata::new));
        this.settings = in.readImmutableOpenMap(StreamInput::readString, Settings::readSettingsFromStream);
        this.defaultSettings = in.readImmutableOpenMap(StreamInput::readString, Settings::readSettingsFromStream);
        this.dataStreams = in.readImmutableOpenMap(StreamInput::readString, StreamInput::readOptionalString);
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] getIndices() {
        return this.indices();
    }

    public Map<String, MappingMetadata> mappings() {
        return this.mappings;
    }

    public Map<String, MappingMetadata> getMappings() {
        return this.mappings();
    }

    public Map<String, List<AliasMetadata>> aliases() {
        return this.aliases;
    }

    public Map<String, List<AliasMetadata>> getAliases() {
        return this.aliases();
    }

    public Map<String, Settings> settings() {
        return this.settings;
    }

    public Map<String, String> dataStreams() {
        return this.dataStreams;
    }

    public Map<String, String> getDataStreams() {
        return this.dataStreams();
    }

    public Map<String, Settings> defaultSettings() {
        return this.defaultSettings;
    }

    public Map<String, Settings> getSettings() {
        return this.settings();
    }

    public String getSetting(String index, String setting) {
        Settings indexSettings = this.settings.get(index);
        if (setting != null) {
            if (indexSettings != null && indexSettings.hasValue(setting)) {
                return indexSettings.get(setting);
            }
            Settings defaultIndexSettings = this.defaultSettings.get(index);
            if (defaultIndexSettings != null) {
                return defaultIndexSettings.get(setting);
            }
            return null;
        }
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.indices);
        MappingMetadata.writeMappingMetadata(out, this.mappings);
        out.writeMap(this.aliases, StreamOutput::writeCollection);
        out.writeMap(this.settings, StreamOutput::writeWriteable);
        out.writeMap(this.defaultSettings, StreamOutput::writeWriteable);
        out.writeMap(this.dataStreams, StreamOutput::writeOptionalString);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.concat(Iterators.single((builder, params) -> builder.startObject()), Iterators.map(Iterators.forArray(this.indices), index -> (builder, params) -> {
            String dataStream;
            builder.startObject(index);
            builder.startObject("aliases");
            List<AliasMetadata> indexAliases = this.aliases.get(index);
            if (indexAliases != null) {
                for (AliasMetadata alias : indexAliases) {
                    AliasMetadata.Builder.toXContent(alias, builder, params);
                }
            }
            builder.endObject();
            MappingMetadata indexMappings = this.mappings.get(index);
            if (indexMappings == null) {
                builder.startObject("mappings").endObject();
            } else {
                builder.field("mappings", indexMappings.sourceAsMap());
            }
            builder.startObject("settings");
            Settings indexSettings = this.settings.get(index);
            if (indexSettings != null) {
                indexSettings.toXContent(builder, params);
            }
            builder.endObject();
            Settings defaultIndexSettings = this.defaultSettings.get(index);
            if (defaultIndexSettings != null && !defaultIndexSettings.isEmpty()) {
                builder.startObject("defaults");
                defaultIndexSettings.toXContent(builder, params);
                builder.endObject();
            }
            if ((dataStream = this.dataStreams.get(index)) != null) {
                builder.field("data_stream", dataStream);
            }
            return builder.endObject();
        }), Iterators.single((builder, params) -> builder.endObject()));
    }

    public String toString() {
        return Strings.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetIndexResponse that = (GetIndexResponse)o;
        return Arrays.equals(this.indices, that.indices) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.mappings, that.mappings) && Objects.equals(this.settings, that.settings) && Objects.equals(this.defaultSettings, that.defaultSettings) && Objects.equals(this.dataStreams, that.dataStreams);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.aliases, this.mappings, this.settings, this.defaultSettings, this.dataStreams);
    }
}

