/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class SearchPhaseExecutionException
extends ElasticsearchException {
    private final String phaseName;
    private final ShardSearchFailure[] shardFailures;

    public SearchPhaseExecutionException(String phaseName, String msg, ShardSearchFailure[] shardFailures) {
        this(phaseName, msg, null, shardFailures);
    }

    public SearchPhaseExecutionException(String phaseName, String msg, Throwable cause, ShardSearchFailure[] shardFailures) {
        super(msg, SearchPhaseExecutionException.deduplicateCause(cause, shardFailures), new Object[0]);
        this.phaseName = phaseName;
        this.shardFailures = shardFailures;
    }

    public SearchPhaseExecutionException(StreamInput in) throws IOException {
        super(in);
        this.phaseName = in.readOptionalString();
        this.shardFailures = in.readArray(ShardSearchFailure::readShardSearchFailure, ShardSearchFailure[]::new);
    }

    @Override
    protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
        super.writeTo(out, nestedExceptionsWriter);
        out.writeOptionalString(this.phaseName);
        out.writeArray(this.shardFailures);
    }

    private static Throwable deduplicateCause(Throwable cause, ShardSearchFailure[] shardFailures) {
        if (shardFailures == null) {
            throw new IllegalArgumentException("shardSearchFailures must not be null");
        }
        if (cause != null) {
            for (ShardSearchFailure failure : shardFailures) {
                if (failure.getCause() != cause) continue;
                return null;
            }
        }
        return cause;
    }

    @Override
    public RestStatus status() {
        if (this.shardFailures.length == 0) {
            return this.getCause() == null ? RestStatus.SERVICE_UNAVAILABLE : ExceptionsHelper.status(this.getCause());
        }
        RestStatus status = null;
        for (ShardSearchFailure shardFailure : this.shardFailures) {
            RestStatus shardStatus = shardFailure.status();
            int statusCode = shardStatus.getStatus();
            if (statusCode >= 502 && statusCode <= 504) {
                return shardStatus;
            }
            if (statusCode < 500) continue;
            status = shardStatus;
        }
        return status == null ? this.shardFailures[0].status() : status;
    }

    public ShardSearchFailure[] shardFailures() {
        return this.shardFailures;
    }

    @Override
    public Throwable getCause() {
        ElasticsearchException[] elasticsearchExceptionArray;
        int n;
        int n2;
        Throwable cause = super.getCause();
        if (cause == null && (n2 = 0) < (n = (elasticsearchExceptionArray = this.guessRootCauses()).length)) {
            ElasticsearchException rootCause = elasticsearchExceptionArray[n2];
            return rootCause;
        }
        return cause;
    }

    private static String buildMessage(String phaseName, String msg, ShardSearchFailure[] shardFailures) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to execute phase [").append(phaseName).append("], ").append(msg);
        if (!CollectionUtils.isEmpty(shardFailures)) {
            sb.append("; shardFailures ");
            for (ShardSearchFailure shardFailure : shardFailures) {
                if (shardFailure.shard() != null) {
                    sb.append("{").append(shardFailure.shard()).append(": ").append(shardFailure.reason()).append("}");
                    continue;
                }
                sb.append("{").append(shardFailure.reason()).append("}");
            }
        }
        return sb.toString();
    }

    @Override
    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ShardOperationFailedException[] failures;
        builder.field("phase", this.phaseName);
        builder.field("grouped", true);
        builder.field("failed_shards");
        builder.startArray();
        for (ShardOperationFailedException failure : failures = ExceptionsHelper.groupBy(this.shardFailures)) {
            failure.toXContent(builder, params);
        }
        builder.endArray();
    }

    @Override
    protected XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, int nestedLevel) throws IOException {
        Throwable ex = ExceptionsHelper.unwrapCause(this);
        if (ex != this) {
            SearchPhaseExecutionException.generateThrowableXContent(builder, params, this, nestedLevel);
        } else {
            SearchPhaseExecutionException.innerToXContent(builder, params, this, this.getExceptionName(), this.getMessage(), this.getHeaders(), this.getMetadata(), super.getCause(), nestedLevel);
        }
        return builder;
    }

    @Override
    public ElasticsearchException[] guessRootCauses() {
        ShardOperationFailedException[] failures = ExceptionsHelper.groupBy(this.shardFailures);
        ArrayList<ElasticsearchException> rootCauses = new ArrayList<ElasticsearchException>(failures.length);
        for (ShardOperationFailedException failure : failures) {
            ElasticsearchException[] guessRootCauses = ElasticsearchException.guessRootCauses(failure.getCause());
            rootCauses.addAll(Arrays.asList(guessRootCauses));
        }
        return rootCauses.toArray(new ElasticsearchException[0]);
    }

    @Override
    public String toString() {
        return SearchPhaseExecutionException.buildMessage(this.phaseName, this.getMessage(), this.shardFailures);
    }

    public String getPhaseName() {
        return this.phaseName;
    }
}

