/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.rest.RestStatus;

public final class NotSerializableExceptionWrapper
extends ElasticsearchException {
    private final String name;
    private final RestStatus status;

    public NotSerializableExceptionWrapper(Throwable other) {
        super(ElasticsearchException.getExceptionName(other) + ": " + other.getMessage(), other.getCause(), new Object[0]);
        this.name = ElasticsearchException.getExceptionName(other);
        this.status = ExceptionsHelper.status(other);
        this.setStackTrace(other.getStackTrace());
        for (Throwable otherSuppressed : other.getSuppressed()) {
            this.addSuppressed(otherSuppressed);
        }
        if (other instanceof ElasticsearchException) {
            ElasticsearchException ex = (ElasticsearchException)other;
            for (String key : ex.getHeaderKeys()) {
                this.addHeader(key, ex.getHeader(key));
            }
            for (String key : ex.getMetadataKeys()) {
                this.addMetadata(key, ex.getMetadata(key));
            }
        }
    }

    public NotSerializableExceptionWrapper(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
        super.writeTo(out, nestedExceptionsWriter);
        out.writeString(this.name);
        RestStatus.writeTo(out, this.status);
    }

    @Override
    public String getExceptionName() {
        return this.name;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }
}

