/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntPredicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.shingle.FixedShingleFilter;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.queries.spans.FieldMaskingSpanQuery;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanNearQuery;
import org.apache.lucene.queries.spans.SpanOrQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedBinaryIndexFieldData;
import org.elasticsearch.index.fielddata.StoredFieldSortedBinaryIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.BlockStoredFieldsReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.KeywordScriptFieldType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.StringStoredFieldFieldLoader;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.script.field.TextDocValuesField;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class TextFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "text";
    private static final String FAST_PHRASE_SUFFIX = "._index_phrase";
    private static final String FAST_PREFIX_SUFFIX = "._index_prefix";
    private static final FielddataFrequencyFilter DEFAULT_FILTER = new FielddataFrequencyFilter(0.0, 2.147483647E9, 0);
    public static final FieldMapper.TypeParser PARSER = TextFieldMapper.createTypeParserWithLegacySupport((n, c) -> new Builder((String)n, c.indexVersionCreated(), c.getIndexAnalyzers(), SourceFieldMapper.isSynthetic(c.getIndexSettings())));
    private final IndexVersion indexCreatedVersion;
    private final boolean index;
    private final boolean store;
    private final String indexOptions;
    private final boolean norms;
    private final String termVectors;
    private final SimilarityProvider similarity;
    private final NamedAnalyzer indexAnalyzer;
    private final IndexAnalyzers indexAnalyzers;
    private final int positionIncrementGap;
    private final PrefixConfig indexPrefixes;
    private final FielddataFrequencyFilter freqFilter;
    private final boolean fieldData;
    private final FieldType fieldType;
    private final SubFieldInfo prefixFieldInfo;
    private final SubFieldInfo phraseFieldInfo;
    private final boolean isSyntheticSourceEnabled;

    private static PrefixConfig parsePrefixConfig(String propName, MappingParserContext parserContext, Object propNode) {
        if (propNode == null) {
            return null;
        }
        Map indexPrefix = (Map)propNode;
        int minChars = XContentMapValues.nodeIntegerValue(indexPrefix.remove("min_chars"), 2);
        int maxChars = XContentMapValues.nodeIntegerValue(indexPrefix.remove("max_chars"), 5);
        MappingParser.checkNoRemainingFields(propName, indexPrefix);
        return new PrefixConfig(minChars, maxChars);
    }

    private static FielddataFrequencyFilter parseFrequencyFilter(String name, MappingParserContext parserContext, Object node) {
        Map frequencyFilter = (Map)node;
        double minFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("min"), 0.0);
        double maxFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("max"), 2.147483647E9);
        int minSegmentSize = XContentMapValues.nodeIntegerValue(frequencyFilter.remove("min_segment_size"), 0);
        MappingParser.checkNoRemainingFields(name, frequencyFilter);
        return new FielddataFrequencyFilter(minFrequency, maxFrequency, minSegmentSize);
    }

    private TextFieldMapper(String simpleName, FieldType fieldType, TextFieldType mappedFieldType, SubFieldInfo prefixFieldInfo, SubFieldInfo phraseFieldInfo, FieldMapper.BuilderParams builderParams, Builder builder) {
        super(simpleName, mappedFieldType, builderParams);
        assert (mappedFieldType.getTextSearchInfo().isTokenized());
        assert (!mappedFieldType.hasDocValues());
        if (fieldType.indexOptions() == IndexOptions.NONE && this.fieldType().fielddata()) {
            throw new IllegalArgumentException("Cannot enable fielddata on a [text] field that is not indexed: [" + this.fullPath() + "]");
        }
        this.fieldType = TextFieldMapper.freezeAndDeduplicateFieldType(fieldType);
        this.prefixFieldInfo = prefixFieldInfo;
        this.phraseFieldInfo = phraseFieldInfo;
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.indexAnalyzer = builder.analyzers.getIndexAnalyzer();
        this.indexAnalyzers = builder.analyzers.indexAnalyzers;
        this.positionIncrementGap = builder.analyzers.positionIncrementGap.getValue();
        this.index = builder.index.getValue();
        this.store = builder.store.getValue();
        this.similarity = builder.similarity.getValue();
        this.indexOptions = builder.indexOptions.getValue();
        this.norms = builder.norms.getValue();
        this.termVectors = builder.termVectors.getValue();
        this.indexPrefixes = builder.indexPrefixes.getValue();
        this.freqFilter = builder.freqFilter.getValue();
        this.fieldData = builder.fieldData.get();
        this.isSyntheticSourceEnabled = builder.isSyntheticSourceEnabled;
    }

    @Override
    public Map<String, NamedAnalyzer> indexAnalyzers() {
        HashMap<String, NamedAnalyzer> analyzersMap = new HashMap<String, NamedAnalyzer>();
        analyzersMap.put(this.fullPath(), this.indexAnalyzer);
        if (this.phraseFieldInfo != null) {
            analyzersMap.put(this.phraseFieldInfo.field, new NamedAnalyzer(this.indexAnalyzer.name() + "_phrase", AnalyzerScope.INDEX, this.phraseFieldInfo.analyzer));
        }
        if (this.prefixFieldInfo != null) {
            analyzersMap.put(this.prefixFieldInfo.field, new NamedAnalyzer(this.indexAnalyzer.name() + "_prefix", AnalyzerScope.INDEX, this.prefixFieldInfo.analyzer));
        }
        return analyzersMap;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexCreatedVersion, this.indexAnalyzers, this.isSyntheticSourceEnabled).init(this);
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        String value = context.parser().textOrNull();
        if (value == null) {
            return;
        }
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            Field field = new Field(this.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.fieldType);
            context.doc().add((IndexableField)field);
            if (this.fieldType.omitNorms()) {
                context.addToFieldNames(this.fieldType().name());
            }
            if (this.prefixFieldInfo != null) {
                context.doc().add((IndexableField)new Field(this.prefixFieldInfo.field, (CharSequence)value, (IndexableFieldType)this.prefixFieldInfo.fieldType));
            }
            if (this.phraseFieldInfo != null) {
                context.doc().add((IndexableField)new Field(this.phraseFieldInfo.field, (CharSequence)value, (IndexableFieldType)this.phraseFieldInfo.fieldType));
            }
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public TextFieldType fieldType() {
        return (TextFieldType)super.fieldType();
    }

    public static Query createPhraseQuery(TokenStream stream, String field, int slop, boolean enablePositionIncrements) throws IOException {
        MultiPhraseQuery.Builder mpqb = new MultiPhraseQuery.Builder();
        mpqb.setSlop(slop);
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
        int position = -1;
        ArrayList<Term> multiTerms = new ArrayList<Term>();
        stream.reset();
        while (stream.incrementToken()) {
            int positionIncrement = posIncrAtt.getPositionIncrement();
            if (positionIncrement > 0 && multiTerms.size() > 0) {
                if (enablePositionIncrements) {
                    mpqb.add(multiTerms.toArray(new Term[0]), position);
                } else {
                    mpqb.add(multiTerms.toArray(new Term[0]));
                }
                multiTerms.clear();
            }
            position += positionIncrement;
            multiTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        if (enablePositionIncrements) {
            mpqb.add(multiTerms.toArray(new Term[0]), position);
        } else {
            mpqb.add(multiTerms.toArray(new Term[0]));
        }
        return mpqb.build();
    }

    public static Query createPhrasePrefixQuery(TokenStream stream, String field, int slop, int maxExpansions, String prefixField, IntPredicate usePrefixField) throws IOException {
        MultiPhrasePrefixQuery builder = new MultiPhrasePrefixQuery(field);
        builder.setSlop(slop);
        builder.setMaxExpansions(maxExpansions);
        ArrayList<Term> currentTerms = new ArrayList<Term>();
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
        stream.reset();
        int position = -1;
        while (stream.incrementToken()) {
            if (posIncrAtt.getPositionIncrement() != 0) {
                if (!currentTerms.isEmpty()) {
                    builder.add(currentTerms.toArray(new Term[0]), position);
                }
                position += posIncrAtt.getPositionIncrement();
                currentTerms.clear();
            }
            currentTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        builder.add(currentTerms.toArray(new Term[0]), position);
        if (prefixField == null) {
            return builder;
        }
        int lastPos = builder.getTerms().length - 1;
        Term[][] terms = builder.getTerms();
        int[] positions = builder.getPositions();
        for (Term term2 : terms[lastPos]) {
            String value = term2.text();
            if (usePrefixField.test(value.length())) continue;
            return builder;
        }
        if (terms.length == 1) {
            SynonymQuery.Builder sb = new SynonymQuery.Builder(prefixField);
            Arrays.stream(terms[0]).map(term -> new Term(prefixField, term.bytes())).forEach(arg_0 -> ((SynonymQuery.Builder)sb).addTerm(arg_0));
            return sb.build();
        }
        SpanNearQuery.Builder spanQuery = new SpanNearQuery.Builder(field, true);
        spanQuery.setSlop(slop);
        int previousPos = -1;
        for (int i = 0; i < terms.length; ++i) {
            SpanTermQuery[] queries;
            Term[] posTerms = terms[i];
            int posInc = positions[i] - previousPos;
            previousPos = positions[i];
            if (posInc > 1) {
                spanQuery.addGap(posInc - 1);
            }
            if (i == lastPos) {
                if (posTerms.length == 1) {
                    FieldMaskingSpanQuery fieldMask = new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(prefixField, posTerms[0].bytes())), field);
                    spanQuery.addClause((SpanQuery)fieldMask);
                    continue;
                }
                queries = (SpanQuery[])Arrays.stream(posTerms).map(term -> new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(prefixField, term.bytes())), field)).toArray(SpanQuery[]::new);
                spanQuery.addClause((SpanQuery)new SpanOrQuery((SpanQuery[])queries));
                continue;
            }
            if (posTerms.length == 1) {
                spanQuery.addClause((SpanQuery)new SpanTermQuery(posTerms[0]));
                continue;
            }
            queries = (SpanTermQuery[])Arrays.stream(posTerms).map(SpanTermQuery::new).toArray(SpanTermQuery[]::new);
            spanQuery.addClause((SpanQuery)new SpanOrQuery((SpanQuery[])queries));
        }
        return spanQuery.build();
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        builder.field("type", this.contentType());
        Builder b = (Builder)this.getMergeBuilder();
        b.index.toXContent(builder, includeDefaults);
        b.store.toXContent(builder, includeDefaults);
        this.multiFields().toXContent(builder, params);
        this.copyTo().toXContent(builder);
        if (this.sourceKeepMode().isPresent()) {
            this.sourceKeepMode().get().toXContent(builder);
        }
        b.meta.toXContent(builder, includeDefaults);
        b.indexOptions.toXContent(builder, includeDefaults);
        b.termVectors.toXContent(builder, includeDefaults);
        b.norms.toXContent(builder, includeDefaults);
        b.analyzers.indexAnalyzer.toXContent(builder, includeDefaults);
        b.analyzers.searchAnalyzer.toXContent(builder, includeDefaults);
        b.analyzers.searchQuoteAnalyzer.toXContent(builder, includeDefaults);
        b.similarity.toXContent(builder, includeDefaults);
        b.eagerGlobalOrdinals.toXContent(builder, includeDefaults);
        b.analyzers.positionIncrementGap.toXContent(builder, includeDefaults);
        b.fieldData.toXContent(builder, includeDefaults);
        b.freqFilter.toXContent(builder, includeDefaults);
        b.indexPrefixes.toXContent(builder, includeDefaults);
        b.indexPhrases.toXContent(builder, includeDefaults);
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.store) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> new StringStoredFieldFieldLoader(this, this.fullPath(), this.leafName()){

                @Override
                protected void write(XContentBuilder b, Object value) throws IOException {
                    b.value((String)value);
                }
            });
        }
        KeywordFieldMapper kwd = SyntheticSourceHelper.getKeywordFieldMapperForSyntheticSource(this);
        if (kwd != null) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> kwd.syntheticFieldLoader(this.fullPath(), this.leafName()));
        }
        return super.syntheticSourceSupport();
    }

    public static class Defaults {
        public static final double FIELDDATA_MIN_FREQUENCY = 0.0;
        public static final double FIELDDATA_MAX_FREQUENCY = 2.147483647E9;
        public static final int FIELDDATA_MIN_SEGMENT_SIZE = 0;
        public static final int INDEX_PREFIX_MIN_CHARS = 2;
        public static final int INDEX_PREFIX_MAX_CHARS = 5;
        public static final FieldType FIELD_TYPE;
        public static final int POSITION_INCREMENT_GAP = 100;

        static {
            FieldType ft = new FieldType();
            ft.setTokenized(true);
            ft.setStored(false);
            ft.setStoreTermVectors(false);
            ft.setOmitNorms(false);
            ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE = Mapper.freezeAndDeduplicateFieldType(ft);
        }
    }

    private static final class PrefixConfig
    implements ToXContent {
        final int minChars;
        final int maxChars;

        private PrefixConfig(int minChars, int maxChars) {
            this.minChars = minChars;
            this.maxChars = maxChars;
            if (minChars > maxChars) {
                throw new IllegalArgumentException("min_chars [" + minChars + "] must be less than max_chars [" + maxChars + "]");
            }
            if (minChars < 1) {
                throw new IllegalArgumentException("min_chars [" + minChars + "] must be greater than zero");
            }
            if (maxChars >= 20) {
                throw new IllegalArgumentException("max_chars [" + maxChars + "] must be less than 20");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrefixConfig that = (PrefixConfig)o;
            return this.minChars == that.minChars && this.maxChars == that.maxChars;
        }

        public int hashCode() {
            return Objects.hash(this.minChars, this.maxChars);
        }

        public String toString() {
            return "{ min_chars=" + this.minChars + ", max_chars=" + this.maxChars + " }";
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("min_chars", this.minChars);
            builder.field("max_chars", this.maxChars);
            builder.endObject();
            return builder;
        }
    }

    private static final class FielddataFrequencyFilter
    implements ToXContent {
        final double minFreq;
        final double maxFreq;
        final int minSegmentSize;

        private FielddataFrequencyFilter(double minFreq, double maxFreq, int minSegmentSize) {
            this.minFreq = minFreq;
            this.maxFreq = maxFreq;
            this.minSegmentSize = minSegmentSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FielddataFrequencyFilter that = (FielddataFrequencyFilter)o;
            return Double.compare(that.minFreq, this.minFreq) == 0 && Double.compare(that.maxFreq, this.maxFreq) == 0 && this.minSegmentSize == that.minSegmentSize;
        }

        public int hashCode() {
            return Objects.hash(this.minFreq, this.maxFreq, this.minSegmentSize);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("min", this.minFreq);
            builder.field("max", this.maxFreq);
            builder.field("min_segment_size", this.minSegmentSize);
            builder.endObject();
            return builder;
        }

        public String toString() {
            return "{ min=" + this.minFreq + ", max=" + this.maxFreq + ", min_segment_size=" + this.minSegmentSize + " }";
        }
    }

    public static class TextFieldType
    extends StringFieldType {
        private boolean fielddata = false;
        private FielddataFrequencyFilter filter;
        private PrefixFieldType prefixFieldType;
        private final boolean indexPhrases;
        private final boolean eagerGlobalOrdinals;
        private final boolean isSyntheticSource;
        private final KeywordFieldMapper.KeywordFieldType syntheticSourceDelegate;

        public TextFieldType(String name, boolean indexed, boolean stored, TextSearchInfo tsi, boolean isSyntheticSource, KeywordFieldMapper.KeywordFieldType syntheticSourceDelegate, Map<String, String> meta, boolean eagerGlobalOrdinals, boolean indexPhrases) {
            super(name, indexed, stored, false, tsi, meta);
            this.isSyntheticSource = isSyntheticSource;
            this.syntheticSourceDelegate = syntheticSourceDelegate;
            this.eagerGlobalOrdinals = eagerGlobalOrdinals;
            this.indexPhrases = indexPhrases;
        }

        public TextFieldType(String name, boolean indexed, boolean stored, Map<String, String> meta) {
            super(name, indexed, stored, false, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), meta);
            this.isSyntheticSource = false;
            this.syntheticSourceDelegate = null;
            this.eagerGlobalOrdinals = false;
            this.indexPhrases = false;
        }

        public TextFieldType(String name, boolean isSyntheticSource) {
            this(name, true, false, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), isSyntheticSource, null, Collections.emptyMap(), false, false);
        }

        public boolean fielddata() {
            return this.fielddata;
        }

        @Override
        public boolean eagerGlobalOrdinals() {
            return this.eagerGlobalOrdinals;
        }

        public void setFielddata(boolean fielddata, FielddataFrequencyFilter filter) {
            this.fielddata = fielddata;
            this.filter = filter;
        }

        public void setFielddata(boolean fielddata) {
            this.setFielddata(fielddata, DEFAULT_FILTER);
        }

        double fielddataMinFrequency() {
            return this.filter.minFreq;
        }

        double fielddataMaxFrequency() {
            return this.filter.maxFreq;
        }

        int fielddataMinSegmentSize() {
            return this.filter.minSegmentSize;
        }

        void setIndexPrefixes(int minChars, int maxChars) {
            this.prefixFieldType = new PrefixFieldType(this, minChars, maxChars);
        }

        public PrefixFieldType getPrefixFieldType() {
            return this.prefixFieldType;
        }

        @Override
        public String typeName() {
            return TextFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString(this.name(), context, format);
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            if (this.prefixFieldType == null || !this.prefixFieldType.accept(value.length())) {
                return super.prefixQuery(value, method, caseInsensitive, context);
            }
            Query tq = this.prefixFieldType.prefixQuery(value, method, caseInsensitive, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE) {
                return new ConstantScoreQuery(tq);
            }
            return tq;
        }

        @Override
        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, SearchExecutionContext context) {
            this.failIfNotIndexed();
            if (this.prefixFieldType != null && value.length() >= this.prefixFieldType.minChars && value.length() <= this.prefixFieldType.maxChars && this.prefixFieldType.getTextSearchInfo().hasPositions()) {
                return new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(this.prefixFieldType.name(), this.indexedValueForSearch(value))), this.name());
            }
            SpanMultiTermQueryWrapper spanMulti = new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            if (method != null) {
                spanMulti.setRewriteMethod(method);
            }
            return spanMulti;
        }

        @Override
        public IntervalsSource termIntervals(BytesRef term, SearchExecutionContext context) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + this.name() + "] with no positions indexed");
            }
            return Intervals.term((BytesRef)term);
        }

        @Override
        public IntervalsSource prefixIntervals(BytesRef term, SearchExecutionContext context) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + this.name() + "] with no positions indexed");
            }
            if (this.prefixFieldType != null) {
                return this.prefixFieldType.intervals(term);
            }
            return Intervals.prefix((BytesRef)term, (int)IndexSearcher.getMaxClauseCount());
        }

        @Override
        public IntervalsSource fuzzyIntervals(String term, int maxDistance, int prefixLength, boolean transpositions, SearchExecutionContext context) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + this.name() + "] with no positions indexed");
            }
            FuzzyQuery fq = new FuzzyQuery(new Term(this.name(), term), maxDistance, prefixLength, IndexSearcher.getMaxClauseCount(), transpositions);
            return Intervals.multiterm((CompiledAutomaton)fq.getAutomata(), (int)IndexSearcher.getMaxClauseCount(), (String)term);
        }

        @Override
        public IntervalsSource wildcardIntervals(BytesRef pattern, SearchExecutionContext context) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + this.name() + "] with no positions indexed");
            }
            return Intervals.wildcard((BytesRef)pattern, (int)IndexSearcher.getMaxClauseCount());
        }

        @Override
        public IntervalsSource regexpIntervals(BytesRef pattern, SearchExecutionContext context) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + this.name() + "] with no positions indexed");
            }
            return Intervals.regexp((BytesRef)pattern, (int)IndexSearcher.getMaxClauseCount());
        }

        @Override
        public IntervalsSource rangeIntervals(BytesRef lowerTerm, BytesRef upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + this.name() + "] with no positions indexed");
            }
            return Intervals.range((BytesRef)lowerTerm, (BytesRef)upperTerm, (boolean)includeLower, (boolean)includeUpper, (int)IndexSearcher.getMaxClauseCount());
        }

        private void checkForPositions() {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalStateException("field:[" + this.name() + "] was indexed without position data; cannot run PhraseQuery");
            }
        }

        @Override
        public Query phraseQuery(TokenStream stream, int slop, boolean enablePosIncrements, SearchExecutionContext context) throws IOException {
            Object field = this.name();
            this.checkForPositions();
            if (this.indexPhrases && slop == 0 && !TextFieldType.hasGaps(stream) && !stream.hasAttribute(BytesTermAttribute.class)) {
                stream = new FixedShingleFilter(stream, 2);
                field = (String)field + TextFieldMapper.FAST_PHRASE_SUFFIX;
            }
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(slop);
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
            int position = -1;
            stream.reset();
            while (stream.incrementToken()) {
                if (termAtt.getBytesRef() == null) {
                    throw new IllegalStateException("Null term while building phrase query");
                }
                position = enablePosIncrements ? (position += posIncrAtt.getPositionIncrement()) : ++position;
                builder.add(new Term((String)field, termAtt.getBytesRef()), position);
            }
            return builder.build();
        }

        @Override
        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext context) throws IOException {
            Object field = this.name();
            if (this.indexPhrases && slop == 0 && !TextFieldType.hasGaps(stream)) {
                stream = new FixedShingleFilter(stream, 2);
                field = (String)field + TextFieldMapper.FAST_PHRASE_SUFFIX;
            }
            return TextFieldMapper.createPhraseQuery(stream, (String)field, slop, enablePositionIncrements);
        }

        private static int countTokens(TokenStream ts) throws IOException {
            ts.reset();
            int count = 0;
            while (ts.incrementToken()) {
                ++count;
            }
            ts.end();
            return count;
        }

        @Override
        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext context) throws IOException {
            if (TextFieldType.countTokens(stream) > 1) {
                this.checkForPositions();
            }
            return this.analyzePhrasePrefix(stream, slop, maxExpansions);
        }

        private Query analyzePhrasePrefix(TokenStream stream, int slop, int maxExpansions) throws IOException {
            String prefixField = this.prefixFieldType == null || slop > 0 ? null : this.prefixFieldType.name();
            IntPredicate usePrefix = len -> len >= this.prefixFieldType.minChars && len <= this.prefixFieldType.maxChars;
            return TextFieldMapper.createPhrasePrefixQuery(stream, this.name(), slop, maxExpansions, prefixField, usePrefix);
        }

        public static boolean hasGaps(TokenStream stream) throws IOException {
            assert (stream instanceof CachingTokenFilter);
            PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                if (posIncAtt.getPositionIncrement() <= 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isAggregatable() {
            return this.fielddata;
        }

        public boolean canUseSyntheticSourceDelegateForLoading() {
            return this.syntheticSourceDelegate != null && this.syntheticSourceDelegate.ignoreAbove() == Integer.MAX_VALUE && (this.syntheticSourceDelegate.isIndexed() || this.syntheticSourceDelegate.isStored());
        }

        public boolean canUseSyntheticSourceDelegateForQuerying() {
            return this.syntheticSourceDelegate != null && this.syntheticSourceDelegate.ignoreAbove() == Integer.MAX_VALUE && this.syntheticSourceDelegate.isIndexed();
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            KeywordFieldMapper.KeywordFieldType kwd;
            MappedFieldType parent;
            if (this.canUseSyntheticSourceDelegateForLoading()) {
                return new BlockLoader.Delegating(this.syntheticSourceDelegate.blockLoader(blContext)){

                    @Override
                    protected String delegatingTo() {
                        return syntheticSourceDelegate.name();
                    }
                };
            }
            String parentField = blContext.parentField(this.name());
            if (parentField != null && (parent = blContext.lookup().fieldType(parentField)).typeName().equals("keyword") && !(kwd = (KeywordFieldMapper.KeywordFieldType)parent).hasNormalizer() && (kwd.hasDocValues() || kwd.isStored())) {
                return new BlockLoader.Delegating(this, kwd.blockLoader(blContext)){

                    @Override
                    protected String delegatingTo() {
                        return kwd.name();
                    }
                };
            }
            if (this.isStored()) {
                return new BlockStoredFieldsReader.BytesFromStringsBlockLoader(this.name());
            }
            SourceValueFetcher fetcher = SourceValueFetcher.toString(blContext.sourcePaths(this.name()));
            return new BlockSourceReader.BytesRefsBlockLoader(fetcher, this.blockReaderDisiLookup(blContext));
        }

        private BlockSourceReader.LeafIteratorLookup blockReaderDisiLookup(MappedFieldType.BlockLoaderContext blContext) {
            if (this.isIndexed()) {
                if (this.getTextSearchInfo().hasNorms()) {
                    return BlockSourceReader.lookupFromNorms(this.name());
                }
            } else if (!this.isStored()) {
                return BlockSourceReader.lookupMatchingAll();
            }
            return BlockSourceReader.lookupFromFieldNames(blContext.fieldNames(), this.name());
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            MappedFieldType.FielddataOperation operation = fieldDataContext.fielddataOperation();
            if (operation == MappedFieldType.FielddataOperation.SEARCH) {
                if (!this.fielddata) {
                    throw new IllegalArgumentException("Fielddata is disabled on [" + this.name() + "] in [" + fieldDataContext.fullyQualifiedIndexName() + "]. Text fields are not optimised for operations that require per-document field data like aggregations and sorting, so these operations are disabled by default. Please use a keyword field instead. Alternatively, set fielddata=true on [" + this.name() + "] in order to load field data by uninverting the inverted index. Note that this can use significant memory.");
                }
                return new PagedBytesIndexFieldData.Builder(this.name(), this.filter.minFreq, this.filter.maxFreq, this.filter.minSegmentSize, CoreValuesSourceType.KEYWORD, (dv, n) -> new DelegateDocValuesField(new ScriptDocValues.Strings(new ScriptDocValues.StringsSupplier(FieldData.toString(dv))), n));
            }
            if (operation != MappedFieldType.FielddataOperation.SCRIPT) {
                throw new IllegalStateException("unknown field data operation [" + operation.name() + "]");
            }
            if (this.isSyntheticSource) {
                if (this.isStored()) {
                    return (cache, breaker) -> new StoredFieldSortedBinaryIndexFieldData(this, this.name(), CoreValuesSourceType.KEYWORD, TextDocValuesField::new){

                        @Override
                        protected BytesRef storedToBytesRef(Object stored) {
                            return new BytesRef((CharSequence)((String)stored));
                        }
                    };
                }
                if (this.syntheticSourceDelegate != null) {
                    return this.syntheticSourceDelegate.fielddataBuilder(fieldDataContext);
                }
                throw new IllegalArgumentException("fetching values from a text field [" + this.name() + "] is not supported because synthetic _source is enabled and we don't have a way to load the fields");
            }
            return new SourceValueFetcherSortedBinaryIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, (ValueFetcher)SourceValueFetcher.toString(fieldDataContext.sourcePathsLookup().apply(this.name())), (SourceProvider)fieldDataContext.lookupSupplier().get(), TextDocValuesField::new);
        }

        public boolean isSyntheticSource() {
            return this.isSyntheticSource;
        }

        public KeywordFieldMapper.KeywordFieldType syntheticSourceDelegate() {
            return this.syntheticSourceDelegate;
        }
    }

    private static final class SubFieldInfo {
        private final Analyzer analyzer;
        private final FieldType fieldType;
        private final String field;

        SubFieldInfo(String field, FieldType fieldType, Analyzer analyzer) {
            this.fieldType = Mapper.freezeAndDeduplicateFieldType(fieldType);
            this.analyzer = analyzer;
            this.field = field;
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final IndexVersion indexCreatedVersion;
        private final FieldMapper.Parameter<Boolean> store;
        private final boolean isSyntheticSourceEnabled;
        private final FieldMapper.Parameter<Boolean> index = FieldMapper.Parameter.indexParam(m -> ((TextFieldMapper)m).index, true);
        final FieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> ((TextFieldMapper)m).similarity);
        final FieldMapper.Parameter<String> indexOptions = TextParams.textIndexOptions(m -> ((TextFieldMapper)m).indexOptions);
        final FieldMapper.Parameter<Boolean> norms = TextParams.norms(true, m -> ((TextFieldMapper)m).norms);
        final FieldMapper.Parameter<String> termVectors = TextParams.termVectors(m -> ((TextFieldMapper)m).termVectors);
        final FieldMapper.Parameter<Boolean> fieldData = FieldMapper.Parameter.boolParam("fielddata", true, m -> ((TextFieldMapper)m).fieldData, false);
        final FieldMapper.Parameter<FielddataFrequencyFilter> freqFilter = new FieldMapper.Parameter<FielddataFrequencyFilter>("fielddata_frequency_filter", true, () -> DEFAULT_FILTER, TextFieldMapper::parseFrequencyFilter, m -> ((TextFieldMapper)m).freqFilter, XContentBuilder::field, Objects::toString);
        final FieldMapper.Parameter<Boolean> eagerGlobalOrdinals = FieldMapper.Parameter.boolParam("eager_global_ordinals", true, m -> ((TextFieldMapper)m).fieldType().eagerGlobalOrdinals, false);
        final FieldMapper.Parameter<Boolean> indexPhrases = FieldMapper.Parameter.boolParam("index_phrases", false, m -> ((TextFieldMapper)m).fieldType().indexPhrases, false);
        final FieldMapper.Parameter<PrefixConfig> indexPrefixes = new FieldMapper.Parameter<PrefixConfig>("index_prefixes", false, () -> null, TextFieldMapper::parsePrefixConfig, m -> ((TextFieldMapper)m).indexPrefixes, XContentBuilder::field, Objects::toString).acceptsNull();
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final TextParams.Analyzers analyzers;

        public Builder(String name, IndexAnalyzers indexAnalyzers, boolean isSyntheticSourceEnabled) {
            this(name, IndexVersion.current(), indexAnalyzers, isSyntheticSourceEnabled);
        }

        public Builder(String name, IndexVersion indexCreatedVersion, IndexAnalyzers indexAnalyzers, boolean isSyntheticSourceEnabled) {
            super(name);
            this.store = FieldMapper.Parameter.storeParam(m -> ((TextFieldMapper)m).store, () -> isSyntheticSourceEnabled && !this.multiFieldsBuilder.hasSyntheticSourceCompatibleKeywordField());
            this.indexCreatedVersion = indexCreatedVersion;
            this.analyzers = new TextParams.Analyzers(indexAnalyzers, m -> ((TextFieldMapper)m).indexAnalyzer, m -> ((TextFieldMapper)m).positionIncrementGap, indexCreatedVersion);
            this.isSyntheticSourceEnabled = isSyntheticSourceEnabled;
        }

        public Builder index(boolean index) {
            this.index.setValue(index);
            return this;
        }

        public Builder store(boolean store) {
            this.store.setValue(store);
            return this;
        }

        public Builder fielddata(boolean fielddata) {
            this.fieldData.setValue(fielddata);
            return this;
        }

        public Builder fielddataFrequencyFilter(double min, double max, int segs) {
            this.freqFilter.setValue(new FielddataFrequencyFilter(min, max, segs));
            return this;
        }

        @Override
        public Builder addMultiField(FieldMapper.Builder builder) {
            this.multiFieldsBuilder.add(builder);
            return this;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.index, this.store, this.indexOptions, this.norms, this.termVectors, this.analyzers.indexAnalyzer, this.analyzers.searchAnalyzer, this.analyzers.searchQuoteAnalyzer, this.similarity, this.analyzers.positionIncrementGap, this.fieldData, this.freqFilter, this.eagerGlobalOrdinals, this.indexPhrases, this.indexPrefixes, this.meta};
        }

        private TextFieldType buildFieldType(FieldType fieldType, FieldMapper.MultiFields multiFields, MapperBuilderContext context, IndexVersion indexCreatedVersion) {
            TextFieldType ft;
            NamedAnalyzer searchAnalyzer = this.analyzers.getSearchAnalyzer();
            NamedAnalyzer searchQuoteAnalyzer = this.analyzers.getSearchQuoteAnalyzer();
            if (this.analyzers.positionIncrementGap.isConfigured() && fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.leafName() + "] without positions enabled");
            }
            TextSearchInfo tsi = new TextSearchInfo(fieldType, this.similarity.getValue(), searchAnalyzer, searchQuoteAnalyzer);
            if (indexCreatedVersion.isLegacyIndexVersion()) {
                ft = new LegacyTextFieldType(context.buildFullName(this.leafName()), this.index.getValue(), this.store.getValue(), tsi, this.meta.getValue());
            } else {
                ft = new TextFieldType(context.buildFullName(this.leafName()), this.index.getValue(), this.store.getValue(), tsi, context.isSourceSynthetic(), SyntheticSourceHelper.syntheticSourceDelegate(fieldType, multiFields), this.meta.getValue(), this.eagerGlobalOrdinals.getValue(), this.indexPhrases.getValue());
                if (this.fieldData.getValue().booleanValue()) {
                    ft.setFielddata(true, this.freqFilter.getValue());
                }
            }
            return ft;
        }

        private SubFieldInfo buildPrefixInfo(MapperBuilderContext context, FieldType fieldType, TextFieldType tft) {
            if (this.indexPrefixes.get() == null) {
                return null;
            }
            if (!this.index.getValue().booleanValue()) {
                throw new IllegalArgumentException("Cannot set index_prefixes on unindexed field [" + this.leafName() + "]");
            }
            String fullName = this.indexCreatedVersion.before(IndexVersions.V_7_2_1) ? this.leafName() : context.buildFullName(this.leafName());
            FieldType pft = new FieldType((IndexableFieldType)fieldType);
            pft.setOmitNorms(true);
            if (fieldType.indexOptions() == IndexOptions.DOCS_AND_FREQS) {
                pft.setIndexOptions(IndexOptions.DOCS);
            } else {
                pft.setIndexOptions(fieldType.indexOptions());
            }
            if (fieldType.storeTermVectorOffsets()) {
                pft.setStoreTermVectorOffsets(true);
            }
            tft.setIndexPrefixes(this.indexPrefixes.get().minChars, this.indexPrefixes.get().maxChars);
            return new SubFieldInfo(fullName + TextFieldMapper.FAST_PREFIX_SUFFIX, pft, (Analyzer)new PrefixWrappedAnalyzer(this.analyzers.getIndexAnalyzer().analyzer(), this.analyzers.positionIncrementGap.get(), this.indexPrefixes.get().minChars, this.indexPrefixes.get().maxChars));
        }

        private SubFieldInfo buildPhraseInfo(FieldType fieldType, TextFieldType parent) {
            if (!this.indexPhrases.get().booleanValue()) {
                return null;
            }
            if (!this.index.get().booleanValue()) {
                throw new IllegalArgumentException("Cannot set index_phrases on unindexed field [" + this.leafName() + "]");
            }
            if (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                throw new IllegalArgumentException("Cannot set index_phrases on field [" + this.leafName() + "] if positions are not enabled");
            }
            FieldType phraseFieldType = new FieldType((IndexableFieldType)fieldType);
            PhraseWrappedAnalyzer a = new PhraseWrappedAnalyzer(this.analyzers.getIndexAnalyzer().analyzer(), this.analyzers.positionIncrementGap.get());
            return new SubFieldInfo(parent.name() + TextFieldMapper.FAST_PHRASE_SUFFIX, phraseFieldType, (Analyzer)a);
        }

        @Override
        public TextFieldMapper build(MapperBuilderContext context) {
            FieldType fieldType = TextParams.buildFieldType(this.index, this.store, this.indexOptions, this.indexCreatedVersion.isLegacyIndexVersion() ? () -> false : this.norms, this.termVectors);
            FieldMapper.BuilderParams builderParams = this.builderParams(this, context);
            TextFieldType tft = this.buildFieldType(fieldType, builderParams.multiFields(), context, this.indexCreatedVersion);
            SubFieldInfo phraseFieldInfo = this.buildPhraseInfo(fieldType, tft);
            SubFieldInfo prefixFieldInfo = this.buildPrefixInfo(context, fieldType, tft);
            for (Mapper mapper : builderParams.multiFields()) {
                if (!mapper.fullPath().endsWith(TextFieldMapper.FAST_PHRASE_SUFFIX) && !mapper.fullPath().endsWith(TextFieldMapper.FAST_PREFIX_SUFFIX)) continue;
                throw new MapperParsingException("Cannot use reserved field name [" + mapper.fullPath() + "]");
            }
            return new TextFieldMapper(this.leafName(), fieldType, tft, prefixFieldInfo, phraseFieldInfo, builderParams, this);
        }
    }

    public static class SyntheticSourceHelper {
        public static KeywordFieldMapper.KeywordFieldType syntheticSourceDelegate(FieldType fieldType, FieldMapper.MultiFields multiFields) {
            if (fieldType.stored()) {
                return null;
            }
            KeywordFieldMapper kwd = SyntheticSourceHelper.getKeywordFieldMapperForSyntheticSource(multiFields);
            if (kwd != null) {
                return kwd.fieldType();
            }
            return null;
        }

        public static KeywordFieldMapper getKeywordFieldMapperForSyntheticSource(Iterable<? extends Mapper> multiFields) {
            for (Mapper mapper : multiFields) {
                KeywordFieldMapper kwd;
                if (!mapper.typeName().equals("keyword") || (kwd = (KeywordFieldMapper)mapper).hasNormalizer() || !kwd.fieldType().hasDocValues() && !kwd.fieldType().isStored()) continue;
                return kwd;
            }
            return null;
        }
    }

    static class LegacyTextFieldType
    extends ConstantScoreTextFieldType {
        private final MappedFieldType existQueryFieldType = KeywordScriptFieldType.sourceOnly(this.name()).asMappedFieldTypes().findFirst().get();

        LegacyTextFieldType(String name, boolean indexed, boolean stored, TextSearchInfo tsi, Map<String, String> meta) {
            super(name, indexed, stored, tsi, meta);
        }

        @Override
        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, SearchExecutionContext context) {
            throw new IllegalArgumentException("Cannot use span prefix queries on text field " + this.name() + " of a legacy index");
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            if (!context.allowExpensiveQueries()) {
                throw new ElasticsearchException("runtime-computed exists query cannot be executed while [" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "] is set to [false].", new Object[0]);
            }
            return this.existQueryFieldType.existsQuery(context);
        }
    }

    public static class ConstantScoreTextFieldType
    extends TextFieldType {
        public ConstantScoreTextFieldType(String name, boolean indexed, boolean stored, TextSearchInfo tsi, Map<String, String> meta) {
            super(name, indexed, stored, tsi, false, null, meta, false, false);
        }

        public ConstantScoreTextFieldType(String name) {
            this(name, true, false, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), Collections.emptyMap());
        }

        public ConstantScoreTextFieldType(String name, boolean indexed, boolean stored, Map<String, String> meta) {
            this(name, indexed, stored, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), meta);
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            return new ConstantScoreQuery(super.termQuery(value, context));
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
            return new ConstantScoreQuery(super.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, context, rewriteMethod));
        }

        @Override
        public Query phraseQuery(TokenStream stream, int slop, boolean enablePosIncrements, SearchExecutionContext queryShardContext) throws IOException {
            return new ConstantScoreQuery(super.phraseQuery(stream, slop, enablePosIncrements, queryShardContext));
        }

        @Override
        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext queryShardContext) throws IOException {
            return new ConstantScoreQuery(super.multiPhraseQuery(stream, slop, enablePositionIncrements, queryShardContext));
        }

        @Override
        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext queryShardContext) throws IOException {
            return new ConstantScoreQuery(super.phrasePrefixQuery(stream, slop, maxExpansions, queryShardContext));
        }
    }

    private static final class PrefixFieldType
    extends StringFieldType {
        final int minChars;
        final int maxChars;
        final TextFieldType parentField;

        PrefixFieldType(TextFieldType parentField, int minChars, int maxChars) {
            super(parentField.name() + TextFieldMapper.FAST_PREFIX_SUFFIX, true, false, false, parentField.getTextSearchInfo(), Collections.emptyMap());
            this.minChars = minChars;
            this.maxChars = maxChars;
            this.parentField = parentField;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean mayExistInIndex(SearchExecutionContext context) {
            return false;
        }

        boolean accept(int length) {
            return length >= this.minChars - 1 && length <= this.maxChars;
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            if (value.length() >= this.minChars) {
                if (caseInsensitive) {
                    return super.termQueryCaseInsensitive(value, context);
                }
                return super.termQuery(value, context);
            }
            ArrayList<Automaton> automata = new ArrayList<Automaton>();
            if (caseInsensitive) {
                automata.add(AutomatonQueries.toCaseInsensitiveString(value));
            } else {
                automata.add(Automata.makeString((String)value));
            }
            for (int i = value.length(); i < this.minChars; ++i) {
                automata.add(Automata.makeAnyChar());
            }
            Automaton automaton = Operations.concatenate(automata);
            AutomatonQuery query = method == null ? new AutomatonQuery(new Term(this.name(), value + "*"), automaton, false) : new AutomatonQuery(new Term(this.name(), value + "*"), automaton, false, method);
            return new BooleanQuery.Builder().add((Query)query, BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term(this.parentField.name(), value)), BooleanClause.Occur.SHOULD).build();
        }

        public IntervalsSource intervals(BytesRef term) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over a field [" + this.name() + "] without indexed positions");
            }
            if (term.length > this.maxChars) {
                return Intervals.prefix((BytesRef)term);
            }
            if (term.length >= this.minChars) {
                return Intervals.fixField((String)this.name(), (IntervalsSource)Intervals.term((BytesRef)term));
            }
            String wildcardTerm = term.utf8ToString() + "?".repeat(Math.max(0, this.minChars - term.length));
            return Intervals.or((IntervalsSource[])new IntervalsSource[]{Intervals.fixField((String)this.name(), (IntervalsSource)Intervals.wildcard((BytesRef)new BytesRef((CharSequence)wildcardTerm), (int)IndexSearcher.getMaxClauseCount())), Intervals.term((BytesRef)term)});
        }

        @Override
        public String typeName() {
            return "prefix";
        }

        public String toString() {
            return super.toString() + ",prefixChars=" + this.minChars + ":" + this.maxChars;
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            throw new UnsupportedOperationException();
        }
    }

    private static class PrefixWrappedAnalyzer
    extends AnalyzerWrapper {
        private final int minChars;
        private final int maxChars;
        private final int posIncGap;
        private final Analyzer delegate;

        PrefixWrappedAnalyzer(Analyzer delegate, int posIncGap, int minChars, int maxChars) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
            this.posIncGap = posIncGap;
            this.minChars = minChars;
            this.maxChars = maxChars;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        public int getPositionIncrementGap(String fieldName) {
            return this.posIncGap;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            EdgeNGramTokenFilter filter = new EdgeNGramTokenFilter(components.getTokenStream(), this.minChars, this.maxChars, false);
            return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)filter);
        }
    }

    private static class PhraseWrappedAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer delegate;
        private final int posIncGap;

        PhraseWrappedAnalyzer(Analyzer delegate, int posIncGap) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
            this.posIncGap = posIncGap;
        }

        public int getPositionIncrementGap(String fieldName) {
            return this.posIncGap;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)new FixedShingleFilter(components.getTokenStream(), 2));
        }
    }
}

