/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;

public class MetadataUpgrader {
    public final UnaryOperator<Map<String, IndexTemplateMetadata>> indexTemplateMetadataUpgraders = templates -> {
        Map upgradedTemplates = new HashMap(templates);
        for (UnaryOperator upgrader : indexTemplateMetadataUpgraders) {
            upgradedTemplates = (Map)upgrader.apply(upgradedTemplates);
        }
        return upgradedTemplates;
    };
    public final Map<String, UnaryOperator<Metadata.Custom>> customMetadataUpgraders;

    public MetadataUpgrader(Collection<UnaryOperator<Map<String, IndexTemplateMetadata>>> indexTemplateMetadataUpgraders, Collection<Map<String, UnaryOperator<Metadata.Custom>>> customMetadataUpgraders) {
        this.customMetadataUpgraders = customMetadataUpgraders.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.collectingAndThen(Collectors.mapping(Map.Entry::getValue, Collectors.toList()), CombiningCustomUpgrader::new)));
    }

    private record CombiningCustomUpgrader(List<UnaryOperator<Metadata.Custom>> upgraders) implements UnaryOperator<Metadata.Custom>
    {
        @Override
        public Metadata.Custom apply(Metadata.Custom custom) {
            Metadata.Custom upgraded = custom;
            for (UnaryOperator<Metadata.Custom> upgrader : this.upgraders) {
                upgraded = (Metadata.Custom)upgrader.apply(upgraded);
            }
            return upgraded;
        }
    }
}

