/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;

@ServerlessScope(value=Scope.INTERNAL)
public class RestFielddataAction
extends AbstractCatAction {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_cat/fielddata"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/fielddata/{fields}"));
    }

    @Override
    public String getName() {
        return "cat_fielddata_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        String[] stringArray;
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest("data:true");
        nodesStatsRequest.setIncludeShardsStats(false);
        nodesStatsRequest.clear();
        nodesStatsRequest.indices(true);
        String[] fields = request.paramAsStringArray("fields", null);
        CommonStatsFlags commonStatsFlags = nodesStatsRequest.indices();
        if (fields == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = fields;
        }
        commonStatsFlags.fieldDataFields(stringArray);
        return channel -> client.admin().cluster().nodesStats(nodesStatsRequest, (ActionListener<NodesStatsResponse>)new RestResponseListener<NodesStatsResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesStatsResponse nodeStatses) throws Exception {
                return RestTable.buildResponse(RestFielddataAction.this.buildTable(request, nodeStatses), this.channel);
            }
        });
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/fielddata\n");
        sb.append("/_cat/fielddata/{fields}\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders().addCell("id", "desc:node id").addCell("host", "alias:h;desc:host name").addCell("ip", "desc:ip address").addCell("node", "alias:n;desc:node name").addCell("field", "alias:f;desc:field name").addCell("size", "text-align:right;alias:s;desc:field data usage").endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, NodesStatsResponse nodeStatses) {
        Table table = this.getTableWithHeader(request);
        for (NodeStats nodeStats : nodeStatses.getNodes()) {
            if (nodeStats.getIndices().getFieldData().getFields() == null) continue;
            for (Map.Entry<String, Long> field : nodeStats.getIndices().getFieldData().getFields()) {
                table.startRow();
                table.addCell(nodeStats.getNode().getId());
                table.addCell(nodeStats.getNode().getHostName());
                table.addCell(nodeStats.getNode().getHostAddress());
                table.addCell(nodeStats.getNode().getName());
                table.addCell(field.getKey());
                table.addCell(ByteSizeValue.ofBytes(field.getValue()));
                table.endRow();
            }
        }
        return table;
    }
}

