/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.histogram.AbstractHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.DoubleBounds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class RangeHistogramAggregator
extends AbstractHistogramAggregator {
    private final ValuesSource.Range valuesSource;

    public RangeHistogramAggregator(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, DoubleBounds extendedBounds, DoubleBounds hardBounds, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, interval, offset, order, keyed, minDocCount, extendedBounds, hardBounds, valuesSourceConfig.format(), context, parent, cardinality, metadata);
        ValuesSource.Range range = this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Range)valuesSourceConfig.getValuesSource() : null;
        if (!this.valuesSource.rangeType().isNumeric()) {
            throw new IllegalArgumentException("Expected numeric range type but found non-numeric range [" + this.valuesSource.rangeType().name + "]");
        }
    }

    @Override
    protected LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BinaryDocValues values = FieldData.unwrapSingleton(this.valuesSource.bytesValues(aggCtx.getLeafReaderContext()));
        assert (values != null) : "unexpected multi-value binary doc values";
        final RangeType rangeType = this.valuesSource.rangeType();
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    double previousKey = Double.NEGATIVE_INFINITY;
                    List<RangeFieldMapper.Range> ranges = rangeType.decodeRanges(values.binaryValue());
                    double previousFrom = Double.NEGATIVE_INFINITY;
                    for (RangeFieldMapper.Range range : ranges) {
                        Double from = rangeType.doubleValue(range.getFrom());
                        assert (from >= previousFrom) : "Start of range not >= previous start";
                        Double to = rangeType.doubleValue(range.getTo());
                        double effectiveFrom = RangeHistogramAggregator.this.hardBounds != null && RangeHistogramAggregator.this.hardBounds.getMin() != null ? Double.max(from, RangeHistogramAggregator.this.hardBounds.getMin()) : from;
                        double effectiveTo = RangeHistogramAggregator.this.hardBounds != null && RangeHistogramAggregator.this.hardBounds.getMax() != null ? Double.min(to, RangeHistogramAggregator.this.hardBounds.getMax()) : to;
                        double startKey = Math.floor((effectiveFrom - RangeHistogramAggregator.this.offset) / RangeHistogramAggregator.this.interval);
                        double endKey = Math.floor((effectiveTo - RangeHistogramAggregator.this.offset) / RangeHistogramAggregator.this.interval);
                        for (double key = Math.max(startKey, previousKey); key <= endKey; key += 1.0) {
                            if (key == previousKey) continue;
                            long bucketOrd = RangeHistogramAggregator.this.bucketOrds.add(owningBucketOrd, Double.doubleToLongBits(key));
                            if (bucketOrd < 0L) {
                                bucketOrd = -1L - bucketOrd;
                                RangeHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                                continue;
                            }
                            RangeHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                        }
                        if (!(endKey > previousKey)) continue;
                        previousKey = endKey;
                    }
                }
            }
        };
    }
}

