/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;

class SyntheticSourceProvider
implements SourceProvider {
    private final SourceLoader sourceLoader;
    private final Map<Object, SyntheticSourceLeafLoader> leaves = ConcurrentCollections.newConcurrentMap();

    SyntheticSourceProvider(SourceLoader sourceLoader) {
        this.sourceLoader = sourceLoader;
    }

    @Override
    public Source getSource(LeafReaderContext ctx, int doc) throws IOException {
        Object id = ctx.id();
        SyntheticSourceLeafLoader provider = this.leaves.get(id);
        if (provider == null) {
            provider = new SyntheticSourceLeafLoader(this, ctx);
            SyntheticSourceLeafLoader existing = this.leaves.put(id, provider);
            assert (existing == null) : "unexpected source provider [" + String.valueOf(existing) + "]";
        }
        return provider.getSource(doc);
    }

    private class SyntheticSourceLeafLoader {
        private final LeafStoredFieldLoader leafLoader;
        private final SourceLoader.Leaf leaf;

        SyntheticSourceLeafLoader(SyntheticSourceProvider syntheticSourceProvider, LeafReaderContext ctx) throws IOException {
            this.leafLoader = syntheticSourceProvider.sourceLoader.requiredStoredFields().isEmpty() ? StoredFieldLoader.empty().getLoader(ctx, null) : StoredFieldLoader.create(false, syntheticSourceProvider.sourceLoader.requiredStoredFields()).getLoader(ctx, null);
            this.leaf = syntheticSourceProvider.sourceLoader.leaf(ctx.reader(), null);
        }

        Source getSource(int doc) throws IOException {
            this.leafLoader.advanceTo(doc);
            return this.leaf.source(this.leafLoader, doc);
        }
    }
}

