/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.suggest.Suggest;

public class PhraseSuggestion
extends Suggest.Suggestion<Entry> {
    public PhraseSuggestion(String name, int size) {
        super(name, size);
    }

    public PhraseSuggestion(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return "phrase";
    }

    @Override
    protected Entry newEntry(StreamInput in) throws IOException {
        return new Entry(in);
    }

    public static class Entry
    extends Suggest.Suggestion.Entry<Option> {
        protected double cutoffScore = Double.MIN_VALUE;

        public Entry(Text text, int offset, int length, double cutoffScore) {
            super(text, offset, length);
            this.cutoffScore = cutoffScore;
        }

        public Entry(Text text, int offset, int length) {
            super(text, offset, length);
        }

        public Entry() {
        }

        public Entry(StreamInput in) throws IOException {
            super(in);
            this.cutoffScore = in.readDouble();
        }

        @Override
        protected void merge(Suggest.Suggestion.Entry<Option> other) {
            super.merge(other);
            if (!(other instanceof Entry)) {
                return;
            }
            Entry otherSuggestionEntry = (Entry)other;
            this.cutoffScore = Math.max(this.cutoffScore, otherSuggestionEntry.cutoffScore);
        }

        @Override
        public void addOption(Option option) {
            if ((double)option.getScore() > this.cutoffScore) {
                this.options.add(option);
            }
        }

        @Override
        protected Option newOption(StreamInput in) throws IOException {
            return new Option(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeDouble(this.cutoffScore);
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && Objects.equals(this.cutoffScore, ((Entry)other).cutoffScore);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.cutoffScore);
        }

        public static class Option
        extends Suggest.Suggestion.Entry.Option {
            public Option(Text text, Text highlighted, float score, Boolean collateMatch) {
                super(text, highlighted, score, collateMatch);
            }

            public Option(Text text, Text highlighted, float score) {
                super(text, highlighted, score);
            }

            public Option(StreamInput in) throws IOException {
                super(in);
            }
        }
    }
}

