/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.FlushTrainedModelCacheAction;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelCacheMetadataService;

public class TransportFlushTrainedModelCacheAction
extends AcknowledgedTransportMasterNodeAction<FlushTrainedModelCacheAction.Request> {
    private final TrainedModelCacheMetadataService modelCacheMetadataService;

    @Inject
    public TransportFlushTrainedModelCacheAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, TrainedModelCacheMetadataService modelCacheMetadataService) {
        super("cluster:admin/xpack/ml/inference/clear_model_cache", transportService, clusterService, threadPool, actionFilters, FlushTrainedModelCacheAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelCacheMetadataService = modelCacheMetadataService;
    }

    protected void masterOperation(Task task, FlushTrainedModelCacheAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.modelCacheMetadataService.updateCacheVersion(listener);
    }

    protected ClusterBlockException checkBlock(FlushTrainedModelCacheAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

