/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.persistence;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.action.FlushTrainedModelCacheAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelCacheMetadata;

public class TrainedModelCacheMetadataService
implements ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(TrainedModelCacheMetadataService.class);
    static final String TASK_QUEUE_NAME = "trained-models-cache-metadata-management";
    private final MasterServiceTaskQueue<CacheMetadataUpdateTask> metadataUpdateTaskQueue;
    private final Client client;
    private volatile boolean isMasterNode = false;

    public TrainedModelCacheMetadataService(ClusterService clusterService, Client client) {
        this.client = new OriginSettingClient(client, "ml");
        CacheMetadataUpdateTaskExecutor metadataUpdateTaskExecutor = new CacheMetadataUpdateTaskExecutor();
        this.metadataUpdateTaskQueue = clusterService.createTaskQueue(TASK_QUEUE_NAME, Priority.IMMEDIATE, (ClusterStateTaskExecutor)metadataUpdateTaskExecutor);
        clusterService.addListener((ClusterStateListener)this);
    }

    public void updateCacheVersion(ActionListener<AcknowledgedResponse> listener) {
        if (!this.isMasterNode) {
            this.client.execute((ActionType)FlushTrainedModelCacheAction.INSTANCE, (ActionRequest)new FlushTrainedModelCacheAction.Request(), listener);
            return;
        }
        RefreshCacheMetadataVersionTask updateMetadataTask = new RefreshCacheMetadataVersionTask(listener);
        this.metadataUpdateTaskQueue.submitTask(((CacheMetadataUpdateTask)updateMetadataTask).getDescription(), (ClusterStateTaskListener)updateMetadataTask, null);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.state().clusterRecovered() || event.state().nodes().getMasterNode() == null) {
            return;
        }
        this.isMasterNode = event.localNodeMaster();
    }

    static class CacheMetadataUpdateTaskExecutor
    implements ClusterStateTaskExecutor<CacheMetadataUpdateTask> {
        CacheMetadataUpdateTaskExecutor() {
        }

        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<CacheMetadataUpdateTask> batchExecutionContext) {
            TrainedModelCacheMetadata originalCacheMetadata;
            ClusterState initialState = batchExecutionContext.initialState();
            XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)initialState);
            TrainedModelCacheMetadata currentCacheMetadata = originalCacheMetadata = TrainedModelCacheMetadata.fromState((ClusterState)initialState);
            for (ClusterStateTaskExecutor.TaskContext taskContext : batchExecutionContext.taskContexts()) {
                Releasable ignored = taskContext.captureResponseHeaders();
                try {
                    currentCacheMetadata = ((CacheMetadataUpdateTask)taskContext.getTask()).execute(currentCacheMetadata, (ClusterStateTaskExecutor.TaskContext<CacheMetadataUpdateTask>)taskContext);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            if (currentCacheMetadata == originalCacheMetadata) {
                return initialState;
            }
            return ClusterState.builder((ClusterState)initialState).metadata(Metadata.builder((Metadata)initialState.metadata()).putCustom("trained_model_cache_metadata", (Metadata.Custom)currentCacheMetadata)).build();
        }
    }

    static class RefreshCacheMetadataVersionTask
    extends CacheMetadataUpdateTask {
        RefreshCacheMetadataVersionTask(ActionListener<AcknowledgedResponse> listener) {
            super(listener);
        }

        @Override
        protected TrainedModelCacheMetadata execute(TrainedModelCacheMetadata currentCacheMetadata, ClusterStateTaskExecutor.TaskContext<CacheMetadataUpdateTask> taskContext) {
            long newVersion = currentCacheMetadata.version() < Long.MAX_VALUE ? currentCacheMetadata.version() + 1L : 1L;
            taskContext.success(() -> this.listener.onResponse((Object)AcknowledgedResponse.TRUE));
            return new TrainedModelCacheMetadata(newVersion);
        }

        @Override
        protected String getDescription() {
            return "refresh trained model cache version";
        }
    }

    static abstract class CacheMetadataUpdateTask
    implements ClusterStateTaskListener {
        protected final ActionListener<AcknowledgedResponse> listener;

        CacheMetadataUpdateTask(ActionListener<AcknowledgedResponse> listener) {
            this.listener = listener;
        }

        protected abstract TrainedModelCacheMetadata execute(TrainedModelCacheMetadata var1, ClusterStateTaskExecutor.TaskContext<CacheMetadataUpdateTask> var2);

        protected abstract String getDescription();

        public void onFailure(@Nullable Exception e) {
            LOGGER.error("unexpected failure during [" + this.getDescription() + "]", (Throwable)e);
            this.listener.onFailure(e);
        }
    }
}

