/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.ForecastJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

@ServerlessScope(value=Scope.INTERNAL)
public class RestForecastJobAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + String.valueOf(Job.ID) + "}/_forecast"));
    }

    public String getName() {
        return "ml_forecast_job_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        ForecastJobAction.Request request;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            request = ForecastJobAction.Request.parseRequest((String)jobId, (XContentParser)parser);
        } else {
            request = new ForecastJobAction.Request(restRequest.param(Job.ID.getPreferredName()));
            if (restRequest.hasParam(ForecastJobAction.Request.DURATION.getPreferredName())) {
                request.setDuration(restRequest.param(ForecastJobAction.Request.DURATION.getPreferredName()));
            }
            if (restRequest.hasParam(ForecastJobAction.Request.EXPIRES_IN.getPreferredName())) {
                request.setExpiresIn(restRequest.param(ForecastJobAction.Request.EXPIRES_IN.getPreferredName()));
            }
            if (restRequest.hasParam(ForecastJobAction.Request.MAX_MODEL_MEMORY.getPreferredName())) {
                long limit = ByteSizeValue.parseBytesSizeValue((String)restRequest.param(ForecastJobAction.Request.MAX_MODEL_MEMORY.getPreferredName()), (String)ForecastJobAction.Request.MAX_MODEL_MEMORY.getPreferredName()).getBytes();
                request.setMaxModelMemory(limit);
            }
        }
        return channel -> client.execute((ActionType)ForecastJobAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

