/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.cohere;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.cohere.CohereModel;

public record CohereAccount(URI uri, SecureString apiKey) {
    public CohereAccount {
        Objects.requireNonNull(uri);
        Objects.requireNonNull(apiKey);
    }

    public static CohereAccount of(CohereModel model, CheckedSupplier<URI, URISyntaxException> uriBuilder) {
        URI uri = RequestUtils.buildUri(model.uri(), "Cohere", uriBuilder);
        return new CohereAccount(uri, model.apiKey());
    }
}

