/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.amazonbedrock.embeddings;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockBaseClient;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.AmazonBedrockJsonBuilder;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.AmazonBedrockRequest;
import org.elasticsearch.xpack.inference.external.response.amazonbedrock.embeddings.AmazonBedrockEmbeddingsResponseListener;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockProvider;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsModel;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public class AmazonBedrockEmbeddingsRequest
extends AmazonBedrockRequest {
    private final AmazonBedrockEmbeddingsModel embeddingsModel;
    private final ToXContent requestEntity;
    private final Truncator truncator;
    private final Truncator.TruncationResult truncationResult;
    private final AmazonBedrockProvider provider;
    private ActionListener<InvokeModelResponse> listener = null;

    public AmazonBedrockEmbeddingsRequest(Truncator truncator, Truncator.TruncationResult input, AmazonBedrockEmbeddingsModel model, ToXContent requestEntity, @Nullable TimeValue timeout) {
        super(model, timeout);
        this.truncator = Objects.requireNonNull(truncator);
        this.truncationResult = Objects.requireNonNull(input);
        this.requestEntity = Objects.requireNonNull(requestEntity);
        this.embeddingsModel = model;
        this.provider = model.provider();
    }

    public AmazonBedrockProvider provider() {
        return this.provider;
    }

    @Override
    protected void executeRequest(AmazonBedrockBaseClient client) {
        try {
            AmazonBedrockJsonBuilder jsonBuilder = new AmazonBedrockJsonBuilder(this.requestEntity);
            String bodyAsString = jsonBuilder.getStringContent();
            InvokeModelRequest invokeModelRequest = (InvokeModelRequest)InvokeModelRequest.builder().modelId(this.embeddingsModel.model()).body(SdkBytes.fromString((String)bodyAsString, (Charset)StandardCharsets.UTF_8)).build();
            SocketAccess.doPrivileged(() -> client.invokeModel(invokeModelRequest, this.listener));
        }
        catch (IOException e) {
            this.listener.onFailure((Exception)new RuntimeException(e));
        }
    }

    @Override
    public Request truncate() {
        Truncator.TruncationResult truncatedInput = this.truncator.truncate(this.truncationResult.input());
        return new AmazonBedrockEmbeddingsRequest(this.truncator, truncatedInput, this.embeddingsModel, this.requestEntity, this.timeout);
    }

    @Override
    public boolean[] getTruncationInfo() {
        return (boolean[])this.truncationResult.truncated().clone();
    }

    @Override
    public TaskType taskType() {
        return TaskType.TEXT_EMBEDDING;
    }

    public void executeEmbeddingsRequest(AmazonBedrockBaseClient awsBedrockClient, AmazonBedrockEmbeddingsResponseListener embeddingsResponseListener) {
        this.listener = embeddingsResponseListener;
        this.executeRequest(awsBedrockClient);
    }
}

