/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.elasticsearch.xpack.eql.execution.search.MillisTimestamp;
import org.elasticsearch.xpack.eql.execution.search.NanosTimestamp;

public abstract class Timestamp {
    static final long MILLIS_PER_SECOND = 1000L;
    static final long NANOS_PER_MILLI = 1000000L;
    private static final long[] MICROS_MULTIPLIER = new long[]{0L, 100000L, 10000L, 1000L, 100L, 10L};
    private String source;

    public abstract Instant instant();

    int compareTo(Timestamp other) {
        return this.instant().compareTo(other.instant());
    }

    public static Timestamp of(String milliseconds) {
        Timestamp timestamp;
        int dotIndex = milliseconds.lastIndexOf(46);
        if (dotIndex > 0) {
            long millis = Long.parseLong(milliseconds.substring(0, dotIndex));
            int digits = milliseconds.length() - dotIndex - 1;
            long micros = digits >= 6 ? Long.parseLong(milliseconds.substring(dotIndex + 1, dotIndex + 1 + 6)) : Long.parseLong(milliseconds.substring(dotIndex + 1)) * MICROS_MULTIPLIER[digits];
            timestamp = new NanosTimestamp(millis, micros);
        } else {
            timestamp = new MillisTimestamp(Long.parseLong(milliseconds));
        }
        timestamp.source = milliseconds;
        return timestamp;
    }

    public long delta(Timestamp other) {
        return other.instant().until(this.instant(), ChronoUnit.NANOS);
    }

    public String toString() {
        return this.source != null ? this.source : this.asString();
    }

    abstract String asString();
}

