/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.xpack.eql.execution.search.Limit;
import org.elasticsearch.xpack.eql.plan.logical.AbstractJoin;
import org.elasticsearch.xpack.eql.plan.logical.KeyedFilter;
import org.elasticsearch.xpack.eql.plan.logical.LimitWithOffset;
import org.elasticsearch.xpack.eql.plan.logical.Sample;
import org.elasticsearch.xpack.eql.plan.logical.Sequence;
import org.elasticsearch.xpack.eql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.eql.plan.physical.FilterExec;
import org.elasticsearch.xpack.eql.plan.physical.LimitWithOffsetExec;
import org.elasticsearch.xpack.eql.plan.physical.LocalExec;
import org.elasticsearch.xpack.eql.plan.physical.LocalRelation;
import org.elasticsearch.xpack.eql.plan.physical.OrderExec;
import org.elasticsearch.xpack.eql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.eql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.eql.plan.physical.SampleExec;
import org.elasticsearch.xpack.eql.plan.physical.SequenceExec;
import org.elasticsearch.xpack.eql.plan.physical.UnplannedExec;
import org.elasticsearch.xpack.eql.querydsl.container.QueryContainer;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Foldables;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.ReflectionUtils;

class Mapper
extends RuleExecutor<PhysicalPlan> {
    Mapper() {
    }

    PhysicalPlan map(LogicalPlan plan) {
        return (PhysicalPlan)this.execute((Node)Mapper.planLater(plan));
    }

    protected Iterable<RuleExecutor.Batch<PhysicalPlan>> batches() {
        RuleExecutor.Batch conversion = new RuleExecutor.Batch("Mapping", new Rule[]{new SimpleExecMapper()});
        return Arrays.asList(conversion);
    }

    private static PhysicalPlan planLater(LogicalPlan plan) {
        return new UnplannedExec(plan.source(), plan);
    }

    private static class SimpleExecMapper
    extends MapExecRule<LogicalPlan> {
        private SimpleExecMapper() {
        }

        @Override
        protected PhysicalPlan map(LogicalPlan p) {
            if (p instanceof AbstractJoin) {
                AbstractJoin join = (AbstractJoin)p;
                ArrayList<List<Attribute>> keys = new ArrayList<List<Attribute>>(join.children().size());
                boolean[] missing = new boolean[join.children().size()];
                ArrayList<PhysicalPlan> matches = new ArrayList<PhysicalPlan>(keys.size());
                for (int i = 0; i < join.queries().size(); ++i) {
                    KeyedFilter keyed = join.queries().get(i);
                    keys.add(Expressions.asAttributes(keyed.keys()));
                    matches.add(this.map(keyed.child()));
                    missing[i] = keyed.isMissingEventFilter();
                }
                if (p instanceof Sample) {
                    Sample sample = (Sample)p;
                    return new SampleExec(p.source(), matches, keys);
                }
                Sequence s = (Sequence)p;
                return new SequenceExec(p.source(), keys, matches, Expressions.asAttributes(s.until().keys()), this.map(s.until().child()), s.timestamp(), s.tiebreaker(), s.direction(), s.maxSpan(), missing);
            }
            if (p instanceof LocalRelation) {
                return new LocalExec(p.source(), ((LocalRelation)p).executable());
            }
            if (p instanceof Project) {
                Project pj = (Project)p;
                return new ProjectExec(p.source(), this.map(pj.child()), pj.projections());
            }
            if (p instanceof Filter) {
                Filter fl = (Filter)p;
                return new FilterExec(p.source(), this.map(fl.child()), fl.condition());
            }
            if (p instanceof OrderBy) {
                OrderBy o = (OrderBy)p;
                return new OrderExec(p.source(), this.map(o.child()), o.order());
            }
            if (p instanceof LimitWithOffset) {
                LimitWithOffset l = (LimitWithOffset)p;
                int limit = (Integer)DataTypeConverter.convert((Object)Foldables.valueOf((Expression)l.limit()), (DataType)DataTypes.INTEGER);
                return new LimitWithOffsetExec(p.source(), this.map(l.child()), new Limit(limit, l.offset()));
            }
            if (p instanceof EsRelation) {
                EsRelation c = (EsRelation)p;
                List output = c.output();
                QueryContainer container = new QueryContainer();
                if (c.frozen()) {
                    container = container.withFrozen();
                }
                return new EsQueryExec(p.source(), output, container);
            }
            return Mapper.planLater(p);
        }
    }

    static abstract class MapExecRule<SubPlan extends LogicalPlan>
    extends Rule<UnplannedExec, PhysicalPlan> {
        private final Class<SubPlan> subPlanToken = ReflectionUtils.detectSuperTypeForRuleLike(((Object)((Object)this)).getClass());

        MapExecRule() {
        }

        public final PhysicalPlan apply(PhysicalPlan plan) {
            return (PhysicalPlan)plan.transformUp(UnplannedExec.class, this::rule);
        }

        protected final PhysicalPlan rule(UnplannedExec plan) {
            LogicalPlan subPlan = plan.plan();
            if (this.subPlanToken.isInstance(subPlan)) {
                return this.map(subPlan);
            }
            return plan;
        }

        protected abstract PhysicalPlan map(SubPlan var1);
    }
}

