/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.string.CaseInsensitiveScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.expression.gen.script.Scripts;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class BinaryComparisonCaseInsensitiveFunction
extends CaseInsensitiveScalarFunction {
    private final Expression left;
    private final Expression right;

    protected BinaryComparisonCaseInsensitiveFunction(Source source, Expression left, Expression right, boolean caseInsensitive) {
        super(source, Arrays.asList(left, right), caseInsensitive);
        this.left = left;
        this.right = right;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution sourceResolution = TypeResolutions.isStringAndExact(this.left, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST);
        if (sourceResolution.unresolved()) {
            return sourceResolution;
        }
        return TypeResolutions.isStringAndExact(this.right, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND);
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    @Override
    public boolean foldable() {
        return this.left.foldable() && this.right.foldable();
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate leftScript = this.asScript(this.left);
        ScriptTemplate rightScript = this.asScript(this.right);
        return this.asScriptFrom(leftScript, rightScript);
    }

    protected ScriptTemplate asScriptFrom(ScriptTemplate leftScript, ScriptTemplate rightScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("%s.%s(%s,%s,%s)"), Scripts.classPackageAsPrefix(this.getClass()), this.scriptMethodName(), leftScript.template(), rightScript.template(), "{}"), ParamsBuilder.paramsBuilder().script(leftScript.params()).script(rightScript.params()).variable(this.isCaseInsensitive()).build(), this.dataType());
    }

    protected String scriptMethodName() {
        String simpleName = this.getClass().getSimpleName();
        return Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right, this.isCaseInsensitive());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryComparisonCaseInsensitiveFunction other = (BinaryComparisonCaseInsensitiveFunction)obj;
        return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right) && Objects.equals(this.isCaseInsensitive(), other.isCaseInsensitive());
    }
}

