/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.rest.action;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.action.GetTransformAction;
import org.elasticsearch.xpack.core.transform.action.PreviewTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPreviewTransformAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_transform/_preview"), new RestHandler.Route(RestRequest.Method.GET, "/_transform/{id}/_preview"), new RestHandler.Route(RestRequest.Method.POST, "/_transform/_preview"), new RestHandler.Route(RestRequest.Method.POST, "/_transform/{id}/_preview"));
    }

    public String getName() {
        return "transform_preview_transform_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        String transformId = restRequest.param(TransformField.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)transformId) && !restRequest.hasContentOrSourceParam()) {
            throw ExceptionsHelper.badRequestException((String)"Please provide a transform [{}] or the config object", (Object[])new Object[]{TransformField.ID.getPreferredName()});
        }
        if (!Strings.isNullOrEmpty((String)transformId) && restRequest.hasContentOrSourceParam()) {
            throw ExceptionsHelper.badRequestException((String)"Please provide either a transform [{}] or the config object but not both", (Object[])new Object[]{TransformField.ID.getPreferredName()});
        }
        TimeValue timeout = restRequest.paramAsTime(TransformField.TIMEOUT.getPreferredName(), AcknowledgedRequest.DEFAULT_ACK_TIMEOUT);
        SetOnce previewRequestHolder = new SetOnce();
        if (Strings.isNullOrEmpty((String)transformId)) {
            previewRequestHolder.set((Object)PreviewTransformAction.Request.fromXContent((XContentParser)restRequest.contentOrSourceParamParser(), (TimeValue)timeout));
        }
        RestCancellableNodeClient client = new RestCancellableNodeClient(nodeClient, restRequest.getHttpChannel());
        return arg_0 -> RestPreviewTransformAction.lambda$prepareRequest$1(transformId, previewRequestHolder, (Client)client, timeout, arg_0);
    }

    private static /* synthetic */ void lambda$prepareRequest$1(String transformId, SetOnce previewRequestHolder, Client client, TimeValue timeout, RestChannel channel) throws Exception {
        RestToXContentListener listener = new RestToXContentListener(channel);
        if (Strings.isNullOrEmpty((String)transformId)) {
            PreviewTransformAction.Request previewRequest = (PreviewTransformAction.Request)previewRequestHolder.get();
            client.execute((ActionType)PreviewTransformAction.INSTANCE, (ActionRequest)previewRequest, (ActionListener)listener);
        } else {
            GetTransformAction.Request getRequest = new GetTransformAction.Request(transformId);
            getRequest.setAllowNoResources(false);
            client.execute((ActionType)GetTransformAction.INSTANCE, (ActionRequest)getRequest, ActionListener.wrap(getResponse -> {
                List transforms = getResponse.getResources().results();
                if (transforms.size() > 1) {
                    listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"expected only one config but matched {}", (Object[])new Object[]{transforms.stream().map(TransformConfig::getId).collect(Collectors.toList())}));
                } else {
                    PreviewTransformAction.Request previewRequest = new PreviewTransformAction.Request((TransformConfig)transforms.get(0), timeout);
                    client.execute((ActionType)PreviewTransformAction.INSTANCE, (ActionRequest)previewRequest, (ActionListener)listener);
                }
            }, arg_0 -> ((RestToXContentListener)listener).onFailure(arg_0)));
        }
    }
}

