/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Match;

public class MatchOperator
extends Match {
    @FunctionInfo(returnType={"boolean"}, operator=":", preview=true, description="Use the match operator (`:`) to perform a <<query-dsl-match-query,match query>> on the specified field.\nUsing `:` is equivalent to using the `match` query in the Elasticsearch Query DSL.\n\nThe match operator is equivalent to the <<esql-match,match function>>.\n\nFor using the function syntax, or adding <<match-field-params,match query parameters>>, you can use the\n<<esql-match,match function>>.\n\n`:` returns true if the provided query matches the row.", examples={@Example(file="match-function", tag="match-with-field")})
    public MatchOperator(Source source, @Param(name="field", type={"keyword", "text", "boolean", "date", "date_nanos", "double", "integer", "ip", "long", "unsigned_long", "version"}, description="Field that the query will target.") Expression field, @Param(name="query", type={"keyword", "boolean", "date", "date_nanos", "double", "integer", "ip", "long", "unsigned_long", "version"}, description="Value to find in the provided field.") Expression matchQuery) {
        super(source, field, matchQuery, null, null);
    }

    private MatchOperator(Source source, Expression field, Expression matchQuery, QueryBuilder queryBuilder) {
        super(source, field, matchQuery, null, queryBuilder);
    }

    @Override
    public String functionType() {
        return "operator";
    }

    public String functionName() {
        return ":";
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MatchOperator::new, (Object)this.field(), (Object)this.query());
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new MatchOperator(this.source(), newChildren.get(0), newChildren.get(1), this.queryBuilder());
    }

    @Override
    public Expression replaceQueryBuilder(QueryBuilder queryBuilder) {
        return new MatchOperator(this.source(), this.field, this.query(), queryBuilder);
    }
}

