/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDegrees;

public final class ToDegreesEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private final EvalOperator.ExpressionEvaluator deg;

    public ToDegreesEvaluator(Source source, EvalOperator.ExpressionEvaluator deg, DriverContext driverContext) {
        super(driverContext, source);
        this.deg = deg;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.deg;
    }

    @Override
    public Block evalVector(Vector v) {
        DoubleVector vector = (DoubleVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantDoubleBlockWith(this.evalValue(vector, 0), positionCount);
            }
            catch (ArithmeticException e) {
                this.registerException(e);
                return this.driverContext.blockFactory().newConstantNullBlock(positionCount);
            }
        }
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    builder.appendDouble(this.evalValue(vector, p));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.registerException(e);
                    builder.appendNull();
                }
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private double evalValue(DoubleVector container, int index) {
        double value = container.getDouble(index);
        return ToDegrees.process(value);
    }

    @Override
    public Block evalBlock(Block b) {
        DoubleBlock block = (DoubleBlock)b;
        int positionCount = block.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        double value = this.evalValue(block, i);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendDouble(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (ArithmeticException e) {
                        this.registerException(e);
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private double evalValue(DoubleBlock container, int index) {
        double value = container.getDouble(index);
        return ToDegrees.process(value);
    }

    public String toString() {
        return "ToDegreesEvaluator[deg=" + String.valueOf(this.deg) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.deg);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory deg;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory deg) {
            this.source = source;
            this.deg = deg;
        }

        public ToDegreesEvaluator get(DriverContext context) {
            return new ToDegreesEvaluator(this.source, this.deg.get(context), context);
        }

        public String toString() {
            return "ToDegreesEvaluator[deg=" + String.valueOf(this.deg) + "]";
        }
    }
}

