/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.formatter;

import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.MediaType;
import org.elasticsearch.xpack.core.esql.action.ColumnInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;
import org.elasticsearch.xpack.esql.formatter.TextFormatter;

public enum TextFormat implements MediaType
{
    PLAIN_TEXT{

        @Override
        public Iterator<CheckedConsumer<Writer, IOException>> format(RestRequest request, EsqlQueryResponse esqlResponse) {
            boolean dropNullColumns = request.paramAsBoolean(TextFormat.DROP_NULL_COLUMNS_OPTION, false);
            return new TextFormatter(esqlResponse, this.hasHeader(request), dropNullColumns).format();
        }

        public String queryParameter() {
            return TextFormat.FORMAT_TEXT;
        }

        @Override
        String contentType() {
            return TextFormat.CONTENT_TYPE_TXT;
        }

        @Override
        protected Character delimiter() {
            assert (false);
            throw new UnsupportedOperationException("plain text does not specify a delimiter character");
        }

        @Override
        protected String eol() {
            assert (false);
            throw new UnsupportedOperationException("plain text does not specify an end of line character");
        }

        public Set<MediaType.HeaderValue> headerValues() {
            return Set.of(new MediaType.HeaderValue(TextFormat.CONTENT_TYPE_TXT, Map.of(TextFormat.URL_PARAM_HEADER, "present|absent")), new MediaType.HeaderValue(TextFormat.VENDOR_CONTENT_TYPE_TXT, Map.of(TextFormat.URL_PARAM_HEADER, "present|absent", "compatible-with", "\\d+")));
        }

        @Override
        void writeEscaped(String value, Character delimiter, Writer writer) {
            assert (false);
            throw new UnsupportedOperationException("plain text does not use writeEscaped()");
        }
    }
    ,
    CSV{

        @Override
        protected Character delimiter() {
            return Character.valueOf(',');
        }

        @Override
        protected String eol() {
            return "\r\n";
        }

        public String queryParameter() {
            return TextFormat.FORMAT_CSV;
        }

        @Override
        String contentType() {
            return TextFormat.CONTENT_TYPE_CSV;
        }

        @Override
        public String contentType(RestRequest request) {
            return this.contentType() + "; charset=utf-8; header=" + (this.hasHeader(request) ? TextFormat.PARAM_HEADER_PRESENT : TextFormat.PARAM_HEADER_ABSENT);
        }

        @Override
        protected Character delimiter(RestRequest request) {
            String delimiterParam = request.param(TextFormat.URL_PARAM_DELIMITER);
            if (delimiterParam == null) {
                return this.delimiter();
            }
            if ((delimiterParam = URLDecoder.decode(delimiterParam, StandardCharsets.UTF_8)).length() != 1) {
                throw new IllegalArgumentException("invalid " + (delimiterParam.length() > 0 ? "multi-character" : "empty") + " delimiter [" + delimiterParam + "]");
            }
            Character delimiter = Character.valueOf(delimiterParam.charAt(0));
            switch (delimiter.charValue()) {
                case '\n': 
                case '\r': 
                case '\"': {
                    throw new IllegalArgumentException("illegal reserved character specified as delimiter [" + delimiter + "]");
                }
                case '\t': {
                    throw new IllegalArgumentException("illegal delimiter [TAB] specified as delimiter for the [csv] format; choose the [tsv] format instead");
                }
            }
            return delimiter;
        }

        @Override
        void writeEscaped(String value, Character delimiter, Writer writer) throws IOException {
            int remainderStart = -1;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (remainderStart == -1 && (c == '\"' || c == '\n' || c == '\r' || c == delimiter.charValue())) {
                    writer.write(34);
                    remainderStart = 0;
                }
                if (c != '\"') continue;
                writer.append(value, remainderStart, i + 1);
                writer.write(34);
                remainderStart = i + 1;
            }
            if (remainderStart == -1) {
                writer.write(value);
            } else {
                writer.append(value, remainderStart, value.length());
                writer.write(34);
            }
        }

        @Override
        boolean hasHeader(RestRequest request) {
            String header = request.param(TextFormat.URL_PARAM_HEADER);
            if (header == null) {
                List values = request.getAllHeaderValues("Accept");
                if (values != null) {
                    for (String value : values) {
                        String[] params;
                        for (String param : params = Strings.tokenizeToStringArray((String)value, (String)";")) {
                            if (!param.toLowerCase(Locale.ROOT).equals("header=absent")) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
            return !header.toLowerCase(Locale.ROOT).equals(TextFormat.PARAM_HEADER_ABSENT);
        }

        public Set<MediaType.HeaderValue> headerValues() {
            return Set.of(new MediaType.HeaderValue(TextFormat.CONTENT_TYPE_CSV, Map.of(TextFormat.URL_PARAM_HEADER, "present|absent", TextFormat.URL_PARAM_DELIMITER, ".+")), new MediaType.HeaderValue(TextFormat.VENDOR_CONTENT_TYPE_CSV, Map.of(TextFormat.URL_PARAM_HEADER, "present|absent", TextFormat.URL_PARAM_DELIMITER, ".+", "compatible-with", "\\d+")));
        }
    }
    ,
    TSV{

        @Override
        protected Character delimiter() {
            return Character.valueOf('\t');
        }

        @Override
        protected String eol() {
            return "\n";
        }

        public String queryParameter() {
            return TextFormat.FORMAT_TSV;
        }

        @Override
        String contentType() {
            return TextFormat.CONTENT_TYPE_TSV;
        }

        @Override
        public String contentType(RestRequest request) {
            return this.contentType() + "; charset=utf-8";
        }

        @Override
        void writeEscaped(String value, Character delimiter, Writer writer) throws IOException {
            int remainderStart = 0;
            block4: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\n': {
                        writer.append(value, remainderStart, i);
                        writer.write("\\n");
                        remainderStart = i + 1;
                        continue block4;
                    }
                    case '\t': {
                        writer.append(value, remainderStart, i);
                        writer.write("\\t");
                        remainderStart = i + 1;
                    }
                }
            }
            writer.append(value, remainderStart, value.length());
        }

        public Set<MediaType.HeaderValue> headerValues() {
            return Set.of(new MediaType.HeaderValue(TextFormat.CONTENT_TYPE_TSV, Map.of(TextFormat.URL_PARAM_HEADER, "present|absent")), new MediaType.HeaderValue(TextFormat.VENDOR_CONTENT_TYPE_TSV, Map.of(TextFormat.URL_PARAM_HEADER, "present|absent", "compatible-with", "\\d+")));
        }
    };

    private static final String FORMAT_TEXT = "txt";
    private static final String FORMAT_CSV = "csv";
    private static final String FORMAT_TSV = "tsv";
    private static final String CONTENT_TYPE_TXT = "text/plain";
    private static final String VENDOR_CONTENT_TYPE_TXT = "text/vnd.elasticsearch+plain";
    private static final String CONTENT_TYPE_CSV = "text/csv";
    private static final String VENDOR_CONTENT_TYPE_CSV = "text/vnd.elasticsearch+csv";
    private static final String CONTENT_TYPE_TSV = "text/tab-separated-values";
    private static final String VENDOR_CONTENT_TYPE_TSV = "text/vnd.elasticsearch+tab-separated-values";
    private static final String URL_PARAM_HEADER = "header";
    private static final String PARAM_HEADER_ABSENT = "absent";
    private static final String PARAM_HEADER_PRESENT = "present";
    public static final String URL_PARAM_FORMAT = "format";
    public static final String URL_PARAM_DELIMITER = "delimiter";
    public static final String DROP_NULL_COLUMNS_OPTION = "drop_null_columns";

    public Iterator<CheckedConsumer<Writer, IOException>> format(RestRequest request, EsqlQueryResponse esqlResponse) {
        Character delimiter = this.delimiter(request);
        boolean dropNullColumns = request.paramAsBoolean(DROP_NULL_COLUMNS_OPTION, false);
        boolean[] dropColumns = dropNullColumns ? esqlResponse.nullColumns() : new boolean[esqlResponse.columns().size()];
        return Iterators.concat((Iterator[])new Iterator[]{this.hasHeader(request) && esqlResponse.columns() != null ? Iterators.single(writer -> this.row((Writer)writer, (Iterator)esqlResponse.columns().iterator(), ColumnInfo::name, delimiter, dropColumns)) : Collections.emptyIterator(), Iterators.map(esqlResponse.values(), row -> writer -> this.row((Writer)writer, (Iterator)row, f -> Objects.toString(f, ""), delimiter, dropColumns))});
    }

    boolean hasHeader(RestRequest request) {
        return true;
    }

    abstract String contentType();

    public String contentType(RestRequest request) {
        return this.contentType();
    }

    <F> void row(Writer writer, Iterator<F> row, Function<F, String> toString, Character delimiter, boolean[] dropColumns) throws IOException {
        boolean firstColumn = true;
        int i = 0;
        while (row.hasNext()) {
            if (dropColumns[i]) {
                row.next();
            } else {
                if (firstColumn) {
                    firstColumn = false;
                } else {
                    writer.append(delimiter.charValue());
                }
                this.writeEscaped(toString.apply(row.next()), delimiter, writer);
            }
            ++i;
        }
        writer.append(this.eol());
    }

    protected abstract Character delimiter();

    protected Character delimiter(RestRequest request) {
        return this.delimiter();
    }

    protected abstract String eol();

    abstract void writeEscaped(String var1, Character var2, Writer var3) throws IOException;
}

