/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.stringstats;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.analytics.stringstats.StringStatsAggregationBuilder;
import org.elasticsearch.xpack.analytics.stringstats.StringStatsAggregator;
import org.elasticsearch.xpack.analytics.stringstats.StringStatsAggregatorSupplier;

class StringStatsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final StringStatsAggregatorSupplier aggregatorSupplier;
    private final boolean showDistribution;

    StringStatsAggregatorFactory(String name, ValuesSourceConfig config, Boolean showDistribution, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, StringStatsAggregatorSupplier aggregatorSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.aggregatorSupplier = aggregatorSupplier;
        this.showDistribution = showDistribution;
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(StringStatsAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.KEYWORD, StringStatsAggregator::new, true);
    }

    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new StringStatsAggregator(this.name, null, this.showDistribution, this.config.format(), this.context, parent, metadata);
    }

    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.aggregatorSupplier.build(this.name, this.config.getValuesSource(), this.showDistribution, this.config.format(), this.context, parent, metadata);
    }
}

