/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.autoscaling.AutoscalingMetadata;
import org.elasticsearch.xpack.autoscaling.action.DeleteAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.TransportPutAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicyMetadata;

public class TransportDeleteAutoscalingPolicyAction
extends AcknowledgedTransportMasterNodeAction<DeleteAutoscalingPolicyAction.Request> {
    private static final Logger LOGGER = LogManager.getLogger(TransportPutAutoscalingPolicyAction.class);

    @Inject
    public TransportDeleteAutoscalingPolicyAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super("cluster:admin/autoscaling/delete_autoscaling_policy", transportService, clusterService, threadPool, actionFilters, DeleteAutoscalingPolicyAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void masterOperation(Task task, final DeleteAutoscalingPolicyAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.submitUnbatchedTask("delete-autoscaling-policy", (ClusterStateUpdateTask)new AckedClusterStateUpdateTask(this, request, listener){

            public ClusterState execute(ClusterState currentState) {
                return TransportDeleteAutoscalingPolicyAction.deleteAutoscalingPolicy(currentState, request.name(), LOGGER);
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    protected ClusterBlockException checkBlock(DeleteAutoscalingPolicyAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    static ClusterState deleteAutoscalingPolicy(ClusterState currentState, String name) {
        return TransportDeleteAutoscalingPolicyAction.deleteAutoscalingPolicy(currentState, name, LOGGER);
    }

    static ClusterState deleteAutoscalingPolicy(ClusterState currentState, String name, Logger logger) {
        ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
        AutoscalingMetadata currentMetadata = currentState.metadata().custom("autoscaling") != null ? (AutoscalingMetadata)currentState.metadata().custom("autoscaling") : AutoscalingMetadata.EMPTY;
        boolean wildcard = Regex.isSimpleMatchPattern((String)name);
        if (!wildcard && !currentMetadata.policies().containsKey(name)) {
            throw new ResourceNotFoundException("autoscaling policy with name [" + name + "] does not exist", new Object[0]);
        }
        TreeMap<String, AutoscalingPolicyMetadata> newPolicies = new TreeMap<String, AutoscalingPolicyMetadata>(currentMetadata.policies());
        if (wildcard) {
            newPolicies.keySet().removeIf(key -> Regex.simpleMatch((String)name, (String)key));
            logger.info("deleting [{}] autoscaling policies", (Object)(currentMetadata.policies().size() - newPolicies.size()));
        } else {
            AutoscalingPolicyMetadata policy = (AutoscalingPolicyMetadata)newPolicies.remove(name);
            assert (policy != null) : name;
            logger.info("deleting autoscaling policy [{}]", (Object)name);
        }
        AutoscalingMetadata newMetadata = new AutoscalingMetadata(newPolicies);
        builder.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("autoscaling", (Metadata.Custom)newMetadata).build());
        return builder.build();
    }

    public Optional<String> reservedStateHandlerName() {
        return Optional.of("autoscaling");
    }

    public Set<String> modifiedKeys(DeleteAutoscalingPolicyAction.Request request) {
        return Set.of(request.name());
    }
}

