/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.capacity;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;

public class AutoscalingDeciderResults
implements ToXContentObject,
Writeable {
    private final AutoscalingCapacity currentCapacity;
    private final SortedSet<DiscoveryNode> currentNodes;
    private final SortedMap<String, AutoscalingDeciderResult> results;

    public Map<String, AutoscalingDeciderResult> results() {
        return this.results;
    }

    public AutoscalingDeciderResults(AutoscalingCapacity currentCapacity, SortedSet<DiscoveryNode> currentNodes, SortedMap<String, AutoscalingDeciderResult> results) {
        Objects.requireNonNull(currentCapacity);
        this.currentCapacity = currentCapacity;
        this.currentNodes = Objects.requireNonNull(currentNodes);
        Objects.requireNonNull(results);
        if (results.isEmpty()) {
            throw new IllegalArgumentException("results can not be empty");
        }
        this.results = results;
    }

    public AutoscalingDeciderResults(StreamInput in) throws IOException {
        this.currentCapacity = new AutoscalingCapacity(in);
        this.currentNodes = in.readCollectionAsSet(DiscoveryNode::new).stream().collect(Collectors.toCollection(() -> new TreeSet(DiscoveryNode.DISCOVERY_NODE_COMPARATOR)));
        this.results = new TreeMap<String, AutoscalingDeciderResult>(in.readMap(AutoscalingDeciderResult::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.currentCapacity.writeTo(out);
        out.writeCollection(this.currentNodes);
        out.writeMap(this.results, StreamOutput::writeWriteable);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        AutoscalingCapacity requiredCapacity = this.requiredCapacity();
        if (requiredCapacity != null) {
            builder.field("required_capacity", (ToXContent)requiredCapacity);
        }
        builder.field("current_capacity", (ToXContent)this.currentCapacity);
        builder.startArray("current_nodes");
        for (DiscoveryNode discoveryNode : this.currentNodes) {
            builder.startObject();
            builder.field("name", discoveryNode.getName());
            builder.endObject();
        }
        builder.endArray();
        builder.startObject("deciders");
        for (Map.Entry entry : this.results.entrySet()) {
            builder.startObject((String)entry.getKey());
            ((AutoscalingDeciderResult)entry.getValue()).toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public AutoscalingCapacity requiredCapacity() {
        if (this.results.values().stream().map(AutoscalingDeciderResult::requiredCapacity).anyMatch(Objects::isNull)) {
            return null;
        }
        Optional<AutoscalingCapacity> result = this.results.values().stream().map(AutoscalingDeciderResult::requiredCapacity).reduce(AutoscalingCapacity::upperBound);
        assert (result.isPresent());
        return result.get();
    }

    public AutoscalingCapacity currentCapacity() {
        return this.currentCapacity;
    }

    public SortedSet<DiscoveryNode> currentNodes() {
        return this.currentNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoscalingDeciderResults that = (AutoscalingDeciderResults)o;
        return this.currentCapacity.equals(that.currentCapacity) && this.results.equals(that.results);
    }

    public int hashCode() {
        return Objects.hash(this.currentCapacity, this.results);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

