/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PredicateFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.type.context.NumberContext;

public final class PrimitiveFunction
extends FunctionSet<Double> {
    private static final PrimitiveFunction SET = new PrimitiveFunction();

    public static PrimitiveFunction getSet() {
        return SET;
    }

    private PrimitiveFunction() {
    }

    @Override
    public UnaryFunction<Double> abs() {
        return PrimitiveMath.ABS;
    }

    @Override
    public UnaryFunction<Double> acos() {
        return PrimitiveMath.ACOS;
    }

    @Override
    public UnaryFunction<Double> acosh() {
        return PrimitiveMath.ACOSH;
    }

    @Override
    public BinaryFunction<Double> add() {
        return PrimitiveMath.ADD;
    }

    @Override
    public AggregatorSet<Double> aggregator() {
        return PrimitiveAggregator.getSet();
    }

    @Override
    public UnaryFunction<Double> asin() {
        return PrimitiveMath.ASIN;
    }

    @Override
    public UnaryFunction<Double> asinh() {
        return PrimitiveMath.ASINH;
    }

    @Override
    public UnaryFunction<Double> atan() {
        return PrimitiveMath.ATAN;
    }

    @Override
    public BinaryFunction<Double> atan2() {
        return PrimitiveMath.ATAN2;
    }

    @Override
    public UnaryFunction<Double> atanh() {
        return PrimitiveMath.ATANH;
    }

    @Override
    public UnaryFunction<Double> cardinality() {
        return PrimitiveMath.CARDINALITY;
    }

    @Override
    public UnaryFunction<Double> cbrt() {
        return PrimitiveMath.CBRT;
    }

    @Override
    public UnaryFunction<Double> ceil() {
        return PrimitiveMath.CEIL;
    }

    @Override
    public UnaryFunction<Double> conjugate() {
        return PrimitiveMath.CONJUGATE;
    }

    @Override
    public UnaryFunction<Double> cos() {
        return PrimitiveMath.COS;
    }

    @Override
    public UnaryFunction<Double> cosh() {
        return PrimitiveMath.COSH;
    }

    @Override
    public BinaryFunction<Double> divide() {
        return PrimitiveMath.DIVIDE;
    }

    public Unary enforce(NumberContext context) {
        return t -> context.enforce(t);
    }

    @Override
    public UnaryFunction<Double> exp() {
        return PrimitiveMath.EXP;
    }

    @Override
    public UnaryFunction<Double> expm1() {
        return PrimitiveMath.EXPM1;
    }

    @Override
    public UnaryFunction<Double> floor() {
        return PrimitiveMath.FLOOR;
    }

    @Override
    public BinaryFunction<Double> hypot() {
        return PrimitiveMath.HYPOT;
    }

    @Override
    public UnaryFunction<Double> invert() {
        return PrimitiveMath.INVERT;
    }

    @Override
    public UnaryFunction<Double> log() {
        return PrimitiveMath.LOG;
    }

    @Override
    public UnaryFunction<Double> log10() {
        return PrimitiveMath.LOG10;
    }

    @Override
    public UnaryFunction<Double> log1p() {
        return PrimitiveMath.LOG1P;
    }

    @Override
    public UnaryFunction<Double> logistic() {
        return PrimitiveMath.LOGISTIC;
    }

    @Override
    public UnaryFunction<Double> logit() {
        return PrimitiveMath.LOGIT;
    }

    @Override
    public BinaryFunction<Double> max() {
        return PrimitiveMath.MAX;
    }

    @Override
    public BinaryFunction<Double> min() {
        return PrimitiveMath.MIN;
    }

    @Override
    public BinaryFunction<Double> multiply() {
        return PrimitiveMath.MULTIPLY;
    }

    @Override
    public UnaryFunction<Double> negate() {
        return PrimitiveMath.NEGATE;
    }

    @Override
    public BinaryFunction<Double> pow() {
        return PrimitiveMath.POW;
    }

    @Override
    public ParameterFunction<Double> power() {
        return PrimitiveMath.POWER;
    }

    @Override
    public UnaryFunction<Double> rint() {
        return PrimitiveMath.RINT;
    }

    @Override
    public ParameterFunction<Double> root() {
        return PrimitiveMath.ROOT;
    }

    @Override
    public ParameterFunction<Double> scale() {
        return PrimitiveMath.SCALE;
    }

    @Override
    public UnaryFunction<Double> signum() {
        return PrimitiveMath.SIGNUM;
    }

    @Override
    public UnaryFunction<Double> sin() {
        return PrimitiveMath.SIN;
    }

    @Override
    public UnaryFunction<Double> sinh() {
        return PrimitiveMath.SINH;
    }

    @Override
    public UnaryFunction<Double> sqrt() {
        return PrimitiveMath.SQRT;
    }

    @Override
    public UnaryFunction<Double> sqrt1px2() {
        return PrimitiveMath.SQRT1PX2;
    }

    @Override
    public BinaryFunction<Double> subtract() {
        return PrimitiveMath.SUBTRACT;
    }

    @Override
    public UnaryFunction<Double> tan() {
        return PrimitiveMath.TAN;
    }

    @Override
    public UnaryFunction<Double> tanh() {
        return PrimitiveMath.TANH;
    }

    @Override
    public UnaryFunction<Double> value() {
        return PrimitiveMath.VALUE;
    }

    @FunctionalInterface
    public static interface Unary
    extends UnaryFunction<Double> {
        @Override
        default public Double invoke(Double arg) {
            return this.invoke((double)arg);
        }
    }

    @FunctionalInterface
    public static interface Predicate
    extends PredicateFunction<Double> {
        @Override
        default public boolean invoke(Double arg) {
            return this.invoke((double)arg);
        }
    }

    @FunctionalInterface
    public static interface Parameter
    extends ParameterFunction<Double> {
        @Override
        default public Double invoke(Double arg, int param) {
            return this.invoke((double)arg, param);
        }
    }

    @FunctionalInterface
    public static interface Consumer
    extends VoidFunction<Double> {
        @Override
        default public void invoke(Double arg) {
            this.invoke((double)arg);
        }
    }

    @FunctionalInterface
    public static interface Binary
    extends BinaryFunction<Double> {
        @Override
        default public Double invoke(Double arg1, Double arg2) {
            return this.invoke((double)arg1, (double)arg2);
        }
    }
}

