/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.Optional;
import org.elasticsearch.compute.aggregation.spatial.SpatialAggregationUtils;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.SpatialEnvelopeVisitor;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;

public enum PointType {
    GEO{

        @Override
        public Optional<Rectangle> computeEnvelope(Geometry geo) {
            return SpatialEnvelopeVisitor.visitGeo((Geometry)geo, (SpatialEnvelopeVisitor.WrapLongitude)SpatialEnvelopeVisitor.WrapLongitude.WRAP);
        }

        @Override
        public int extractX(long encoded) {
            return SpatialAggregationUtils.extractSecond(encoded);
        }

        @Override
        public int extractY(long encoded) {
            return SpatialAggregationUtils.extractFirst(encoded);
        }

        @Override
        public CoordinateEncoder encoder() {
            return CoordinateEncoder.GEO;
        }
    }
    ,
    CARTESIAN{

        @Override
        public Optional<Rectangle> computeEnvelope(Geometry geo) {
            return SpatialEnvelopeVisitor.visitCartesian((Geometry)geo);
        }

        @Override
        public int extractX(long encoded) {
            return SpatialAggregationUtils.extractFirst(encoded);
        }

        @Override
        public int extractY(long encoded) {
            return SpatialAggregationUtils.extractSecond(encoded);
        }

        @Override
        public CoordinateEncoder encoder() {
            return CoordinateEncoder.CARTESIAN;
        }
    };


    public abstract Optional<Rectangle> computeEnvelope(Geometry var1);

    public abstract int extractX(long var1);

    public abstract int extractY(long var1);

    public abstract CoordinateEncoder encoder();
}

