/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatLookup;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.FloatVectorBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.ReleasableIterator;

final class FloatArrayVector
extends AbstractVector
implements FloatVector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FloatArrayVector.class) + RamUsageEstimator.shallowSizeOfInstance(FloatVectorBlock.class) + (long)Block.PAGE_MEM_OVERHEAD_PER_BLOCK;
    private final float[] values;

    FloatArrayVector(float[] values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FloatArrayVector readArrayVector(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        long preAdjustedBytes = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)positions * 4L;
        blockFactory.adjustBreaker(preAdjustedBytes);
        boolean success = false;
        try {
            float[] values = new float[positions];
            for (int i = 0; i < positions; ++i) {
                values[i] = in.readFloat();
            }
            FloatArrayVector block = new FloatArrayVector(values, positions, blockFactory);
            blockFactory.adjustBreaker(block.ramBytesUsed() - preAdjustedBytes);
            success = true;
            FloatArrayVector floatArrayVector = block;
            return floatArrayVector;
        }
        finally {
            if (!success) {
                blockFactory.adjustBreaker(-preAdjustedBytes);
            }
        }
    }

    void writeArrayVector(int positions, StreamOutput out) throws IOException {
        for (int i = 0; i < positions; ++i) {
            out.writeFloat(this.values[i]);
        }
    }

    @Override
    public FloatBlock asBlock() {
        return new FloatVectorBlock(this);
    }

    @Override
    public float getFloat(int position) {
        return this.values[position];
    }

    @Override
    public ElementType elementType() {
        return ElementType.FLOAT;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public FloatVector filter(int ... positions) {
        try (FloatVector.Builder builder = this.blockFactory().newFloatVectorBuilder(positions.length);){
            for (int pos : positions) {
                builder.appendFloat(this.values[pos]);
            }
            FloatVector floatVector = builder.build();
            return floatVector;
        }
    }

    @Override
    public FloatBlock keepMask(BooleanVector mask) {
        if (this.getPositionCount() == 0) {
            this.incRef();
            return new FloatVectorBlock(this);
        }
        if (mask.isConstant()) {
            if (mask.getBoolean(0)) {
                this.incRef();
                return new FloatVectorBlock(this);
            }
            return (FloatBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
        }
        try (FloatBlock.Builder builder = this.blockFactory().newFloatBlockBuilder(this.getPositionCount());){
            for (int p = 0; p < this.getPositionCount(); ++p) {
                if (mask.getBoolean(p)) {
                    builder.appendFloat(this.getFloat(p));
                    continue;
                }
                builder.appendNull();
            }
            FloatBlock floatBlock = builder.build();
            return floatBlock;
        }
    }

    public ReleasableIterator<FloatBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new FloatLookup(this.asBlock(), positions, targetBlockSize);
    }

    public static long ramBytesEstimated(float[] values) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((float[])values);
    }

    public long ramBytesUsed() {
        return FloatArrayVector.ramBytesEstimated(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FloatVector) {
            FloatVector that = (FloatVector)obj;
            return FloatVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return FloatVector.hash(this);
    }

    public String toString() {
        String valuesString = IntStream.range(0, this.getPositionCount()).limit(10L).mapToObj(n -> String.valueOf(this.values[n])).collect(Collectors.joining(", ", "[", this.getPositionCount() > 10 ? ", ...]" : "]"));
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + valuesString + "]";
    }
}

